/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.meta.Elimination;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EliminationProcessor {
    private EliminationChecker[] _checkers;

    public void prepare(Meta meta, List<AnalyticalField> dimensionFields, List<AnalyticalField> measureFields) {
        List<Elimination> eliminations = meta.getEliminations();
        if (eliminations == null || eliminations.isEmpty()) {
            return;
        }
        HashMap<String, String> oppositeMap = new HashMap<String, String>();
        HashMap<String, String> tableIdMap = new HashMap<String, String>();
        for (Elimination elimination : eliminations) {
            List<String> associatedFields = elimination.getAssociatedFields();
            String idField = elimination.getIdField();
            if (idField == null || associatedFields == null || associatedFields.isEmpty()) continue;
            for (String string : associatedFields) {
                oppositeMap.put(string, idField);
            }
            String[] twoParts = MetaField.decodeFullName(idField);
            if (twoParts[0] == null) continue;
            tableIdMap.put(twoParts[0], idField);
        }
        for (int i = 0; i < measureFields.size(); ++i) {
            Set<String> dependences;
            AnalyticalField field = measureFields.get(i);
            MetaField mf = field.getMetaField();
            if (MetaField.FormulaAggStatus.isRelativeAggregation(mf.getFormulaAggStatus()) || oppositeMap.containsKey(mf.getFullName()) || !mf.isCalculation() || (dependences = mf.getAllDependence()).isEmpty()) continue;
            HashSet<String> ids = new HashSet<String>();
            for (String dependence : dependences) {
                String id = (String)oppositeMap.get(dependence);
                ids.add(id);
            }
            if (ids.size() != 1) continue;
            String[] stringArray = new String[1];
            ids.toArray(stringArray);
            String idField = stringArray[0];
            if (idField == null) continue;
            oppositeMap.put(mf.getFullName(), idField);
        }
        this.initChecker(dimensionFields, measureFields, oppositeMap);
    }

    private void initChecker(List<AnalyticalField> dimensionFields, List<AnalyticalField> measureFields, Map<String, String> oppositeMap) {
        this._checkers = new EliminationChecker[measureFields.size()];
        for (int i = 0; i < measureFields.size(); ++i) {
            AnalyticalField field = measureFields.get(i);
            MetaField mf = field.getMetaField();
            String idField = oppositeMap.get(mf.getFullName());
            this._checkers[i] = idField != null ? new EliminationChecker(idField, dimensionFields) : null;
        }
    }

    public boolean isDuplicated(int measureIndex, CompositeKey cuboidCellKey, Map<String, ?> row) {
        if (this._checkers[measureIndex] == null) {
            return false;
        }
        return this._checkers[measureIndex].isExist(cuboidCellKey, row);
    }

    public boolean isDuplicated(int measureIndex, CompositeKey cuboidCellKey, CompositeKey parentCuboidCellKey) {
        if (this._checkers[measureIndex] == null) {
            return false;
        }
        return this._checkers[measureIndex].isExist(cuboidCellKey, parentCuboidCellKey);
    }

    public void release() {
        for (EliminationChecker checker : this._checkers) {
            if (checker == null) continue;
            checker.reset();
        }
    }

    private static class EliminationChecker {
        private String _idField;
        private int _idFieldInCuboidCellKeyIndexs;
        private Map<CompositeKey, HashSet<Object>> _appearedId = new HashMap<CompositeKey, HashSet<Object>>();

        public EliminationChecker(String idField, List<AnalyticalField> dimensionFields) {
            this._idField = idField;
            this.initForSubtotal(dimensionFields);
        }

        private void initForSubtotal(List<AnalyticalField> dimensionFields) {
            int idx = -1;
            for (int j = dimensionFields.size() - 1; j >= 0; --j) {
                if (!this._idField.equalsIgnoreCase(dimensionFields.get(j).getName())) continue;
                idx = j;
                break;
            }
            if (idx == -1) {
                this._idFieldInCuboidCellKeyIndexs = -1;
                return;
            }
            this._idFieldInCuboidCellKeyIndexs = idx;
        }

        public boolean isExist(CompositeKey cuboidCellKey, Map<String, ?> row) {
            Object idFieldValue = row.get(this._idField);
            HashSet<Object> appearedIdInCell = this._appearedId.get(cuboidCellKey);
            if (appearedIdInCell == null) {
                appearedIdInCell = new HashSet();
                appearedIdInCell.add(idFieldValue);
                this._appearedId.put(cuboidCellKey, appearedIdInCell);
                return false;
            }
            if (!appearedIdInCell.contains(idFieldValue)) {
                appearedIdInCell.add(idFieldValue);
                return false;
            }
            return true;
        }

        public boolean isExist(CompositeKey cuboidCellKey, CompositeKey parentCuboidCellKey) {
            if (this._idFieldInCuboidCellKeyIndexs < 0) {
                return false;
            }
            Object idFieldValue = parentCuboidCellKey.getMember(this._idFieldInCuboidCellKeyIndexs);
            if (idFieldValue == "com.kingdee.bos.qing.All") {
                return false;
            }
            HashSet<Object> appearedIdInCell = this._appearedId.get(cuboidCellKey);
            if (appearedIdInCell == null) {
                appearedIdInCell = new HashSet();
                appearedIdInCell.add(idFieldValue);
                this._appearedId.put(cuboidCellKey, appearedIdInCell);
                return false;
            }
            if (!appearedIdInCell.contains(idFieldValue)) {
                appearedIdInCell.add(idFieldValue);
                return false;
            }
            return true;
        }

        public void reset() {
            this._appearedId.clear();
        }
    }
}

