/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.engine.AbstractDataGetter;
import com.kingdee.bos.qing.core.engine.ContinuousPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.DiscretePreparedValueGainer;
import com.kingdee.bos.qing.core.engine.MultiValueGainer;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.InvalidMetaFieldException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.Order;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractPreparedValue;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.IDiscretePreparedValue;
import com.kingdee.bos.qing.core.model.meta.DataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FilterPreparedValueGainer {
    public static AbstractPreparedValueGainer create(AnalyticalField field, II18nContext i18nCtx) throws AnalysisException {
        if (field.getMetaField().isCalculation() && !field.getMetaField().isValidCalculation()) {
            throw InvalidMetaFieldException.createForFilterField();
        }
        DataType dataType = field.getDataType();
        if (dataType == DataType.NUMBER) {
            return new ContinuousPreparedValueGainer(field);
        }
        if (field.getDataType() == DataType.DATE && field.isContinuous()) {
            ContinuousPreparedValueGainer gainer = new ContinuousPreparedValueGainer(field);
            gainer.setForDate(true);
            return gainer;
        }
        if (field.isDimension()) {
            DiscretePreparedValueGainer gainer = new DiscretePreparedValueGainer(field, i18nCtx);
            gainer.setToSort(true);
            gainer.setAsc(field.getSort() != Order.DESC);
            gainer.setEmptyAheadAlways(false);
            return gainer;
        }
        if (field.isMeasure()) {
            return new ContinuousPreparedValueGainer(field);
        }
        throw new RuntimeException("Unknown role.");
    }

    public static class SharedMultiValueGainer
    extends MultiValueGainer {
        public SharedMultiValueGainer(AnalyticalField fieldForValue, AnalyticalField fieldForDisplay, AnalyticalField fieldForOrderBy, II18nContext i18nCtx) {
            super(fieldForValue, fieldForDisplay, fieldForOrderBy, i18nCtx);
        }
    }

    public static class GainerPeers {
        private DiscretePreparedValueGainer _real;
        private Boolean _appointedAsTree = null;

        public GainerPeers(AnalyticalField field, II18nContext i18nCtx) {
            this._real = new MyRealGainer(field, i18nCtx);
        }

        public void setAppointedAsTree(boolean isAppointedAsTree) {
            this._appointedAsTree = isAppointedAsTree;
        }

        public void gain(Object value) {
            this._real.gain(value);
        }

        public List<String> getAllPreparedValue() {
            ArrayList<String> result = new ArrayList<String>();
            AbstractPreparedValue pv = this._real.getFruit().getPreparedValue();
            if (pv instanceof IDiscretePreparedValue) {
                IDiscretePreparedValue dpvs = (IDiscretePreparedValue)((Object)pv);
                List<? extends IDiscretePreparedValue.IDiscreteItem> items = dpvs.getValues();
                for (IDiscretePreparedValue.IDiscreteItem iDiscreteItem : items) {
                    result.add(iDiscreteItem.getValue());
                }
            }
            return result;
        }

        private class MyRealGainer
        extends DiscretePreparedValueGainer {
            public MyRealGainer(AnalyticalField field, II18nContext i18nCtx) {
                super(field, i18nCtx);
            }

            @Override
            protected boolean isTreeStructure() {
                if (GainerPeers.this._appointedAsTree == null) {
                    return super.isTreeStructure();
                }
                return GainerPeers.this._appointedAsTree;
            }
        }
    }

    public static interface IPreparedValueFruit {
        public boolean isGainerInvalid();

        public AbstractPreparedValue getPreparedValue();
    }

    public static abstract class AbstractPreparedValueGainer {
        private AnalyticalField _field;
        private AbstractDataGetter _dataGetter;

        protected AbstractPreparedValueGainer(AnalyticalField field) {
            this._field = field;
        }

        public final AnalyticalField getField() {
            return this._field;
        }

        public final boolean isAggregation() {
            return this._field.isMeasure();
        }

        public final boolean isCanPullDown() {
            return this._field.isCanPullDown();
        }

        public final AbstractDataGetter getDataGetter(IExecuteContext ctx) {
            if (this._dataGetter == null) {
                this._dataGetter = AbstractDataGetter.create(this._field, ctx);
            }
            return this._dataGetter;
        }

        public final void gain(Object value) {
            if (value instanceof Collection) {
                Collection collectionValue = (Collection)value;
                for (Object item : collectionValue) {
                    this.doGain(item);
                }
            } else {
                this.doGain(value);
            }
        }

        protected abstract void doGain(Object var1);

        public abstract IPreparedValueFruit getFruit();

        public abstract long estimateHeapSize(int var1);
    }

    public static interface IDateReprocessing {
        public String toPromissoryValue(Object var1);
    }
}

