/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine.func;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractFunctionExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.func.IInfluenceForTotal;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.meta.CustomPeriod;
import com.kingdee.bos.qing.core.model.meta.DataType;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class AbstractInterlineFunction
extends AbstractFunctionExpr
implements IInfluenceForTotal {
    private IDateParser _parser;
    private int _runtimeTotalInfluencedReplacedMeasureIndex;

    public AbstractInterlineFunction(String name) {
        super(name);
    }

    public final String pretreat(List<AnalyticalField> dimensionFields) {
        this._parser = this.createDateParser(dimensionFields);
        return this.getPretreatDateField(this._parser);
    }

    public final int getReturnDataType() {
        return 2;
    }

    public final Object execute(IExecuteContext ctx) throws ExecuteException {
        return ctx.getValue((IExpr)this);
    }

    @Override
    public void setRuntimeTotalInfluencedReplacedMeasureIndex(int idx) {
        this._runtimeTotalInfluencedReplacedMeasureIndex = idx;
    }

    @Override
    public int getRuntimeTotalInfluencedReplacedMeasureIndex() {
        return this._runtimeTotalInfluencedReplacedMeasureIndex;
    }

    public final BigDecimal interlineExecute(IInterlineEnv interlineEnv) throws ExecuteException {
        if (!this._parser.isCalculable()) {
            return null;
        }
        return this.interlineExecuteImpl(interlineEnv, this._parser);
    }

    protected abstract BigDecimal interlineExecuteImpl(IInterlineEnv var1, IDateParser var2) throws ExecuteException;

    protected abstract IDateParser createDateParser(List<AnalyticalField> var1);

    protected String getPretreatDateField(IDateParser parser) {
        return null;
    }

    static class LastPeriodDateParser
    extends AbstractDateParser {
        private Interval _interval;
        private boolean _isNeedFixDay;

        public LastPeriodDateParser(List<AnalyticalField> dimensionFields) {
            super(dimensionFields);
        }

        public void setInterval(Interval interval) {
            this._interval = interval;
        }

        private boolean isInsideYear() {
            return this._interval == Interval.INSIDE_YEAR;
        }

        protected boolean isAccepted(CompositeKey dimKeyToCheckExist, Object[] dateMembers) {
            return true;
        }

        @Override
        public CompositeKey createAnotherDimensionKey(CompositeKey thisDimKey) {
            HashSet<CompositeKey> routed = new HashSet<CompositeKey>();
            boolean isTryAgain = true;
            try {
                CompositeKey current = thisDimKey;
                while (isTryAgain) {
                    routed.add(current);
                    Object[] dateMembers = new Object[this._dimIdxs.length];
                    current = this.createLastPeriodKey(current, dateMembers);
                    if (current == null || routed.contains(current)) {
                        return null;
                    }
                    isTryAgain = !this.isAccepted(current, dateMembers);
                }
                return current;
            }
            catch (OutsideIntervalException ex) {
                return null;
            }
        }

        private CompositeKey createLastPeriodKey(CompositeKey thisDimKey, Object[] members) throws OutsideIntervalException {
            this._isNeedFixDay = false;
            int period = -1;
            for (int partIdx = 0; partIdx < this._dimIdxs.length; ++partIdx) {
                int dimIdx = this._dimIdxs[partIdx];
                Object member = null;
                if (dimIdx >= 0) {
                    member = thisDimKey.getMember(dimIdx);
                    period = partIdx;
                }
                members[partIdx] = member;
            }
            boolean[] borrow = new boolean[this._dimIdxs.length];
            for (int partIdx = this._dimIdxs.length - 1; partIdx >= 0; --partIdx) {
                int dimIdx = this._dimIdxs[partIdx];
                if (dimIdx < 0) continue;
                Object member = members[partIdx];
                if (member == null) {
                    return null;
                }
                if (partIdx == 5 && period == 5) {
                    member = this.searchCustomPeriod(member, borrow);
                } else if (partIdx == 4 && period == 4) {
                    member = this._continuous[4] ? this.ymdForLastPeriod(member, borrow) : this.dayForLastPeriod(member, borrow);
                } else if (partIdx == 3 && (period == 3 || borrow[3])) {
                    member = this.monthForLastPeriod(member, borrow);
                } else if (partIdx == 2 && (period == 2 || borrow[2])) {
                    member = this.quarterForLastPeriod(member, borrow);
                } else if (partIdx == 1 && (period == 1 || borrow[1])) {
                    if (this.isInsideYear()) {
                        throw new OutsideIntervalException();
                    }
                    member = this.yearForLastPeriod(member);
                } else if (partIdx == 0 && (period == 0 || borrow[0])) {
                    if (this.isInsideYear()) {
                        throw new OutsideIntervalException();
                    }
                    member = this.searchCustomLastYear(member);
                }
                members[partIdx] = member;
            }
            this.fixDay(members);
            CompositeKey another = new CompositeKey();
            int c = thisDimKey.getMemberCount();
            for (int i = 0; i < c; ++i) {
                int partIdx = -1;
                for (int j = 0; j < this._dimIdxs.length; ++j) {
                    if (i != this._dimIdxs[j]) continue;
                    partIdx = j;
                    break;
                }
                Object member = partIdx < 0 ? thisDimKey.getMember(i) : members[partIdx];
                another.addMember(member);
            }
            return another;
        }

        private void fixDay(Object[] members) {
            if (!this._isNeedFixDay || this._dimIdxs[3] < 0) {
                return;
            }
            Object monthMember = members[3];
            if (monthMember instanceof Calendar) {
                int day;
                Calendar calendar = (Calendar)monthMember;
                int month = calendar.get(2) + 1;
                if (month == 2) {
                    int year;
                    Object yearMember;
                    day = 28;
                    if (this._dimIdxs[1] >= 0 && (yearMember = members[1]) instanceof Calendar && this.isLeapYear(year = ((Calendar)yearMember).get(1))) {
                        day = 29;
                    }
                } else {
                    day = this.isBigMonth(month) ? 31 : 30;
                }
                Calendar dayCalendar = (Calendar)members[4];
                dayCalendar.set(5, day);
            }
        }

        private boolean isLeapYear(int year) {
            if (year % 100 == 0) {
                return year % 400 == 0;
            }
            return year % 4 == 0;
        }

        private boolean isBigMonth(int month) {
            if (month < 8) {
                return month % 2 == 1;
            }
            return month % 2 == 0;
        }

        private Object dayForLastPeriod(Object member, boolean[] borrow) {
            if (member == "com.kingdee.bos.qing.All") {
                if (this._dimIdxs[3] >= 0) {
                    borrow[3] = true;
                } else if (this._dimIdxs[2] >= 0) {
                    borrow[2] = true;
                } else if (this._dimIdxs[1] >= 0) {
                    borrow[1] = true;
                }
                return member;
            }
            if (!(member instanceof Calendar)) {
                return null;
            }
            Calendar calendar = (Calendar)member;
            int year = calendar.get(1);
            int calendarMonth = calendar.get(2);
            int day = calendar.get(5);
            if (--day < 1) {
                this._isNeedFixDay = true;
                day = 31;
                if (this._dimIdxs[3] >= 0) {
                    borrow[3] = true;
                }
            }
            Calendar inst = (Calendar)calendar.clone();
            inst.set(year, calendarMonth, day);
            return inst;
        }

        private Object ymdForLastPeriod(Object member, boolean[] borrow) throws OutsideIntervalException {
            if (member == "com.kingdee.bos.qing.All") {
                if (this._dimIdxs[3] >= 0) {
                    borrow[3] = true;
                } else if (this._dimIdxs[2] >= 0) {
                    borrow[2] = true;
                } else if (this._dimIdxs[1] >= 0) {
                    borrow[1] = true;
                }
                return member;
            }
            if (!(member instanceof Calendar)) {
                return null;
            }
            Calendar calendar = (Calendar)member;
            Calendar inst = (Calendar)calendar.clone();
            inst.add(5, -1);
            if (this.isInsideYear() && inst.get(1) != calendar.get(1)) {
                throw new OutsideIntervalException();
            }
            int calendarMonth = inst.get(2);
            if (calendarMonth != calendar.get(2)) {
                if (this._dimIdxs[3] >= 0) {
                    borrow[3] = true;
                }
                if (this._dimIdxs[2] >= 0 && (calendarMonth + 1) % 3 == 0) {
                    borrow[2] = true;
                }
                if (this._dimIdxs[1] >= 0 && calendarMonth == 11) {
                    borrow[1] = true;
                }
            }
            return inst;
        }

        private Object monthForLastPeriod(Object member, boolean[] borrow) throws OutsideIntervalException {
            if (member == "com.kingdee.bos.qing.All") {
                if (this._dimIdxs[2] >= 0) {
                    borrow[2] = true;
                } else if (this._dimIdxs[1] >= 0) {
                    borrow[1] = true;
                }
                return member;
            }
            if (!(member instanceof Calendar)) {
                return null;
            }
            Calendar calendar = (Calendar)member;
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            if (this._dimIdxs[2] >= 0 && --month % 3 == 0) {
                borrow[2] = true;
            }
            if (month < 1) {
                if (this.isInsideYear()) {
                    throw new OutsideIntervalException();
                }
                if (this._dimIdxs[1] >= 0) {
                    if (this._continuous[3]) {
                        --year;
                    }
                    month = 12;
                    borrow[1] = true;
                }
            }
            Calendar inst = Calendar.getInstance();
            inst.set(year, month - 1, 1, 0, 0, 0);
            inst.set(14, 0);
            return inst;
        }

        private Object quarterForLastPeriod(Object member, boolean[] borrow) throws OutsideIntervalException {
            if (member == "com.kingdee.bos.qing.All") {
                borrow[1] = true;
                return member;
            }
            if (!(member instanceof Calendar)) {
                return null;
            }
            Calendar calendar = (Calendar)member;
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            if ((month -= 3) < 1) {
                if (this.isInsideYear()) {
                    throw new OutsideIntervalException();
                }
                if (this._dimIdxs[1] >= 0) {
                    if (this._continuous[2]) {
                        --year;
                    }
                    month += 12;
                    borrow[1] = true;
                }
            }
            Calendar inst = Calendar.getInstance();
            inst.set(year, month - 1, 1, 0, 0, 0);
            inst.set(14, 0);
            return inst;
        }

        private Object yearForLastPeriod(Object member) {
            if (!(member instanceof Calendar)) {
                return null;
            }
            Calendar calendar = (Calendar)member;
            int year = calendar.get(1);
            calendar = (Calendar)calendar.clone();
            calendar.set(1, --year);
            return calendar;
        }

        private Object searchCustomPeriod(Object member, boolean[] borrow) {
            AbstractDateParser.MemberWrap last = this.searchLastPeriod(member);
            if (last == null) {
                return null;
            }
            if (last.isTail()) {
                if (this._dimIdxs[3] >= 0) {
                    borrow[3] = true;
                } else if (this._dimIdxs[2] >= 0) {
                    borrow[2] = true;
                } else {
                    boolean isFound = false;
                    if (this._dimIdxs[1] >= 0) {
                        borrow[1] = true;
                        isFound = true;
                    }
                    if (this._dimIdxs[0] >= 0) {
                        borrow[0] = true;
                        isFound = true;
                    }
                    if (!isFound) {
                        return null;
                    }
                }
            }
            return last.getMember();
        }

        private static class OutsideIntervalException
        extends Exception {
            private OutsideIntervalException() {
            }
        }

        public static enum Interval {
            INSIDE_YEAR("Y");

            private String _written;

            private Interval(String written) {
                this._written = written;
            }

            String getWritten() {
                return this._written;
            }

            public static Interval parseString(Object value) {
                if (value instanceof String) {
                    String written = (String)value;
                    for (Interval inst : Interval.values()) {
                        if (!inst.getWritten().equalsIgnoreCase(written)) continue;
                        return inst;
                    }
                }
                return null;
            }
        }
    }

    protected static abstract class AbstractDateParser
    implements IDateParser {
        protected static final int CY = 0;
        protected static final int Y = 1;
        protected static final int Q = 2;
        protected static final int M = 3;
        protected static final int D = 4;
        protected static final int CP = 5;
        private static final int PART_COUNT = 6;
        private String _dateFieldName;
        protected int[] _dimIdxs = new int[6];
        protected boolean[] _continuous = new boolean[6];
        private CustomPeriod _customPeriod;
        private CustomPeriod _customYear;
        private Map<String, MemberWrap> _customPeriodSearcher;
        private Map<String, MemberWrap> _customYearSearcher;

        public AbstractDateParser(List<AnalyticalField> dimensionFields) {
            int i;
            for (i = 0; i < 6; ++i) {
                this._dimIdxs[i] = -1;
            }
            for (i = dimensionFields.size() - 1; i >= 0; --i) {
                AnalyticalField field = dimensionFields.get(i);
                if (field.getDataType() == DataType.DATE) {
                    this.tryToPushField(field, i);
                    continue;
                }
                CustomPeriod cp = field.getMetaField().getCustomPeriod();
                if (cp == null || !cp.isValid()) continue;
                if (cp.isYear() && this._customYear == null) {
                    this._customYear = cp;
                    this._dimIdxs[0] = i;
                }
                if (cp.isYear() || this._customPeriod != null) continue;
                this._customPeriod = cp;
                this._dimIdxs[5] = i;
            }
        }

        private void tryToPushField(AnalyticalField field, int dimIdx) {
            switch (field.getPartValue()) {
                case DATE_YEAR: {
                    this.tryToAccept(field, dimIdx, 1, false);
                    break;
                }
                case DATE_QUARTER: {
                    this.tryToAccept(field, dimIdx, 2, false);
                    break;
                }
                case DATE_YQ: {
                    this.tryToAccept(field, dimIdx, 2, true);
                    break;
                }
                case DATE_MONTH: {
                    this.tryToAccept(field, dimIdx, 3, false);
                    break;
                }
                case DATE_YM: {
                    this.tryToAccept(field, dimIdx, 3, true);
                    break;
                }
                case DATE_DAY: {
                    this.tryToAccept(field, dimIdx, 4, false);
                    break;
                }
                case DATE_YMD: {
                    this.tryToAccept(field, dimIdx, 4, true);
                    break;
                }
            }
        }

        private void tryToAccept(AnalyticalField field, int dimIdx, int partIdx, boolean isContinue) {
            if (this._dateFieldName != null && !this._dateFieldName.equals(field.getName())) {
                return;
            }
            this._dimIdxs[partIdx] = dimIdx;
            this._continuous[partIdx] = isContinue || field.isContinuous();
            this._dateFieldName = field.getName();
        }

        @Override
        public final String getDateFieldFullName() {
            return this._dateFieldName;
        }

        @Override
        public final boolean isCalculable() {
            return this._dateFieldName != null || this._customPeriod != null || this._customYear != null;
        }

        protected final MemberWrap searchLastPeriod(Object member) {
            if (this._customPeriodSearcher == null) {
                this._customPeriodSearcher = this.buildQuickSearcher(this._customPeriod);
            }
            return this.search(this._customPeriodSearcher, member);
        }

        protected final Object searchCustomLastYear(Object member) {
            if (this._customYearSearcher == null) {
                this._customYearSearcher = this.buildQuickSearcher(this._customYear);
            }
            if (this._customYearSearcher.size() == 0 && member instanceof BigDecimal) {
                return ((BigDecimal)member).subtract(BigDecimal.ONE);
            }
            MemberWrap last = this.search(this._customYearSearcher, member);
            return last == null || last.isTail() ? null : last.getMember();
        }

        private MemberWrap search(Map<String, MemberWrap> searcher, Object member) {
            if (member instanceof String) {
                MemberWrap wrap = searcher.get(member);
                if (wrap != null) {
                    wrap.setMember(wrap.getDefined());
                }
                return wrap;
            }
            if (member instanceof BigDecimal) {
                MemberWrap wrap = searcher.get(member.toString());
                if (wrap != null) {
                    wrap.setMember(new BigDecimal(wrap.getDefined()));
                }
                return wrap;
            }
            return null;
        }

        private Map<String, MemberWrap> buildQuickSearcher(CustomPeriod customPeriod) {
            HashMap<String, MemberWrap> quickSearcher = new HashMap<String, MemberWrap>();
            CustomPeriod.Part part = customPeriod.getParts().get(0);
            List<String> value = part.getEnumeration();
            if (value != null) {
                int c = value.size();
                for (int i = 0; i < c; ++i) {
                    String me = value.get(i);
                    MemberWrap last = i == 0 ? new MemberWrap(value.get(c - 1), true) : new MemberWrap(value.get(i - 1), false);
                    quickSearcher.put(me, last);
                }
            }
            return quickSearcher;
        }

        protected static class MemberWrap {
            private String _defined;
            private boolean _isTail;
            private Object _member;

            public MemberWrap(String defined, boolean isTail) {
                this._defined = defined;
                this._isTail = isTail;
            }

            private String getDefined() {
                return this._defined;
            }

            public boolean isTail() {
                return this._isTail;
            }

            public void setMember(Object member) {
                this._member = member;
            }

            public Object getMember() {
                return this._member;
            }
        }
    }

    protected static interface IDateParser {
        public boolean isCalculable();

        public String getDateFieldFullName();

        public CompositeKey createAnotherDimensionKey(CompositeKey var1);
    }

    public static interface IInterlineEnv {
        public Cuboid getCuboid();

        public int getCurrentMeasureIndex();

        public CompositeKey getThisLineDimension();

        public IExecuteContext createThisLineContext();

        public void previousLine(CompositeKey var1);
    }
}

