/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine.runner.longer;

import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.runner.longer.AbstractEngineRunner;
import com.kingdee.bos.qing.core.engine.runner.longer.Helper;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.FilterFieldSet;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractEngineRunnerForFilterPreparedValue
extends AbstractEngineRunner {
    private List<AnalyticalField> _fields;
    private List<FilterPreparedValueGainer.AbstractPreparedValueGainer> _gainers;

    public AbstractEngineRunnerForFilterPreparedValue(IDataSourceVisitor dataSourceVisitor) {
        super(dataSourceVisitor);
    }

    public final void setTargetFilterField(AnalyticalField field) {
        if (field == null) {
            this._fields = null;
        } else {
            this._fields = new ArrayList<AnalyticalField>();
            this._fields.add(field);
        }
    }

    protected final void setTargetFilterFields(List<AnalyticalField> fields) {
        this._fields = fields;
    }

    @Override
    protected final void initFilterPreparedValueGainer(AbstractEngine engine) throws AnalysisException {
        List<AnalyticalField> fields = null;
        if (this._fields == null) {
            FilterFieldSet filterSet = this.getModel().getFilterFieldSet();
            if (filterSet != null) {
                fields = filterSet.getFields();
            }
        } else {
            fields = this._fields;
        }
        if (fields != null) {
            for (AnalyticalField field : fields) {
                FilterPreparedValueGainer.AbstractPreparedValueGainer gainer = FilterPreparedValueGainer.create(field, this.getContext());
                if (this._gainers == null) {
                    this._gainers = new ArrayList<FilterPreparedValueGainer.AbstractPreparedValueGainer>();
                }
                this._gainers.add(gainer);
            }
            engine.addAdditionalFields(fields);
        }
        this.initGainers(engine, this._gainers);
    }

    protected abstract void initGainers(AbstractEngine var1, List<FilterPreparedValueGainer.AbstractPreparedValueGainer> var2) throws AnalysisException;

    public final List<FilterPreparedValueGainer.IPreparedValueFruit> getPreparedValueFruits() {
        ArrayList<FilterPreparedValueGainer.IPreparedValueFruit> result = new ArrayList<FilterPreparedValueGainer.IPreparedValueFruit>();
        if (this._gainers != null) {
            for (FilterPreparedValueGainer.AbstractPreparedValueGainer gainer : this._gainers) {
                result.add(gainer.getFruit());
            }
        }
        return result;
    }

    protected final void applyAppointedFilterFieldToMeasuresSafely(List<AnalyticalField> dimensionFields, List<AnalyticalField> measureFields) {
        if (this._fields != null) {
            Helper.applyAppointedFilterFieldToMeasures(this._fields, dimensionFields, measureFields);
        }
    }
}

