/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine.runner.longer;

import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.DataSourceTraversal;
import com.kingdee.bos.qing.core.engine.runner.longer.AbstractEngineRunner;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class EngineRunnerForDataDetail
extends AbstractEngineRunner {
    private DataSourceTraversal.SubDataSourceCacheInfo _cacheInfo;
    private boolean _isWholeCachedRows;

    public EngineRunnerForDataDetail(IDataSourceVisitor dataSourceVisitor, AnalyticalModel model, boolean isWholeCachedRows) {
        super(dataSourceVisitor);
        this.setModel(model);
        dataSourceVisitor.getMeta().setEliminations(Collections.EMPTY_LIST);
        this._isWholeCachedRows = isWholeCachedRows;
    }

    @Override
    protected DataSourceTraversal createDataSourceTraversal() {
        this._cacheInfo = new DataSourceTraversal.SubDataSourceCacheInfo();
        this._cacheInfo.setSubDataSourceCacheKey(UUID.randomUUID().toString());
        DataSourceTraversal dataSourceTraversal = super.createDataSourceTraversal();
        dataSourceTraversal.setSubDataSourceCacheInfo(this._cacheInfo);
        return dataSourceTraversal;
    }

    public String getSubDataSourceCacheKey() {
        return this._cacheInfo.getSubDataSourceCacheKey();
    }

    public long getDataRowTotal() {
        return this._cacheInfo.getRowCount();
    }

    @Override
    protected void initFilter(List<AnalyticalField> dimensionFields, List<AnalyticalField> measureFields) {
        if (!this._isWholeCachedRows) {
            EngineRunnerForDataDetail.appendRowNumberAggregation(this.getModel(), measureFields);
        }
    }

    static void appendRowNumberAggregation(AnalyticalModel model, List<AnalyticalField> measureFields) {
        Iterator<MetaField> it = model.getMeta().createAllFieldsIterator();
        while (it.hasNext()) {
            MetaField mf = it.next();
            if (mf.isCalculation()) continue;
            AnalyticalField field = new AnalyticalField();
            field.setName(mf.getFullName());
            field.setRole("measure");
            field.setAggregation(Aggregation.ROW_NUM);
            field.bindMetaField(mf);
            measureFields.add(field);
            break;
        }
    }

    @Override
    protected void initFilterPreparedValueGainer(AbstractEngine engine) {
    }

    @Override
    protected AbstractEngine createEngine() {
        AbstractEngine engine = super.createEngine();
        engine.setDataDetailIntercepter(new AbstractEngine.IDataDetailIntercepter(){

            @Override
            public boolean isAggregateNeeded() {
                return !EngineRunnerForDataDetail.this._isWholeCachedRows;
            }
        });
        return engine;
    }
}

