/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine.runner.longer;

import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.DataSourceGreenChannel;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.MdEngineOfLonger;
import com.kingdee.bos.qing.core.engine.runner.longer.EngineRunner;
import com.kingdee.bos.qing.core.engine.runner.longer.Helper;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MdEngineRunner
extends EngineRunner {
    private List<AnalyticalField> _preparedValueTargetFields;
    private List<FilterPreparedValueGainer.AbstractPreparedValueGainer> _preparedValueGainers;

    public MdEngineRunner(IDataSourceVisitor dataSourceVisitor, AnalyticalModel model) {
        super(dataSourceVisitor, model);
    }

    @Override
    protected void setModel(AnalyticalModel model) {
        this.constraintModel(model);
        super.setModel(model);
    }

    @Override
    protected AbstractEngine createEngine() {
        MdEngineOfLonger engine = new MdEngineOfLonger();
        engine.setI18nContext(this.getContext());
        engine.setAnalyticalModel(this.getModel());
        engine.setModelAssistantStructure(this.getModelAssistantStructure());
        engine.setDataSourceGreenChannel(new DataSourceGreenChannel(this.getDataSourceVisitor()));
        return engine;
    }

    private void constraintModel(AnalyticalModel model) {
        this.removeNonPcdDimension(model.getRow().getFields());
        this.removeNonPcdDimension(model.getColumn().getFields());
    }

    private void removeNonPcdDimension(List<AnalyticalField> fields) {
        Iterator<AnalyticalField> it = fields.iterator();
        while (it.hasNext()) {
            AnalyticalField field = it.next();
            if (!field.isDimension() || field.isParentChildDimension()) continue;
            it.remove();
        }
    }

    public void addPreparedValueTargetField(AnalyticalField field) {
        if (this._preparedValueTargetFields == null) {
            this._preparedValueTargetFields = new ArrayList<AnalyticalField>();
        }
        this._preparedValueTargetFields.add(field);
    }

    @Override
    protected void initFilter(List<AnalyticalField> dimensionFields, List<AnalyticalField> measureFields) {
        if (this._preparedValueTargetFields != null) {
            Helper.applyAppointedFilterFieldToMeasures(this._preparedValueTargetFields, dimensionFields, measureFields);
        }
    }

    @Override
    protected void initFilterPreparedValueGainer(AbstractEngine engine) throws AnalysisException {
        if (this._preparedValueTargetFields != null) {
            this._preparedValueGainers = new ArrayList<FilterPreparedValueGainer.AbstractPreparedValueGainer>();
            for (AnalyticalField field : this._preparedValueTargetFields) {
                FilterPreparedValueGainer.AbstractPreparedValueGainer gainer = FilterPreparedValueGainer.create(field, this.getContext());
                this._preparedValueGainers.add(gainer);
            }
            engine.addAdditionalFields(this._preparedValueTargetFields);
            engine.setFilterPreparedValueGainer(this._preparedValueGainers);
        }
    }

    public List<FilterPreparedValueGainer.IPreparedValueFruit> getPreparedValueFruits() {
        ArrayList<FilterPreparedValueGainer.IPreparedValueFruit> result = new ArrayList<FilterPreparedValueGainer.IPreparedValueFruit>();
        if (this._preparedValueGainers != null) {
            for (FilterPreparedValueGainer.AbstractPreparedValueGainer gainer : this._preparedValueGainers) {
                result.add(gainer.getFruit());
            }
        }
        return result;
    }
}

