/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine.runner.square;

import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.charttype.square.AbstractChartPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.PreprocessorFactory;
import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.DataSourceTraversal;
import com.kingdee.bos.qing.core.engine.EngineOfSquare;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.DataEmptyException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.FilterItem;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.monitor.ICorrespondent;
import java.util.List;

abstract class AbstractEngineRunner {
    private II18nContext _ctx;
    private IDataSourceVisitor _dataSourceVisitor;
    private AbstractChartPreprocessor.Middle _middle;
    private boolean _dataEmptyIgnored = false;

    public AbstractEngineRunner(IDataSourceVisitor dataSourceVisitor, SquareModel model, II18nContext ctx) {
        this._ctx = ctx;
        this._dataSourceVisitor = dataSourceVisitor;
        AbstractChartPreprocessor preprocessor = PreprocessorFactory.create(model.getChartModel().getChartType());
        this._middle = preprocessor.preprocess(model, this._ctx);
        for (FilterItem item : this.getModel().getFilters()) {
            item.getFilter().parseForBeforeRun();
        }
    }

    protected final II18nContext getContext() {
        return this._ctx;
    }

    public final SquareModel getModel() {
        return this._middle.getSquareModel();
    }

    public final AbstractChartPreprocessor.Middle getMultiInfoWrapper() {
        return this._middle;
    }

    protected final IDataSourceVisitor getDataSourceVisitor() {
        return this._dataSourceVisitor;
    }

    protected final void setDataEmptyIgnored(boolean dataEmptyIgnored) {
        this._dataEmptyIgnored = dataEmptyIgnored;
    }

    public final EngineOfSquare run(ICorrespondent correspondent) throws AnalysisException {
        EngineOfSquare engine;
        block2: {
            this.beforeRun();
            List<AnalyticalField> dimensionFields = this.getModel().getChartModel().searchAllDimensions();
            List<AnalyticalField> measureFields = this.getModel().getChartModel().searchAllMeasures();
            this.applyAdditionalMeasure(measureFields);
            this.applyFilterFieldToMeasure(measureFields);
            this.initFilter(dimensionFields, measureFields);
            engine = new EngineOfSquare();
            engine.setI18nContext(this.getContext());
            engine.setCorrespondent(correspondent);
            engine.setAnalyticalModel(this.getModel(), this._middle.isGrandTotalRequest());
            engine.setDimensionFields(dimensionFields);
            engine.setMeasureFields(measureFields);
            engine.setDataSourceTraversal(this.createDataSourceTraversal());
            this.initFilterPreparedValueGainer(engine);
            try {
                engine.work();
            }
            catch (DataEmptyException ex) {
                if (this._dataEmptyIgnored) break block2;
                throw ex;
            }
        }
        return engine;
    }

    protected DataSourceTraversal createDataSourceTraversal() {
        return new DataSourceTraversal(this.getDataSourceVisitor());
    }

    protected void beforeRun() throws AnalysisException {
    }

    protected abstract void initFilter(List<AnalyticalField> var1, List<AnalyticalField> var2) throws AnalysisException;

    protected abstract void initFilterPreparedValueGainer(AbstractEngine var1) throws AnalysisException;

    protected abstract void applyAdditionalMeasure(List<AnalyticalField> var1);

    private void applyFilterFieldToMeasure(List<AnalyticalField> measureFields) {
        List<FilterItem> items = this.getModel().getFilters();
        if (items != null) {
            for (FilterItem item : items) {
                AnalyticalField field = item.getField();
                if (!field.isMeasure()) continue;
                boolean isFound = false;
                for (int i = measureFields.size() - 1; i >= 0; --i) {
                    if (!measureFields.get(i).isSame(field)) continue;
                    isFound = true;
                    break;
                }
                if (isFound) continue;
                measureFields.add(field);
            }
        }
    }
}

