/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.common;

import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.ContinuousColor;
import com.kingdee.bos.qing.core.model.exhibition.common.Legends;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;

public class ContinuousColorConfirmer {
    private AnalyticalField _analyticalField;
    private ContinuousColor _definition;
    private BigDecimal _realMin;
    private BigDecimal _realMax;
    private BigDecimal _scopeLeft;
    private BigDecimal _scopeMiddle;
    private BigDecimal _scopeRight;
    private BigDecimal _distanceForward;
    private BigDecimal _distanceBackward;
    private int[] _colorSuiteForward;
    private int[] _colorSuiteBackward;
    private String[] _segmentColor;
    private BigDecimal[] _segmentBoundary;

    public ContinuousColorConfirmer(BigDecimal min, BigDecimal max) {
        this._realMin = min;
        this._realMax = max;
    }

    public void setDefinition(ContinuousColor model) {
        this._definition = model;
        this._colorSuiteForward = null;
        this._colorSuiteBackward = null;
    }

    private ContinuousColor getDefinition() {
        if (this._definition == null) {
            this._definition = this.createDefaultDefinition();
        }
        return this._definition;
    }

    public void setAnalyticalField(AnalyticalField analyticalField) {
        this._analyticalField = analyticalField;
    }

    public AnalyticalField getAnalyticalField() {
        return this._analyticalField;
    }

    public String getColor(BigDecimal value) {
        if (this._colorSuiteForward == null || this._colorSuiteBackward == null) {
            this.precalculate();
            this._colorSuiteForward = this.preprocessColor(this.getDefinition().getColorForward());
            this._colorSuiteBackward = this.preprocessColor(this.getDefinition().getColorBackward());
        }
        if (this.getDefinedSegment() == 0) {
            return this.getContinuousColor(value);
        }
        if (this._segmentColor == null) {
            this.presegment();
        }
        return this.getStairColor(value);
    }

    private String getStairColor(BigDecimal value) {
        int segment = this.getDefinedSegment();
        for (int i = segment - 1; i >= 0; --i) {
            if (value.compareTo(this._segmentBoundary[i]) < 0) continue;
            return this._segmentColor[i];
        }
        return this._segmentColor[0];
    }

    private String getContinuousColor(BigDecimal value) {
        boolean invalid;
        double deltaRatio = 0.0;
        int[] colorSuite = null;
        boolean bl = invalid = this._distanceForward == null && this._distanceBackward == null;
        if (invalid) {
            colorSuite = this._colorSuiteForward != null ? this._colorSuiteForward : this._colorSuiteBackward;
        } else if (this.isDefinedDiverging()) {
            if (value.compareTo(this._scopeMiddle) >= 0) {
                if (this._distanceForward != null) {
                    deltaRatio = this.confirmDeltaRatio(this._distanceForward, value.subtract(this._scopeMiddle));
                }
                colorSuite = this._colorSuiteForward;
            } else {
                if (this._distanceBackward != null) {
                    deltaRatio = this.confirmDeltaRatio(this._distanceBackward, this._scopeMiddle.subtract(value));
                }
                colorSuite = this._colorSuiteBackward;
            }
        } else if (this._colorSuiteForward != null) {
            deltaRatio = this.confirmDeltaRatio(this._distanceForward, value.subtract(this._scopeLeft));
            colorSuite = this._colorSuiteForward;
        } else {
            deltaRatio = this.confirmDeltaRatio(this._distanceBackward, this._scopeRight.subtract(value));
            colorSuite = this._colorSuiteBackward;
        }
        return this.createHslColor(colorSuite, deltaRatio);
    }

    private double confirmDeltaRatio(BigDecimal absMaxFromMin, BigDecimal absValueFromMin) {
        return absMaxFromMin.subtract(absValueFromMin).divide(absMaxFromMin, 2, RoundingMode.DOWN).doubleValue();
    }

    private String createHslColor(int[] colorSuite, double deltaRatio) {
        deltaRatio = deltaRatio < 0.0 ? 0.0 : deltaRatio;
        deltaRatio = deltaRatio > 1.0 ? 1.0 : deltaRatio;
        int hue = colorSuite[0] + (int)Math.floor(deltaRatio * (double)colorSuite[1]);
        int saturation = colorSuite[2] + (int)Math.floor(deltaRatio * (double)colorSuite[3]);
        int lightness = colorSuite[4] + (int)Math.floor(deltaRatio * (double)colorSuite[5]);
        return "hsl(" + hue + ", " + saturation + "%, " + lightness + "%)";
    }

    public BigDecimal getScopeLeft() {
        return this._scopeLeft;
    }

    public BigDecimal getScopeRight() {
        return this._scopeRight;
    }

    public Legends.ContinuousColorLegend createLegend(String minText, String maxText) {
        Legends.ContinuousColorLegend ccl = new Legends.ContinuousColorLegend(minText, maxText);
        if (this.getDefinedSegment() == 0) {
            String color4;
            String color3;
            String pos;
            String color2;
            String color1;
            if (this.isDefinedDiverging() && (!this.isDefinedMiddle() || this.isDefinedMiddleValid()) && this._scopeMiddle != null) {
                BigDecimal distance = this._scopeRight.subtract(this._scopeLeft);
                BigDecimal tiny = distance.multiply(BigDecimal.valueOf(1.0E-4));
                BigDecimal middlePos = this._scopeMiddle.subtract(this._scopeLeft).divide(distance, 4, RoundingMode.HALF_UP);
                color1 = this.getColor(this._scopeLeft);
                color2 = this.getColor(this._scopeMiddle.subtract(tiny));
                pos = Float.toString(middlePos.floatValue());
                color3 = this.getColor(this._scopeMiddle.add(tiny));
                color4 = this.getColor(this._scopeRight);
            } else {
                color1 = this.getColor(this._scopeLeft);
                color2 = this.getColor(this._scopeRight);
                pos = null;
                color3 = null;
                color4 = null;
            }
            ccl.setGradientColor(color1, color2, pos, color3, color4);
        } else {
            ccl.setSegmentColor(Arrays.asList(this._segmentColor));
        }
        return ccl;
    }

    private ContinuousColor createDefaultDefinition() {
        ContinuousColor.GradientColor gradientGreen = new ContinuousColor.GradientColor(142, 90, 20, 142, 20, 80);
        ContinuousColor.GradientColor gradientRed = new ContinuousColor.GradientColor(349, 90, 30, 349, 20, 80);
        boolean dataPositive = this._realMin.signum() >= 0;
        boolean dataNegative = this._realMax.signum() <= 0;
        ContinuousColor model = new ContinuousColor();
        if (dataPositive) {
            model.setColorForward(gradientGreen);
        } else if (dataNegative) {
            model.setColorBackward(gradientRed);
        } else {
            model.setColorForward(gradientGreen);
            model.setColorBackward(gradientRed);
            model.setMiddle("0");
        }
        return model;
    }

    private BigDecimal getDefinedNumber(String str) {
        return str == null ? null : new BigDecimal(str);
    }

    private boolean isDefinedDiverging() {
        return this.getDefinition().getColorForward() != null && this.getDefinition().getColorBackward() != null;
    }

    private int getDefinedSegment() {
        Integer segment = this.getDefinition().getSegment();
        return segment == null || segment < 2 || segment > 20 ? 0 : segment;
    }

    private boolean isDefinedUsingWholeColorRange() {
        return this.getDefinition().isUsingWholeColorRange();
    }

    private boolean isDefinedMiddle() {
        return this.getDefinition().getMiddle() != null;
    }

    private boolean isDefinedMiddleValid() {
        return this.getDefinition().getMiddle() != null && this._distanceForward != null && this._distanceBackward != null;
    }

    private void precalculate() {
        boolean invalidScope;
        BigDecimal definedMin = this.getDefinedNumber(this.getDefinition().getMin());
        BigDecimal definedMax = this.getDefinedNumber(this.getDefinition().getMax());
        this._scopeLeft = definedMin == null ? this._realMin : definedMin;
        this._scopeRight = definedMax == null ? this._realMax : definedMax;
        boolean bl = invalidScope = this._scopeLeft.compareTo(this._scopeRight) >= 0;
        if (invalidScope) {
            this._scopeMiddle = null;
            this._distanceForward = null;
            this._distanceBackward = null;
        } else if (this.isDefinedDiverging()) {
            this.precalculateDiverging(definedMin, definedMax);
        } else {
            this._scopeMiddle = null;
            this._distanceBackward = this._distanceForward = this._scopeRight.subtract(this._scopeLeft);
        }
    }

    private void precalculateDiverging(BigDecimal definedMin, BigDecimal definedMax) {
        this._scopeMiddle = this.getDefinedNumber(this.getDefinition().getMiddle());
        if (this._scopeMiddle == null) {
            int scale = Math.max(this._scopeLeft.scale(), this._scopeRight.scale()) + 1;
            BigDecimal half = this._scopeRight.subtract(this._scopeLeft).divide(new BigDecimal(2), scale, RoundingMode.HALF_DOWN);
            this._scopeMiddle = this._scopeLeft.add(half);
        } else if (this.getDefinedSegment() > 0) {
            if (definedMin == null && definedMax == null) {
                if (this._scopeRight.compareTo(this._scopeMiddle) <= 0) {
                    this._scopeRight = this._scopeMiddle.add(this._scopeMiddle.subtract(this._scopeLeft));
                } else if (this._scopeMiddle.compareTo(this._scopeLeft) <= 0) {
                    this._scopeLeft = this._scopeMiddle.subtract(this._scopeRight.subtract(this._scopeMiddle));
                }
            } else if (definedMin == null) {
                if (this._scopeMiddle.compareTo(this._scopeLeft) <= 0) {
                    this._scopeLeft = this._scopeMiddle.subtract(this._scopeRight.subtract(this._scopeMiddle));
                }
            } else if (definedMax == null && this._scopeRight.compareTo(this._scopeMiddle) <= 0) {
                this._scopeRight = this._scopeMiddle.add(this._scopeMiddle.subtract(this._scopeLeft));
            }
        }
        this.precalculateDistanceForwardBackward();
    }

    private void precalculateDistanceForwardBackward() {
        this._distanceForward = this._scopeRight.compareTo(this._scopeMiddle) > 0 ? this._scopeRight.subtract(this._scopeMiddle) : null;
        BigDecimal bigDecimal = this._distanceBackward = this._scopeMiddle.compareTo(this._scopeLeft) > 0 ? this._scopeMiddle.subtract(this._scopeLeft) : null;
        if (this.isDefinedMiddleValid() && !this.isDefinedUsingWholeColorRange()) {
            if (this._distanceForward.compareTo(this._distanceBackward) > 0) {
                this._distanceBackward = this._distanceForward;
            } else {
                this._distanceForward = this._distanceBackward;
            }
        }
    }

    private int[] preprocessColor(ContinuousColor.GradientColor gc) {
        int[] suite = null;
        if (gc != null) {
            suite = new int[6];
            suite[0] = gc.getHueA();
            suite[2] = gc.getSaturationA();
            suite[4] = gc.getLightnessA();
            int hueDelta = gc.getHueB() - gc.getHueA();
            if (hueDelta > 180) {
                hueDelta -= 360;
            } else if (hueDelta < -180) {
                hueDelta += 360;
            }
            suite[1] = hueDelta;
            suite[3] = gc.getSaturationB() - gc.getSaturationA();
            suite[5] = gc.getLightnessB() - gc.getLightnessA();
        }
        return suite;
    }

    private void presegment() {
        boolean invalid;
        int segment = this.getDefinedSegment();
        this._segmentColor = new String[segment];
        this._segmentBoundary = new BigDecimal[segment];
        BigDecimal distance = this._scopeRight.subtract(this._scopeLeft);
        boolean bl = invalid = distance.signum() <= 0 || segment <= 1;
        if (invalid) {
            String color = this.getContinuousColor(this._scopeLeft);
            for (int i = 0; i < segment; ++i) {
                this._segmentBoundary[i] = this._scopeLeft;
                this._segmentColor[i] = color;
            }
        } else if (this.isDefinedMiddleValid() && this.isDefinedDiverging()) {
            this.presegmentDiverging(segment, distance);
        } else {
            this.presegmentForFull(this._scopeLeft, distance, segment);
        }
    }

    private void presegmentDiverging(int segment, BigDecimal distance) {
        BigDecimal distancePerSegment;
        boolean odd = segment % 2 == 1;
        BigDecimal distanceLeft = this._scopeMiddle.subtract(this._scopeLeft);
        BigDecimal distanceRight = this._scopeRight.subtract(this._scopeMiddle);
        double exactRightSegment = new BigDecimal(segment).multiply(distanceRight).divide(distance, 5, RoundingMode.HALF_UP).floatValue();
        if (odd) {
            exactRightSegment += 0.5;
        }
        double rightSegments = (int)(exactRightSegment + 0.5);
        if (odd) {
            rightSegments = (rightSegments -= 0.5) <= 0.0 ? 0.5 : rightSegments;
        } else {
            rightSegments = rightSegments == 0.0 ? 1.0 : rightSegments;
            rightSegments = rightSegments == (double)segment ? (double)(segment - 1) : rightSegments;
        }
        double leftSegments = (double)segment - rightSegments;
        if (rightSegments < exactRightSegment) {
            distancePerSegment = distanceRight.divide(BigDecimal.valueOf(rightSegments), RoundingMode.HALF_UP);
            distanceLeft = distancePerSegment.multiply(BigDecimal.valueOf(leftSegments));
            this._scopeLeft = this._scopeMiddle.subtract(distanceLeft);
        } else if (rightSegments > exactRightSegment) {
            distancePerSegment = distanceLeft.divide(BigDecimal.valueOf(leftSegments), RoundingMode.HALF_UP);
            distanceRight = distancePerSegment.multiply(BigDecimal.valueOf(rightSegments));
            this._scopeRight = this._scopeMiddle.add(distanceRight);
        }
        this.precalculateDistanceForwardBackward();
        if (odd) {
            BigDecimal halfSegmentDistance = this._scopeRight.subtract(this._scopeLeft).divide(BigDecimal.valueOf(segment), RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(0.5));
            int segmentIndex = 0;
            int segmentCount = (int)leftSegments;
            if (segmentCount > 0) {
                BigDecimal partDistance = distanceLeft.subtract(halfSegmentDistance);
                this.presegmentForHalf(this._scopeLeft, partDistance, segmentIndex, segmentCount, 0);
            }
            this._segmentBoundary[segmentIndex += segmentCount] = this._scopeMiddle.subtract(halfSegmentDistance);
            this._segmentColor[segmentIndex] = this.getContinuousColor(this._scopeMiddle);
            ++segmentIndex;
            segmentCount = (int)rightSegments;
            if (segmentCount > 0) {
                BigDecimal start = this._scopeMiddle.add(halfSegmentDistance);
                BigDecimal partDistance = distanceRight.subtract(halfSegmentDistance);
                this.presegmentForHalf(start, partDistance, segmentIndex, segmentCount, 1);
            }
        } else {
            this.presegmentForHalf(this._scopeLeft, distanceLeft, 0, (int)leftSegments, 0);
            this.presegmentForHalf(this._scopeMiddle, distanceRight, (int)leftSegments, (int)rightSegments, 1);
        }
    }

    private void presegmentForHalf(BigDecimal start, BigDecimal distance, int offsetIdx, int segmentCount, int colorOffset) {
        double perRatio = 1.0 / (double)segmentCount;
        for (int i = 0; i < segmentCount; ++i) {
            BigDecimal boundary;
            this._segmentBoundary[offsetIdx + i] = boundary = start.add(distance.multiply(BigDecimal.valueOf(perRatio * (double)i)));
            BigDecimal keyValue = start.add(distance.multiply(BigDecimal.valueOf(perRatio * (double)(i + colorOffset))));
            this._segmentColor[offsetIdx + i] = this.getContinuousColor(keyValue);
        }
    }

    private void presegmentForFull(BigDecimal start, BigDecimal distance, int segmentCount) {
        double perRatioForBoundary = 1.0 / (double)segmentCount;
        double perRatioForKeyValue = 1.0 / (double)(segmentCount - 1);
        for (int i = 0; i < segmentCount; ++i) {
            BigDecimal boundary;
            this._segmentBoundary[i] = boundary = start.add(distance.multiply(BigDecimal.valueOf(perRatioForBoundary * (double)i)));
            BigDecimal keyValue = start.add(distance.multiply(BigDecimal.valueOf(perRatioForKeyValue * (double)i)));
            this._segmentColor[i] = this.getContinuousColor(keyValue);
        }
    }
}

