/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.common.sort;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.sort.CommonComparator;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.flattening.common.sort.AbstractSortProcessor;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.core.model.analysis.common.pie.LegendOrderMode;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PieCommonProcessor
extends AbstractSortProcessor {
    private IDependance _dependance;
    private Map<Object, AbstractNormalChartModel.Category> _categoriesCollection = new HashMap<Object, AbstractNormalChartModel.Category>();
    private LegendOrderMode _legendOrderMode = LegendOrderMode.AUTO;
    private boolean _isNegativeAsAbsolute = false;
    private boolean _isMultiPie = false;
    private boolean _isDateCategory = false;
    private int _angleMeasureIndex = -1;

    public PieCommonProcessor(IDependance dependance) {
        this._dependance = dependance;
    }

    public void setNegativeAsAbsolute(boolean isNegativeAsAbsolute) {
        this._isNegativeAsAbsolute = isNegativeAsAbsolute;
    }

    public void setMultiPie(boolean isMultiPie) {
        this._isMultiPie = isMultiPie;
    }

    public void setDateCategory(boolean isDateCategory) {
        this._isDateCategory = isDateCategory;
    }

    public void setAngleMeasureIndex(int angleMeasureIndex) {
        this._angleMeasureIndex = angleMeasureIndex;
    }

    public void setLegendOrgerMode(LegendOrderMode mode) {
        this._legendOrderMode = mode;
    }

    private boolean isLegendOrderByCategory() {
        if (this._legendOrderMode == LegendOrderMode.VALUE) {
            return false;
        }
        if (this._legendOrderMode == LegendOrderMode.NAME) {
            return true;
        }
        return this._isMultiPie || !super.isNeedToDealWithTopN() && this._isDateCategory;
    }

    public int getCategoryCount() {
        return this._categoriesCollection.size();
    }

    public AbstractNormalChartModel.Category getCategory(CompositeKey dimKey) {
        Object categoryValue = this.getCategoryValue(dimKey);
        return this._categoriesCollection.get(categoryValue);
    }

    private Object getCategoryValue(CompositeKey dimKey) {
        Object categoryValue = dimKey == null || dimKey.getMemberCount() == 0 ? null : dimKey.getMember(0);
        return categoryValue;
    }

    @Override
    protected List<AbstractSortProcessor.SortableItem> preSort(Cuboid cuboid, AbstractSortProcessor.ICuboidShell insteadCuboid) {
        ArrayList<AbstractSortProcessor.SortableItem> list = new ArrayList<AbstractSortProcessor.SortableItem>();
        Iterator<CompositeKey> itDimKey = cuboid.createDimensionKeyIterator();
        while (itDimKey.hasNext()) {
            CompositeKey dimKey = itDimKey.next();
            Aggregator[] aggregators = cuboid.getCellAggregators(dimKey);
            if (this._dependance.isSubtotal(dimKey)) {
                insteadCuboid.retract(dimKey, aggregators);
                continue;
            }
            Aggregator aggregator = aggregators[this._angleMeasureIndex];
            BigDecimal measureValue = aggregator.getNumberValue();
            if (measureValue != null && measureValue.compareTo(BigDecimal.ZERO) < 0) {
                if (!this._isNegativeAsAbsolute) continue;
                measureValue = measureValue.abs();
            }
            AbstractSortProcessor.SortableItem piece = new AbstractSortProcessor.SortableItem();
            piece.setAscendent(this.isAscendent());
            piece.setCategoryValue(this.getCategoryValue(dimKey));
            piece.addCuboidCell(dimKey, aggregators, measureValue);
            list.add(piece);
        }
        return list;
    }

    @Override
    protected void collectCategory(Object categoryValue, int idxForSort) throws AnalysisException {
        if (!this._categoriesCollection.containsKey(categoryValue)) {
            AbstractNormalChartModel.Category category = this._dependance.createCategory(categoryValue);
            category.setOrderingValue(this.isLegendOrderByCategory() ? categoryValue : Integer.valueOf(idxForSort));
            this._categoriesCollection.put(categoryValue, category);
        }
    }

    @Override
    protected CompositeKey replaceMemberForOthers(CompositeKey dimKey, AbstractSortProcessor.OthersMember others) {
        Object realMember = dimKey.getMember(0);
        others.addRealMember(realMember);
        CompositeKey newInstance = new CompositeKey();
        newInstance.addMember(others);
        return newInstance;
    }

    @Override
    protected void mergeMeasureForOthers(Cuboid insteadCuboid, CompositeKey insteadDimKey, Aggregator[] aggs) {
        Aggregator[] insteadAggs = insteadCuboid.getCellAggregators(insteadDimKey);
        for (int j = 0; j < aggs.length; ++j) {
            Object value = aggs[j].getValue();
            if (!(value instanceof BigDecimal)) continue;
            value = ((BigDecimal)value).abs();
            insteadAggs[j].append(value);
        }
    }

    public void makeUnifiedColor() {
        AbstractNormalChartModel.Category[] categories = this._categoriesCollection.values().toArray(new AbstractNormalChartModel.Category[0]);
        Arrays.sort(categories, new LegendSorter(this._dependance.getI18nContext()));
        String colorForOthers = null;
        for (int i = 0; i < categories.length; ++i) {
            String color;
            AbstractNormalChartModel.Category category = categories[i];
            if (category.getOrderingValue() instanceof AbstractSortProcessor.OthersMember) {
                if (colorForOthers == null) {
                    colorForOthers = this._dependance.makeDiscreteColor(category, category.getLabel());
                }
                color = colorForOthers;
            } else {
                color = this._dependance.makeDiscreteColor(category, category.getLabel());
            }
            category.setColor(color);
        }
    }

    public static AbstractSortProcessor.CuboidShell copyCuboidShellFrom(Cuboid cuboid) {
        AbstractSortProcessor.CuboidShell shell = AbstractSortProcessor.CuboidShell.copyShellFrom(cuboid);
        int measureCount = cuboid.getMeasureFields().size();
        ArrayList<Aggregation> aggregations = new ArrayList<Aggregation>(measureCount);
        for (int i = 0; i < measureCount; ++i) {
            aggregations.add(Aggregation.SUM);
        }
        shell.setAppointedAggregations(aggregations);
        return shell;
    }

    private static class LegendSorter
    implements Comparator<AbstractNormalChartModel.Category> {
        private CommonComparator _comparator;

        public LegendSorter(Locale locale) {
            this._comparator = new CommonComparator(locale);
        }

        @Override
        public int compare(AbstractNormalChartModel.Category o1, AbstractNormalChartModel.Category o2) {
            Object v1 = o1.getOrderingValue();
            Object v2 = o2.getOrderingValue();
            if (v1 instanceof AbstractSortProcessor.OthersMember && v2 instanceof AbstractSortProcessor.OthersMember) {
                return 0;
            }
            if (v1 instanceof AbstractSortProcessor.OthersMember) {
                return 1;
            }
            if (v2 instanceof AbstractSortProcessor.OthersMember) {
                return -1;
            }
            return this._comparator.compare((Comparable)v1, (Comparable)v2);
        }
    }

    public static interface IDependance {
        public boolean isSubtotal(CompositeKey var1);

        public String makeDiscreteColor(AbstractChartModel.IOrderingSupported var1, String var2);

        public AbstractNormalChartModel.Category createCategory(Object var1) throws AnalysisException;

        public Locale getI18nContext();
    }
}

