/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.longer;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.SubCuboidKey;
import com.kingdee.bos.qing.core.exception.EnvCeilingException;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilder;
import com.kingdee.bos.qing.core.flattening.longer.AbstractMarkParser;
import com.kingdee.bos.qing.core.flattening.longer.HeaderForMeasure;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.ModelAssistantStructure;
import com.kingdee.bos.qing.core.model.analysis.longer.ParallelMeasureLayout;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.SingleSeriesChartModel;
import com.kingdee.bos.qing.core.model.exhibition.longer.DrawInfo;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.core.model.exhibition.longer.cell.ChartCell;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;

public class FlatBuilderForBar
extends AbstractFlatBuilder {
    private static final int EstimatedHeapSizePerCell = ChartCell.HEAPZISE_OVERHEAD + SingleSeriesChartModel.HEAPZISE_OVERHEAD + AbstractNormalChartModel.Series.HEAPZISE_OVERHEAD + AbstractNormalChartModel.Category.HEAPZISE_OVERHEAD + AbstractNormalChartModel.Node.HEAPZISE_OVERHEAD;
    private Scope _unifiedAxisScope = new Scope();

    @Override
    public HeaderForMeasure getTopRowForMeasureName(ParallelMeasureLayout pml) {
        String asAxis;
        int oneMoreRow;
        if (this.getModelAssistantStructure().isAxisMeasureAtRow()) {
            oneMoreRow = this.getDrawingMeasureCount() > 1 ? 1 : 0;
            asAxis = null;
        } else {
            oneMoreRow = this.getDrawingMeasureCount() == 0 ? 0 : 1;
            asAxis = "number";
        }
        return new HeaderForMeasure(oneMoreRow, asAxis);
    }

    @Override
    public HeaderForMeasure getLeftColumnForMeasureName(ParallelMeasureLayout pml) {
        String asAxis;
        int oneMoreRow;
        if (this.getModelAssistantStructure().isAxisMeasureAtRow()) {
            oneMoreRow = this.getDrawingMeasureCount() == 0 ? 0 : 1;
            asAxis = "number";
        } else {
            oneMoreRow = this.getDrawingMeasureCount() > 1 ? 1 : 0;
            asAxis = null;
        }
        return new HeaderForMeasure(oneMoreRow, asAxis);
    }

    @Override
    protected AbstractMarkParser createMarkParser() {
        return new MarkParserForBar(this.getModelAssistantStructure());
    }

    @Override
    protected Iterator<CompositeKey> prepareIteratorForFlatCuboid(Cuboid cuboid, SubCuboidKey subCuboidTag) throws EnvCeilingException {
        return cuboid.createDimensionKeyIterator();
    }

    @Override
    protected void flatCubeCell(SubCuboidKey subCuboidTag, boolean[] whichMeasureToDraw, CompositeKey dimKey) {
        int measureindexAtTable = 0;
        for (int i = 0; i < whichMeasureToDraw.length; ++i) {
            if (!whichMeasureToDraw[i]) continue;
            AbstractFlatBuilder.GroupItem groupItem = this.createGroupItem(dimKey, subCuboidTag, i);
            this.mapping(dimKey, groupItem, measureindexAtTable++);
        }
    }

    @Override
    protected void afterFlatCuboid() {
        if (this.getModelAssistantStructure().getMeasureFieldCountForAxis() > 1) {
            this.confirmDiscreteColorLegendTitlebyField(null);
        }
    }

    @Override
    protected int getCellHeapSize() {
        return EstimatedHeapSizePerCell;
    }

    @Override
    protected ICell createCell(AbstractFlatBuilder.GroupItem item) {
        CompositeKey dimKey = item.getDimensionKey();
        int measureIndex = item.getMeasureIndex();
        Cuboid cuboid = this.getCuboid(item.getSubCuboidTag());
        Aggregator[] aggregators = cuboid.getCellAggregators(dimKey);
        Aggregator aggregator = aggregators[measureIndex];
        BigDecimal measureValue = aggregator.getNumberValue();
        AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
        node.setValue(measureValue == null ? "" : measureValue.toString());
        node.setText(this.formatNumber(measureValue, this.getModelAssistantStructure().getMeasureField(measureIndex)));
        AbstractNormalChartModel.Category category = SingleSeriesChartModel.EmptyCategory;
        SingleSeriesChartModel chart = new SingleSeriesChartModel();
        chart.addData(category, node);
        if (this.getModelAssistantStructure().getMeasureFieldCountForAxis() > 1) {
            String name = this.getMeasureTitle(measureIndex);
            AbstractNormalChartModel.Series series = chart.getOnlyOneSeries();
            series.setOrderingValue(measureIndex);
            series.setName(name);
            series.setColor(this.makeDiscreteColorValue(series, name));
        }
        this._unifiedAxisScope.join(measureValue);
        ChartCell cell = new ChartCell();
        cell.setChart(chart);
        return cell;
    }

    @Override
    protected void makeRedundance() {
        SingleSeriesChartModel chart = new SingleSeriesChartModel();
        AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
        if (this.getModelAssistantStructure().getMeasureFieldCountForAxis() <= 1) {
            category.setColor(this.getDefaultColorValue());
        }
        chart.addData(category, null);
        if (this.getModelAssistantStructure().getMeasureFieldCountForAxis() == 1) {
            chart.getOnlyOneSeries().setName(this.getMeasureTitle(0));
        }
        if (this.getModelAssistantStructure().getMeasureFieldCountForAxis() > 0) {
            chart.getOnlyOneSeries().setFormatString(this.getModelAssistantStructure().getMeasureField(0).getUsableNumberFormat());
        }
        chart.setValueScope(this._unifiedAxisScope.getMin().toString(), this._unifiedAxisScope.getMax().toString());
        ChartCell cell = new ChartCell();
        cell.setChart(chart);
        this.getTableView().setCommonCell(cell);
    }

    private static class MarkParserForBar
    extends AbstractMarkParser {
        private ModelAssistantStructure _mas;

        public MarkParserForBar(ModelAssistantStructure mas) {
            this._mas = mas;
        }

        @Override
        public DrawInfo.Direction getDirection() {
            return this._mas.isAxisMeasureAtRow() ? DrawInfo.Direction.LANDSCAPE : DrawInfo.Direction.PORTRAIT;
        }

        @Override
        protected void confirmWhichMeasureToDraw(List<AnalyticalField> measureFields, boolean[] whichMeasureToDraw) {
            for (int i = 0; i < whichMeasureToDraw.length; ++i) {
                if (i >= this._mas.getMeasureFieldCountForAxis()) continue;
                whichMeasureToDraw[i] = true;
            }
        }
    }
}

