/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.longer;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.SubCuboidKey;
import com.kingdee.bos.qing.core.exception.EnvCeilingException;
import com.kingdee.bos.qing.core.flattening.common.DiscreteColorConfirmer;
import com.kingdee.bos.qing.core.flattening.common.Palette;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilder;
import com.kingdee.bos.qing.core.flattening.longer.AbstractMarkParser;
import com.kingdee.bos.qing.core.flattening.longer.CuboidSpliter;
import com.kingdee.bos.qing.core.flattening.longer.HeaderForMeasure;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.ModelAssistantStructure;
import com.kingdee.bos.qing.core.model.analysis.longer.ParallelMeasureLayout;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.core.model.exhibition.longer.cell.ChartCell;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlatBuilderForScatter
extends AbstractFlatBuilder {
    private CuboidSpliter _cuboidSpliter;
    private boolean _hasXAxisMeasure;
    private boolean _hasYAxisMeasure;
    private int _xAxisMeasureIdx = -1;
    private int _yAxisMeasureIdx = -1;
    private Map<Object, AbstractNormalChartModel.Category> _categoriesCollection = new HashMap<Object, AbstractNormalChartModel.Category>();
    private Map<Object, Integer> _categoriesIndex = new HashMap<Object, Integer>();
    private Set<Object> _seriesCollection;
    private List<Object> _seriesSortedList;
    private MultiSeriesChartModel _commonChart;
    private int _estimatedHeapSizePerCell;

    @Override
    protected HeaderForMeasure getTopRowForMeasureName(ParallelMeasureLayout pml) {
        boolean noFrame = this.getModelAssistantStructure().getColumnDimensionFieldCount() == 0;
        int moreLanes = noFrame && this.getDrawingMeasureCount() == 0 ? 0 : 1;
        return new HeaderForMeasure(moreLanes, "number", "top");
    }

    @Override
    protected HeaderForMeasure getLeftColumnForMeasureName(ParallelMeasureLayout pml) {
        boolean noFrame = this.getModelAssistantStructure().getRowDimensionFieldCount() == 0;
        int moreLanes = noFrame && this.getDrawingMeasureCount() == 0 ? 0 : 1;
        return new HeaderForMeasure(moreLanes, "number", "left");
    }

    @Override
    protected AbstractMarkParser createMarkParser() {
        return new MarkParserForScatter(this.getModelAssistantStructure());
    }

    private MarkParserForScatter getMyMarkParser() {
        return (MarkParserForScatter)this.getMarkParser();
    }

    @Override
    protected Palette.PaletteType getPaletteType() {
        return Palette.PaletteType.CONTRASTING_AREA;
    }

    @Override
    protected float getPaletteTranslucenceAlpha() {
        return 0.7f;
    }

    @Override
    protected void beforeFlatCuboid() {
        this._cuboidSpliter = this.createCuboidSpliter();
        this._hasYAxisMeasure = this.getModelAssistantStructure().isAxisMeasureAtRow();
        this._hasXAxisMeasure = this.getModelAssistantStructure().isAxisMeasureAtColumn();
        int measureIdx = 0;
        if (this._hasYAxisMeasure) {
            this._yAxisMeasureIdx = measureIdx++;
        }
        if (this._hasXAxisMeasure) {
            this._xAxisMeasureIdx = measureIdx;
        }
        if (this.getMyMarkParser().getColorField() != null) {
            this._seriesCollection = new HashSet<Object>();
            this._seriesSortedList = new ArrayList<Object>();
        }
    }

    @Override
    protected Iterator<CompositeKey> prepareIteratorForFlatCuboid(Cuboid cuboid, SubCuboidKey subCuboidTag) throws EnvCeilingException {
        this._cuboidSpliter.standardizingCuboid(cuboid, subCuboidTag, new CuboidSpliter.AbstractDoMoreHandler(){

            @Override
            public void forDimension(CompositeKey dimKeyInCell) {
                Object categoryValue = FlatBuilderForScatter.this.getCategoryValue(dimKeyInCell);
                FlatBuilderForScatter.this.collectCategory(categoryValue);
                if (FlatBuilderForScatter.this.getMyMarkParser().getColorField() != null) {
                    Object seriesValue = FlatBuilderForScatter.this.getSeriesValue(dimKeyInCell);
                    FlatBuilderForScatter.this._seriesCollection.add(seriesValue);
                }
            }

            @Override
            public void forMeasure(int measureIndex, Aggregator aggregator) {
                if (measureIndex == FlatBuilderForScatter.this._xAxisMeasureIdx) {
                    BigDecimal measureValue = aggregator.getNumberValue();
                    FlatBuilderForScatter.this.getXAxisScope().join(measureValue);
                } else if (measureIndex == FlatBuilderForScatter.this._yAxisMeasureIdx) {
                    BigDecimal measureValue = aggregator.getNumberValue();
                    FlatBuilderForScatter.this.getYAxisScope().join(measureValue);
                } else if (measureIndex == FlatBuilderForScatter.this.getMyMarkParser().getSizeFieldAtMeasures()) {
                    BigDecimal measureValue = aggregator.getNumberValue();
                    FlatBuilderForScatter.this.getZAxisScope().join(measureValue);
                }
            }
        });
        int seriesCount = this._seriesCollection == null ? 1 : this._seriesCollection.size();
        int categoryCount = this._categoriesCollection.size();
        this._estimatedHeapSizePerCell = ChartCell.HEAPZISE_OVERHEAD + MultiSeriesChartModel.HEAPZISE_OVERHEAD + AbstractNormalChartModel.Series.HEAPZISE_OVERHEAD * seriesCount + AbstractNormalChartModel.Category.HEAPZISE_OVERHEAD * categoryCount + AbstractNormalChartModel.XYNode.HEAPZISE_OVERHEAD * categoryCount * seriesCount;
        return this._cuboidSpliter.getStandardizedCube(subCuboidTag).keySet().iterator();
    }

    @Override
    protected void flatCubeCell(SubCuboidKey subCuboidTag, boolean[] whichMeasureToDraw, CompositeKey dimKey) {
        AbstractFlatBuilder.GroupItem groupItem = this.createGroupItem(dimKey, subCuboidTag, 0);
        this.mapping(dimKey, groupItem, -1);
    }

    @Override
    protected void afterFlatCuboid() {
        this.makeCommonChart();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected ICell createCell(AbstractFlatBuilder.GroupItem item) {
        MultiSeriesChartModel chart = new MultiSeriesChartModel();
        int categoryCount = this._commonChart.getCategoryList().size();
        AnalyticalField colorField = this.getMyMarkParser().getColorField();
        boolean hasSizeMeasure = this.getMyMarkParser().getSizeMeasureField() != null;
        HashMap seriesIndexSearcher = null;
        if (colorField == null) {
            void var8_10;
            AbstractNormalChartModel.Series series = chart.addSeries(null);
            String string = this.getDefaultColorValue();
            if (hasSizeMeasure) {
                String string2 = DiscreteColorConfirmer.createColorWithAlpha(string, this.getPaletteTranslucenceAlpha());
            }
            series.setColor((String)var8_10);
            for (int j = 0; j < categoryCount; ++j) {
                series.getNodes().add(j, null);
            }
        } else {
            seriesIndexSearcher = new HashMap();
            for (Object e : this._seriesSortedList) {
                String formatedSeriesValue = this.formatValue(e, colorField);
                AbstractNormalChartModel.Series series = chart.addSeries(null);
                series.setSeriesFieldValueText(FlatBuilderForScatter.encodeCategoryValue(e, formatedSeriesValue), formatedSeriesValue);
                series.setOrderingValue(e);
                String color = this.makeDiscreteColorValue(series, formatedSeriesValue);
                series.setColor(color);
                for (int j = 0; j < categoryCount; ++j) {
                    series.getNodes().add(j, null);
                }
                seriesIndexSearcher.put(e, seriesIndexSearcher.size());
            }
        }
        Map<CompositeKey, Cuboid> rowColPartOfCuboid = this._cuboidSpliter.getStandardizedCube(item.getSubCuboidTag());
        CompositeKey compositeKey = item.getDimensionKey();
        Cuboid cuboidInCell = rowColPartOfCuboid.get(compositeKey);
        Iterator<CompositeKey> it = cuboidInCell.createDimensionKeyIterator();
        while (it.hasNext()) {
            int seriesIndex;
            CompositeKey dimKeyInCell = it.next();
            Object categoryValue = this.getCategoryValue(dimKeyInCell);
            int categoryIndex = this.getCategoryIndex(categoryValue);
            if (categoryIndex >= categoryCount) continue;
            if (colorField == null) {
                seriesIndex = 0;
            } else {
                Object seriesValue = this.getSeriesValue(dimKeyInCell);
                if (!seriesIndexSearcher.containsKey(seriesValue)) continue;
                seriesIndex = (Integer)seriesIndexSearcher.get(seriesValue);
            }
            AbstractNormalChartModel.XYNode node = new AbstractNormalChartModel.XYNode();
            Aggregator[] aggregators = cuboidInCell.getCellAggregators(dimKeyInCell);
            if (this._hasYAxisMeasure) {
                BigDecimal yMeasureValue = aggregators[this._yAxisMeasureIdx].getNumberValue();
                node.setYAxisValue(yMeasureValue == null ? "" : yMeasureValue.toString());
            } else {
                node.setYAxisValue("0");
            }
            if (this._hasXAxisMeasure) {
                BigDecimal xMeasureValue = aggregators[this._xAxisMeasureIdx].getNumberValue();
                node.setXAxisValue(xMeasureValue == null ? "" : xMeasureValue.toString());
            } else {
                node.setXAxisValue("0");
            }
            if (hasSizeMeasure) {
                int sizeMeasureIdx = this.getMyMarkParser().getSizeFieldAtMeasures();
                BigDecimal sizeMeasureValue = aggregators[sizeMeasureIdx].getNumberValue();
                node.setZAxisValue(sizeMeasureValue == null ? null : sizeMeasureValue.toString());
            }
            AbstractNormalChartModel.Series series = chart.getSeries(seriesIndex);
            series.getNodes().set(categoryIndex, node);
        }
        this.cutTooLargeChart(chart);
        ChartCell cell = new ChartCell();
        cell.setChart(chart);
        return cell;
    }

    @Override
    protected void makeRedundance() {
        boolean hasSizeMeasure;
        boolean bl = hasSizeMeasure = this.getMyMarkParser().getSizeMeasureField() != null;
        if (this._hasXAxisMeasure) {
            this.createAxis(this._xAxisMeasureIdx, hasSizeMeasure);
        } else {
            this._commonChart.addValueScope("0", "0");
        }
        if (this._hasYAxisMeasure) {
            this.createAxis(this._yAxisMeasureIdx, hasSizeMeasure);
        } else {
            this._commonChart.addValueScope("0", "0");
        }
        if (hasSizeMeasure) {
            int zAxisMeasureidx = this.getMyMarkParser().getSizeFieldAtMeasures();
            this.createAxis(zAxisMeasureidx, false);
        }
        ChartCell cell = new ChartCell();
        cell.setChart(this._commonChart);
        this.getTableView().setCommonCell(cell);
    }

    private void createAxis(int measureIdx, boolean isAddMore) {
        AnalyticalField field = this.getModelAssistantStructure().getMeasureField(measureIdx);
        String fieldTitle = field.getTitle(this.getI18nCtx());
        String fieldFormat = field.getUsableNumberFormat();
        Scope scope = this.getMeasureScope(measureIdx);
        BigDecimal minValue = scope.getMin();
        BigDecimal maxValue = scope.getMax();
        if (isAddMore) {
            BigDecimal distance = maxValue.subtract(minValue);
            BigDecimal more = distance.divide(new BigDecimal(20), RoundingMode.HALF_UP);
            minValue = minValue.subtract(more);
            maxValue = maxValue.add(more);
        }
        String min = minValue.toString();
        String max = maxValue.toString();
        this._commonChart.addValueScope(min, max, fieldTitle, fieldFormat);
    }

    @Override
    protected int getCellHeapSize() {
        return this._estimatedHeapSizePerCell;
    }

    @Override
    protected boolean isCellMeasurable() {
        return false;
    }

    private Scope getXAxisScope() {
        return this.getMeasureScope(this._xAxisMeasureIdx);
    }

    private Scope getYAxisScope() {
        return this.getMeasureScope(this._yAxisMeasureIdx);
    }

    private Scope getZAxisScope() {
        int idx = this.getMyMarkParser().getSizeFieldAtMeasures();
        return this.getMeasureScope(idx);
    }

    private void makeCommonChart() {
        this._commonChart = new MultiSeriesChartModel();
        for (AbstractNormalChartModel.Category category : this._categoriesCollection.values()) {
            this._commonChart.addCategory(category);
        }
        this._commonChart.sortCategories(this.getI18nCtx().getLanManager().getLocale());
        List<AbstractNormalChartModel.Category> categories = this._commonChart.getCategoryList();
        int c = categories.size();
        for (int i = 0; i < c; ++i) {
            AbstractNormalChartModel.Category category = categories.get(i);
            this._categoriesIndex.put(category.getOrderingValue(), i);
        }
        AnalyticalField categoryField = this.getMyMarkParser().getCategoryField();
        this._commonChart.setCategoryTitle(categoryField == null ? null : categoryField.getTitle(this.getI18nCtx()));
        AnalyticalField colorField = this.getMyMarkParser().getColorField();
        if (colorField != null) {
            this._commonChart.setSeriesFieldTitle(colorField.getTitle(this.getI18nCtx()));
            this.addAllSeriesColors(colorField);
            int serierLimitedCount = 17;
            if (this._seriesSortedList.size() > serierLimitedCount) {
                this._seriesSortedList = this._seriesSortedList.subList(0, serierLimitedCount);
            }
        }
        this.cutTooLargeChart(this._commonChart);
    }

    private void cutTooLargeChart(MultiSeriesChartModel chart) {
        this.cutTooLarge(chart, 2048, 16);
    }

    private void addAllSeriesColors(AnalyticalField colorField) {
        List<AbstractChartModel.IOrderingSupported> sortedList = AbstractChartModel.toOrderedWrapList(this._seriesCollection, this.getI18nCtx().getLanManager().getLocale());
        for (AbstractChartModel.IOrderingSupported orderingObject : sortedList) {
            Object seriesValue = orderingObject.getOrderingValue();
            String seriesName = this.formatValue(seriesValue, colorField);
            this.makeDiscreteColorValue(orderingObject, seriesName);
            this._seriesSortedList.add(seriesValue);
        }
    }

    private Object getSeriesValue(CompositeKey dimKeyInCell) {
        int idx = this.getMyMarkParser().getColorIndexAtCellDimensions();
        Object seriesValue = dimKeyInCell.getMember(idx);
        return seriesValue;
    }

    private Object getCategoryValue(CompositeKey dimKeyInCell) {
        Object categoryValue;
        if (dimKeyInCell == null || dimKeyInCell.getMemberCount() == 0 || this.getMyMarkParser().getCategoryField() == null) {
            categoryValue = null;
        } else {
            int idx = this.getMyMarkParser().getCategoryIndexAtCellDimensions();
            categoryValue = dimKeyInCell.getMember(idx);
        }
        return categoryValue;
    }

    private int getCategoryIndex(Object categoryValue) {
        int categoryIndex = this._categoriesIndex.get(categoryValue);
        return categoryIndex;
    }

    private void collectCategory(Object categoryValue) {
        if (!this._categoriesCollection.containsKey(categoryValue)) {
            AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
            AnalyticalField categoryField = this.getMyMarkParser().getCategoryField();
            if (categoryField != null) {
                String label = this.formatValue(categoryValue, categoryField);
                category.setOrderingValue(categoryValue);
                category.setLabel(label);
                category.setValue(FlatBuilderForScatter.encodeCategoryValue(categoryValue, label));
            }
            this._categoriesCollection.put(categoryValue, category);
        }
    }

    private static class MarkParserForScatter
    extends AbstractMarkParser {
        private ModelAssistantStructure _mas;
        private AnalyticalField _categoryField;
        private AnalyticalField _colorField;
        private AnalyticalField _sizeMeasureField;
        private int _categoryIndexAtCellDimensions = -1;
        private int _colorIndexAtCellDimensions = -1;
        private int _sizeIndexAtMeasures = -1;

        public MarkParserForScatter(ModelAssistantStructure mas) {
            this._mas = mas;
        }

        public AnalyticalField getCategoryField() {
            return this._categoryField;
        }

        public int getCategoryIndexAtCellDimensions() {
            return this._categoryIndexAtCellDimensions;
        }

        public AnalyticalField getColorField() {
            return this._colorField;
        }

        public int getColorIndexAtCellDimensions() {
            return this._colorIndexAtCellDimensions;
        }

        public AnalyticalField getSizeMeasureField() {
            return this._sizeMeasureField;
        }

        public int getSizeFieldAtMeasures() {
            return this._sizeIndexAtMeasures;
        }

        @Override
        protected void confirmWhichMeasureToDraw(List<AnalyticalField> measureFields, boolean[] whichMeasureToDraw) {
            int i;
            int colorIdx;
            int blankIdx;
            int sizeIdx = this.searchMarkAsMeasure("size");
            if (sizeIdx >= 0) {
                this._sizeMeasureField = this.getModel().getField(sizeIdx);
                this._sizeIndexAtMeasures = MarkParserForScatter.getIndexAtMeasure(this._sizeMeasureField, measureFields);
            }
            if ((blankIdx = this.searchMarkAsDimension("blank")) >= 0) {
                this._categoryField = this.getModel().getField(blankIdx);
            }
            if ((colorIdx = this.searchMarkAsDimension("color")) >= 0) {
                this._colorField = this.getModel().getField(colorIdx);
            }
            List<AnalyticalField> fields = this._mas.getCellDimensionFields();
            for (i = 0; i < fields.size(); ++i) {
                AnalyticalField field = fields.get(i);
                if (field == this._categoryField) {
                    this._categoryIndexAtCellDimensions = i;
                    continue;
                }
                if (field != this._colorField) continue;
                this._colorIndexAtCellDimensions = i;
            }
            for (i = 0; i < whichMeasureToDraw.length; ++i) {
                whichMeasureToDraw[i] = true;
            }
        }
    }
}

