/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.longer;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.SubCuboidKey;
import com.kingdee.bos.qing.core.exception.EnvCeilingException;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilder;
import com.kingdee.bos.qing.core.flattening.longer.AbstractMarkParser;
import com.kingdee.bos.qing.core.flattening.longer.CuboidSpliter;
import com.kingdee.bos.qing.core.flattening.longer.HeaderForMeasure;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.ModelAssistantStructure;
import com.kingdee.bos.qing.core.model.analysis.longer.ParallelMeasureLayout;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.SingleSeriesChartModel;
import com.kingdee.bos.qing.core.model.exhibition.longer.DrawInfo;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.core.model.exhibition.longer.cell.ChartCell;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FlatBuilderForStackBar
extends AbstractFlatBuilder {
    private CuboidSpliter _cuboidSpliter;
    private Scope _unifiedAxisScope = new Scope();
    private Map<Object, AbstractNormalChartModel.Category> _categoriesCollection = new HashMap<Object, AbstractNormalChartModel.Category>();
    private int _estimatedHeapSizePerCell;

    @Override
    public HeaderForMeasure getTopRowForMeasureName(ParallelMeasureLayout pml) {
        String asAxis;
        int oneMoreRow;
        if (this.getModelAssistantStructure().isAxisMeasureAtRow()) {
            oneMoreRow = this.getDrawingMeasureCount() > 1 ? 1 : 0;
            asAxis = null;
        } else {
            oneMoreRow = this.getDrawingMeasureCount() == 0 ? 0 : 1;
            asAxis = "number";
        }
        return new HeaderForMeasure(oneMoreRow, asAxis);
    }

    @Override
    public HeaderForMeasure getLeftColumnForMeasureName(ParallelMeasureLayout pml) {
        String asAxis;
        int oneMoreRow;
        if (this.getModelAssistantStructure().isAxisMeasureAtRow()) {
            oneMoreRow = this.getDrawingMeasureCount() == 0 ? 0 : 1;
            asAxis = "number";
        } else {
            oneMoreRow = this.getDrawingMeasureCount() > 1 ? 1 : 0;
            asAxis = null;
        }
        return new HeaderForMeasure(oneMoreRow, asAxis);
    }

    @Override
    protected AbstractMarkParser createMarkParser() {
        return new MarkParserForStackBar(this.getModelAssistantStructure());
    }

    private MarkParserForStackBar getMyMarkParser() {
        return (MarkParserForStackBar)this.getMarkParser();
    }

    @Override
    protected void beforeFlatCuboid() {
        boolean isStackByMeasure = this.getMyMarkParser().isStackByMeasure();
        this._cuboidSpliter = this.createCuboidSpliter();
        int srcMeasureIdx = isStackByMeasure ? 0 : -1;
        int destMeasureIdx = -1;
        this._cuboidSpliter.openInsideSubtotal(srcMeasureIdx, destMeasureIdx);
        if (isStackByMeasure) {
            int measureCount = this.getModelAssistantStructure().getMeasureFieldCountForAxis();
            for (int i = 0; i < measureCount; ++i) {
                this.collectCategory(this.getMeasureTitle(i));
            }
        }
    }

    @Override
    protected Iterator<CompositeKey> prepareIteratorForFlatCuboid(Cuboid cuboid, SubCuboidKey subCuboidTag) throws EnvCeilingException {
        this._cuboidSpliter.standardizingCuboid(cuboid, subCuboidTag, new CuboidSpliter.AbstractDoMoreHandler(){

            @Override
            public void forDimension(CompositeKey dimKeyInCell) {
                if (FlatBuilderForStackBar.this.getMyMarkParser().getColorDimensionField() != null) {
                    Object categoryValue = FlatBuilderForStackBar.this.getCategoryValue(dimKeyInCell);
                    FlatBuilderForStackBar.this.collectCategory(categoryValue);
                }
            }
        });
        this._estimatedHeapSizePerCell = ChartCell.HEAPZISE_OVERHEAD + SingleSeriesChartModel.HEAPZISE_OVERHEAD + AbstractNormalChartModel.Series.HEAPZISE_OVERHEAD + (AbstractNormalChartModel.Category.HEAPZISE_OVERHEAD + AbstractNormalChartModel.Node.HEAPZISE_OVERHEAD) * this._categoriesCollection.size();
        return this._cuboidSpliter.getStandardizedCube(subCuboidTag).keySet().iterator();
    }

    @Override
    protected void flatCubeCell(SubCuboidKey subCuboidTag, boolean[] whichMeasureToDraw, CompositeKey dimKey) {
        if (this.getMyMarkParser().isStackByMeasure()) {
            AbstractFlatBuilder.GroupItem groupItem = this.createGroupItem(dimKey, subCuboidTag, 0);
            this.mapping(dimKey, groupItem, 0);
        } else {
            int measureIndexAtTable = 0;
            for (int i = 0; i < whichMeasureToDraw.length; ++i) {
                if (!whichMeasureToDraw[i]) continue;
                AbstractFlatBuilder.GroupItem groupItem = this.createGroupItem(dimKey, subCuboidTag, i);
                this.mapping(dimKey, groupItem, measureIndexAtTable++);
            }
        }
    }

    @Override
    protected void afterFlatCuboid() {
        this.makeCategoryColor();
        if (this.getMyMarkParser().isStackByMeasure()) {
            this.confirmDiscreteColorLegendTitlebyField(null);
        } else {
            AnalyticalField colorDimField = this.getMyMarkParser().getColorDimensionField();
            if (colorDimField != null) {
                this.confirmDiscreteColorLegendTitlebyField(colorDimField);
            }
        }
    }

    @Override
    protected int getCellHeapSize() {
        return this._estimatedHeapSizePerCell;
    }

    @Override
    protected ICell createCell(AbstractFlatBuilder.GroupItem item) {
        Locale sortingContext = this.getI18nCtx().getLanManager().getLocale();
        BigDecimal[] valueStack = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
        CompositeKey dimKey = item.getDimensionKey();
        int measureIndex = item.getMeasureIndex();
        SingleSeriesChartModel chart = new SingleSeriesChartModel();
        int measureCount = this.getModelAssistantStructure().getMeasureFieldCountForAxis();
        boolean isStackByMeasure = this.getMyMarkParser().isStackByMeasure();
        AnalyticalField colorDimField = this.getMyMarkParser().getColorDimensionField();
        Map<CompositeKey, Cuboid> rowColPartOfCuboid = this._cuboidSpliter.getStandardizedCube(item.getSubCuboidTag());
        Cuboid cuboidInCell = rowColPartOfCuboid.get(dimKey);
        Iterator<CompositeKey> it = cuboidInCell.createDimensionKeyIterator();
        while (it.hasNext()) {
            AbstractNormalChartModel.Category category;
            AbstractNormalChartModel.Node node;
            CompositeKey dimKeyInCell = it.next();
            if (this._cuboidSpliter.isSubtotalKey(dimKeyInCell)) continue;
            Aggregator[] aggregators = cuboidInCell.getCellAggregators(dimKeyInCell);
            if (isStackByMeasure) {
                for (int i = 0; i < measureCount; ++i) {
                    Aggregator aggregator = aggregators[i];
                    BigDecimal measureValue = aggregator.getNumberValue();
                    node = this.createNode(measureValue, i);
                    AbstractNormalChartModel.Category category2 = this._categoriesCollection.get(this.getMeasureTitle(i));
                    chart.addData(category2, node);
                    this.stack(measureValue, valueStack);
                }
                continue;
            }
            Aggregator aggregator = aggregators[measureIndex];
            BigDecimal measureValue = aggregator.getNumberValue();
            if (colorDimField == null) {
                category = AbstractNormalChartModel.EmptyCategory;
            } else {
                Object categoryValue = this.getCategoryValue(dimKeyInCell);
                category = this._categoriesCollection.get(categoryValue);
            }
            node = this.createNode(measureValue, measureIndex);
            chart.addDataWithSort(category, node, sortingContext);
            this.stack(measureValue, valueStack);
        }
        BigDecimal positiveStack = valueStack[0];
        BigDecimal negativeStack = valueStack[1];
        this._unifiedAxisScope.join(positiveStack);
        this._unifiedAxisScope.join(negativeStack);
        if (!isStackByMeasure && this.getModelAssistantStructure().getMeasureFieldCountForAxis() > 1) {
            chart.getOnlyOneSeries().setName(this.getMeasureTitle(measureIndex));
        }
        this.cutTooLarge(chart, 256, 16);
        ChartCell cell = new ChartCell();
        cell.setChart(chart);
        return cell;
    }

    private AbstractNormalChartModel.Node createNode(BigDecimal measureValue, int measureIndex) {
        AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
        node.setValue(measureValue == null ? "" : measureValue.toString());
        node.setText(this.formatNumber(measureValue, this.getModelAssistantStructure().getMeasureField(measureIndex)));
        return node;
    }

    private void stack(BigDecimal measureValue, BigDecimal[] valueStack) {
        if (measureValue != null) {
            if (measureValue.compareTo(BigDecimal.ZERO) > 0) {
                valueStack[0] = valueStack[0].add(measureValue);
            } else {
                valueStack[1] = valueStack[1].add(measureValue);
            }
        }
    }

    @Override
    protected void makeRedundance() {
        SingleSeriesChartModel chart = new SingleSeriesChartModel();
        boolean isStackByMeasure = this.getMyMarkParser().isStackByMeasure();
        if (isStackByMeasure) {
            chart.getOnlyOneSeries().setFormatString(this.getModelAssistantStructure().getMeasureField(0).getUsableNumberFormat());
        } else {
            AnalyticalField colorDimField = this.getMyMarkParser().getColorDimensionField();
            if (colorDimField == null) {
                AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
                category.setColor(this.getDefaultColorValue());
                chart.addData(category, null);
            } else {
                chart.setCategoryTitle(colorDimField.getTitle(this.getI18nCtx()));
            }
            if (this.getModelAssistantStructure().getMeasureFieldCountForAxis() == 1) {
                chart.getOnlyOneSeries().setName(this.getMeasureTitle(0));
            }
            if (this.getModelAssistantStructure().getMeasureFieldCountForAxis() > 0) {
                chart.getOnlyOneSeries().setFormatString(this.getModelAssistantStructure().getMeasureField(0).getUsableNumberFormat());
            }
        }
        chart.setValueScope(this._unifiedAxisScope.getMin().toString(), this._unifiedAxisScope.getMax().toString());
        ChartCell cell = new ChartCell();
        cell.setChart(chart);
        this.getTableView().setCommonCell(cell);
    }

    @Override
    protected BigDecimal getCellMeasurableValue(SubCuboidKey tag, CompositeKey dimKeyForRowCol, int measureIndex) {
        Cuboid cuboid;
        Map<CompositeKey, Cuboid> cube = this._cuboidSpliter.getStandardizedCube(tag);
        if (cube != null && (cuboid = cube.get(dimKeyForRowCol)) != null) {
            int idx = this.getMyMarkParser().isStackByMeasure() ? 0 : measureIndex;
            return this._cuboidSpliter.getInsideSubtotal(cuboid, idx);
        }
        return null;
    }

    private Object getCategoryValue(CompositeKey dimKeyInCell) {
        Object categoryValue = dimKeyInCell == null || dimKeyInCell.getMemberCount() == 0 ? null : dimKeyInCell.getMember(0);
        return categoryValue;
    }

    private void collectCategory(Object categoryValue) {
        if (!this._categoriesCollection.containsKey(categoryValue)) {
            AnalyticalField colorField = this.getMyMarkParser().getColorDimensionField();
            String label = colorField == null ? (categoryValue == null ? null : categoryValue.toString()) : this.formatValue(categoryValue, colorField);
            AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
            category.setOrderingValue(categoryValue);
            category.setLabel(label);
            category.setValue(FlatBuilderForStackBar.encodeCategoryValue(categoryValue, label));
            this._categoriesCollection.put(categoryValue, category);
        }
    }

    private void makeCategoryColor() {
        Collection<AbstractNormalChartModel.Category> categories = this._categoriesCollection.values();
        List<AbstractNormalChartModel.Category> sortedList = AbstractChartModel.toOrderedCollection(categories, this.getI18nCtx().getLanManager().getLocale());
        for (AbstractNormalChartModel.Category category : sortedList) {
            category.setColor(this.makeDiscreteColorValue(category, category.getLabel()));
        }
    }

    private static class MarkParserForStackBar
    extends AbstractMarkParser {
        private ModelAssistantStructure _mas;
        private AnalyticalField _colorDimensionField;
        private boolean _isStackByMeasure;

        public MarkParserForStackBar(ModelAssistantStructure mas) {
            this._mas = mas;
        }

        public AnalyticalField getColorDimensionField() {
            return this._colorDimensionField;
        }

        public boolean isStackByMeasure() {
            return this._isStackByMeasure;
        }

        @Override
        public DrawInfo.Direction getDirection() {
            return this._mas.isAxisMeasureAtRow() ? DrawInfo.Direction.LANDSCAPE : DrawInfo.Direction.PORTRAIT;
        }

        @Override
        protected void confirmWhichMeasureToDraw(List<AnalyticalField> measureFields, boolean[] whichMeasureToDraw) {
            int idx = this.searchMarkAsDimension("color");
            if (idx >= 0) {
                this._colorDimensionField = this.getModel().getFields().get(idx);
            }
            int measureCount = this._mas.getMeasureFieldCountForAxis();
            boolean bl = this._isStackByMeasure = this._colorDimensionField == null && measureCount > 1;
            if (this._isStackByMeasure) {
                if (whichMeasureToDraw.length > 0) {
                    whichMeasureToDraw[0] = true;
                }
            } else {
                for (int i = 0; i < whichMeasureToDraw.length; ++i) {
                    if (i >= measureCount) continue;
                    whichMeasureToDraw[i] = true;
                }
            }
        }
    }
}

