/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.longer;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.SubCuboidKey;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilder;
import com.kingdee.bos.qing.core.flattening.longer.AbstractMarkParser;
import com.kingdee.bos.qing.core.flattening.longer.HeaderForMeasure;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.ParallelMeasureLayout;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.core.model.exhibition.longer.cell.TextTableCell;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;

public class FlatBuilderForTable
extends AbstractFlatBuilder {
    private Cuboid _currentFlatingCuboid;

    @Override
    public HeaderForMeasure getTopRowForMeasureName(ParallelMeasureLayout pml) {
        int oneMoreRow = pml == ParallelMeasureLayout.AtColumn ? (this.getDrawingMeasureCount() > 1 ? 1 : 0) : 0;
        return new HeaderForMeasure(oneMoreRow, null);
    }

    @Override
    public HeaderForMeasure getLeftColumnForMeasureName(ParallelMeasureLayout pml) {
        int oneMoreRow = pml == ParallelMeasureLayout.AtRow ? (this.getDrawingMeasureCount() > 1 ? 1 : 0) : 0;
        return new HeaderForMeasure(oneMoreRow, null);
    }

    @Override
    protected AbstractMarkParser createMarkParser() {
        return new MarkParserForTable();
    }

    private MarkParserForTable getMyMarkParser() {
        return (MarkParserForTable)this.getMarkParser();
    }

    @Override
    protected Iterator<CompositeKey> prepareIteratorForFlatCuboid(Cuboid cuboid, SubCuboidKey subCuboidTag) {
        this._currentFlatingCuboid = cuboid;
        return cuboid.createDimensionKeyIterator();
    }

    @Override
    protected void flatCubeCell(SubCuboidKey subCuboidTag, boolean[] whichMeasureToDraw, CompositeKey dimKey) {
        int measureIndexAtTable = 0;
        for (int i = 0; i < whichMeasureToDraw.length; ++i) {
            if (whichMeasureToDraw[i]) {
                AbstractFlatBuilder.GroupItem groupItem = this.createGroupItem(dimKey, subCuboidTag, i);
                this.mapping(dimKey, groupItem, measureIndexAtTable++);
            }
            if (i != this.getMyMarkParser().getColorFieldIndexAtMeasure()) continue;
            Aggregator[] aggregators = this._currentFlatingCuboid.getCellAggregators(dimKey);
            Aggregator aggregator = aggregators[i];
            BigDecimal measureValue = aggregator.getNumberValue();
            Scope scope = this.getMeasureScope(i);
            scope.join(measureValue);
        }
    }

    @Override
    protected List<Object[]> createPlaneTopHeader() {
        return this.createPlaneTopHeaderImpl();
    }

    @Override
    protected int getCellHeapSize() {
        return TextTableCell.HEAPZISE_OVERHEAD;
    }

    @Override
    protected ICell createCell(AbstractFlatBuilder.GroupItem item) {
        int colorIndex;
        TextTableCell cell = new TextTableCell();
        CompositeKey dimKey = item.getDimensionKey();
        int measureIndex = item.getMeasureIndex();
        Aggregator[] aggregators = this.getCuboid(item.getSubCuboidTag()).getCellAggregators(dimKey);
        Aggregator aggregator = aggregators[measureIndex];
        BigDecimal measureValue = aggregator.getNumberValue();
        cell.setText(this.formatNumber(measureValue, this.getModelAssistantStructure().getMeasureField(measureIndex)));
        if (this.getDrawingMeasureCount() > 1) {
            cell.setTitle(this.getMeasureTitle(measureIndex));
        }
        if ((colorIndex = this.getMyMarkParser().getColorFieldIndexAtMeasure()) >= 0) {
            aggregator = aggregators[colorIndex];
            BigDecimal colorValue = aggregator.getNumberValue();
            cell.setColor(this.makeContinuousColorValue(colorValue, colorIndex, this.getMyMarkParser().getColorField()));
            if (colorIndex != measureIndex) {
                cell.setColorText(this.formatNumber(colorValue, this.getMyMarkParser().getColorField()));
            }
        }
        return cell;
    }

    @Override
    protected void makeRedundance() {
        TextTableCell cell = null;
        int colorIndex = this.getMyMarkParser().getColorFieldIndexAtMeasure();
        if (colorIndex >= 0) {
            cell = new TextTableCell();
            cell.setText("");
            cell.setColorTitle(this.getMeasureTitle(colorIndex));
        }
        if (this.getDrawingMeasureCount() == 1) {
            if (cell == null) {
                cell = new TextTableCell();
                cell.setText("");
            }
            boolean[] whichMeasureToDraw = this.getMarkParser().getWhichMeasureToDraw();
            for (int i = 0; i < whichMeasureToDraw.length; ++i) {
                if (!whichMeasureToDraw[i]) continue;
                cell.setTitle(this.getMeasureTitle(i));
                break;
            }
        }
        this.getTableView().setCommonCell(cell);
    }

    private static class MarkParserForTable
    extends AbstractMarkParser {
        private AnalyticalField _colorField;
        private int _colorIndexAtMeasure = -1;

        private MarkParserForTable() {
        }

        public AnalyticalField getColorField() {
            return this._colorField;
        }

        public int getColorFieldIndexAtMeasure() {
            return this._colorIndexAtMeasure;
        }

        @Override
        protected void confirmWhichMeasureToDraw(List<AnalyticalField> measureFields, boolean[] whichMeasureToDraw) {
            int colorIndexInMark = this.searchMarkAsMeasure("color");
            if (colorIndexInMark >= 0) {
                this._colorField = this.getModel().getFields().get(colorIndexInMark);
                this._colorIndexAtMeasure = MarkParserForTable.getIndexAtMeasure(this._colorField, measureFields);
            }
            List<AnalyticalField> labelFields = this.searchAllMarkFieldAsMeasure("label");
            for (int i = 0; i < labelFields.size(); ++i) {
                int idx = MarkParserForTable.getIndexAtMeasure(labelFields.get(i), measureFields);
                if (idx < 0) continue;
                whichMeasureToDraw[idx] = true;
            }
        }
    }
}

