/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.longer;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.SubCuboidKey;
import com.kingdee.bos.qing.core.exception.EnvCeilingException;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilder;
import com.kingdee.bos.qing.core.flattening.longer.AbstractMarkParser;
import com.kingdee.bos.qing.core.flattening.longer.CuboidSpliter;
import com.kingdee.bos.qing.core.flattening.longer.HeaderForMeasure;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.ParallelMeasureLayout;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.TreeMapChartModel;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.core.model.exhibition.longer.cell.ChartCell;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlatBuilderForTreeMap
extends AbstractFlatBuilder {
    private CuboidSpliter _cuboidSpliter;
    private BigDecimal _maxSizeValue = BigDecimal.ZERO;
    private Set<Object> _colorValuesCollection = new HashSet<Object>();
    private int _estimatedHeapSizePerCell;

    @Override
    public HeaderForMeasure getTopRowForMeasureName(ParallelMeasureLayout pml) {
        boolean noFrame;
        boolean bl = noFrame = this.getModelAssistantStructure().getColumnDimensionFieldCount() == 0;
        if (noFrame) {
            int moreLanes = this.getDrawingMeasureCount() == 0 ? 0 : 1;
            HeaderForMeasure headerForMeasure = new HeaderForMeasure(moreLanes, null);
            headerForMeasure.asBlank();
            return headerForMeasure;
        }
        return new HeaderForMeasure(0, null);
    }

    @Override
    public HeaderForMeasure getLeftColumnForMeasureName(ParallelMeasureLayout pml) {
        boolean noFrame;
        boolean bl = noFrame = this.getModelAssistantStructure().getRowDimensionFieldCount() == 0;
        if (noFrame) {
            int moreLanes = this.getDrawingMeasureCount() == 0 ? 0 : 1;
            HeaderForMeasure headerForMeasure = new HeaderForMeasure(moreLanes, null);
            headerForMeasure.asBlank();
            return headerForMeasure;
        }
        return new HeaderForMeasure(0, null);
    }

    @Override
    protected AbstractMarkParser createMarkParser() {
        return new MarkParserForTreeMap();
    }

    private MarkParserForTreeMap getMyMarkParser() {
        return (MarkParserForTreeMap)this.getMarkParser();
    }

    @Override
    protected Iterator<CompositeKey> prepareIteratorForFlatCuboid(Cuboid cuboid, SubCuboidKey subCuboidTag) throws EnvCeilingException {
        if (this._cuboidSpliter == null) {
            this._cuboidSpliter = this.createCuboidSpliter();
        }
        CuboidSpliter.AbstractDoMoreHandler doMore = null;
        if (this.getMyMarkParser().hasColorField()) {
            doMore = new CuboidSpliter.AbstractDoMoreHandler(){

                @Override
                public void forDimension(CompositeKey dimKeyInCell) {
                    if (!FlatBuilderForTreeMap.this.getMyMarkParser().isMeasureAsColor()) {
                        int colorDimensionIdx = FlatBuilderForTreeMap.this.getMyMarkParser().getColorFieldIndexAtDimension();
                        Object colorValue = dimKeyInCell.getMember(colorDimensionIdx);
                        FlatBuilderForTreeMap.this._colorValuesCollection.add(colorValue);
                    }
                }

                @Override
                public void forMeasure(int measureIndex, Aggregator aggregator) {
                    int colorMeasureIdx = FlatBuilderForTreeMap.this.getMyMarkParser().getColorFieldIndexAtMeasure();
                    if (measureIndex == colorMeasureIdx && FlatBuilderForTreeMap.this.getMyMarkParser().isMeasureAsColor()) {
                        BigDecimal colorValue = aggregator.getNumberValue();
                        Scope scope = FlatBuilderForTreeMap.this.getMeasureScope(colorMeasureIdx);
                        scope.join(colorValue);
                    }
                }
            };
        }
        this._cuboidSpliter.standardizingCuboid(cuboid, subCuboidTag, doMore);
        int displayMeasureCount = this.getModelAssistantStructure().getMeasureFieldCountForCell();
        this._estimatedHeapSizePerCell = ChartCell.HEAPZISE_OVERHEAD + MultiSeriesChartModel.HEAPZISE_OVERHEAD + AbstractNormalChartModel.Series.HEAPZISE_OVERHEAD * displayMeasureCount;
        return this._cuboidSpliter.getStandardizedCube(subCuboidTag).keySet().iterator();
    }

    @Override
    protected void flatCubeCell(SubCuboidKey subCuboidTag, boolean[] whichMeasureToDraw, CompositeKey dimKey) {
        int sizeMarkFieldIndex = this.getMyMarkParser().getSizeFieldIndexAtMeasure();
        AbstractFlatBuilder.GroupItem groupItem = this.createGroupItem(dimKey, subCuboidTag, sizeMarkFieldIndex);
        this.mapping(dimKey, groupItem, -1);
        if (sizeMarkFieldIndex >= 0) {
            Cuboid cuboidInCell = this._cuboidSpliter.getStandardizedCube(subCuboidTag).get(dimKey);
            Iterator<CompositeKey> keyInCellIterator = cuboidInCell.createDimensionKeyIterator();
            BigDecimal totalDecimal = BigDecimal.ZERO;
            while (keyInCellIterator.hasNext()) {
                Aggregator[] aggregators = cuboidInCell.getCellAggregators(keyInCellIterator.next());
                Aggregator aggregator = aggregators[sizeMarkFieldIndex];
                BigDecimal measureValue = aggregator.getNumberValue();
                if (measureValue == null || measureValue.compareTo(BigDecimal.ZERO) < 0) continue;
                totalDecimal = totalDecimal.add(measureValue);
            }
            this._maxSizeValue = this._maxSizeValue.max(totalDecimal);
        }
    }

    @Override
    protected void afterFlatCuboid() {
        if (!this.getMyMarkParser().hasColorField()) {
            return;
        }
        List<AbstractChartModel.IOrderingSupported> sortedList = AbstractChartModel.toOrderedWrapList(this._colorValuesCollection, this.getI18nCtx().getLanManager().getLocale());
        for (AbstractChartModel.IOrderingSupported colorValue : sortedList) {
            String seriesName = this.formatValue(colorValue.getOrderingValue(), this.getMyMarkParser().getColorField());
            this.makeDiscreteColorValue(colorValue, seriesName);
        }
        if (this.getMyMarkParser().hasColorField() && !this.getMyMarkParser().isMeasureAsColor()) {
            this.confirmDiscreteColorLegendTitlebyField(this.getMyMarkParser().getColorField());
        }
    }

    @Override
    protected int getCellHeapSize() {
        return this._estimatedHeapSizePerCell;
    }

    @Override
    protected ICell createCell(AbstractFlatBuilder.GroupItem item) {
        if (!this.getMyMarkParser().hasSizeField()) {
            return null;
        }
        TreeMapChartModel chart = new TreeMapChartModel();
        Map<CompositeKey, Cuboid> rowColPartOfCuboid = this._cuboidSpliter.getStandardizedCube(item.getSubCuboidTag());
        CompositeKey dimKey = item.getDimensionKey();
        Cuboid cuboidInCell = rowColPartOfCuboid.get(dimKey);
        Node root = this.convertCuboidToTree(cuboidInCell);
        double rootSize = this._maxSizeValue.equals(BigDecimal.ZERO) ? 0.0 : root.getSizeValue().divide(this._maxSizeValue, 10, 4).doubleValue();
        TreeMapChartModel.TreeMapNode treeMapRoot = this.convertToTreeMapNode(root);
        treeMapRoot.setSize(rootSize);
        chart.setRoot(treeMapRoot);
        int negativeCount = root.getNegativeCount();
        chart.setNegativeValueCount(negativeCount);
        if (negativeCount > 0) {
            String negativeCountInfo = String.valueOf(root.getNegativeCount());
            String negativeInfo = Messages.getLangMessage(this.getI18nCtx(), "negativeValueInfo", "#1\u9879\u975e\u6b63\u6570").replace("#1", negativeCountInfo);
            chart.setNegativeValueInfo(negativeInfo);
        }
        ChartCell cell = new ChartCell();
        cell.setChart(chart);
        return cell;
    }

    @Override
    protected BigDecimal getCellMeasurableValue(SubCuboidKey tag, CompositeKey dimKeyForRowCol, int measureIndex) {
        Cuboid cuboid;
        Map<CompositeKey, Cuboid> cube = this._cuboidSpliter.getStandardizedCube(tag);
        if (cube != null && measureIndex >= 0 && (cuboid = cube.get(dimKeyForRowCol)) != null) {
            Iterator<CompositeKey> keyInCellIterator = cuboid.createDimensionKeyIterator();
            BigDecimal totalDecimal = BigDecimal.ZERO;
            boolean isNoAnyValue = true;
            while (keyInCellIterator.hasNext()) {
                Aggregator[] aggregators = cuboid.getCellAggregators(keyInCellIterator.next());
                Aggregator aggregator = aggregators[measureIndex];
                BigDecimal measureValue = aggregator.getNumberValue();
                if (measureValue == null) continue;
                isNoAnyValue = false;
                if (measureValue.compareTo(BigDecimal.ZERO) <= 0) continue;
                totalDecimal = totalDecimal.add(measureValue);
            }
            return isNoAnyValue ? null : totalDecimal;
        }
        return null;
    }

    private Node convertCuboidToTree(Cuboid cuboidInCell) {
        Node root = new Node();
        Iterator<CompositeKey> it = cuboidInCell.createDimensionKeyIterator();
        int sizeMeasureIdx = this.getMyMarkParser().getSizeFieldIndexAtMeasure();
        while (it.hasNext()) {
            CompositeKey dimKeyInCell = it.next();
            Aggregator[] aggregators = cuboidInCell.getCellAggregators(dimKeyInCell);
            BigDecimal size = sizeMeasureIdx == -1 ? BigDecimal.ZERO : aggregators[sizeMeasureIdx].getNumberValue();
            Object colorValue = null;
            String color = null;
            int colorLevelIndex = -1;
            if (this.getMyMarkParser().hasColorField()) {
                if (this.getMyMarkParser().isMeasureAsColor()) {
                    int colorMeasureIdx = this.getMyMarkParser().getColorFieldIndexAtMeasure();
                    Aggregator colorAggregator = aggregators[colorMeasureIdx];
                    colorValue = colorAggregator.getNumberValue();
                    color = this.makeContinuousColorValue((BigDecimal)colorValue, colorMeasureIdx, this.getMyMarkParser().getColorField());
                    colorLevelIndex = dimKeyInCell == null ? 0 : dimKeyInCell.getMemberCount() - 1;
                } else {
                    int colorDimensionIdx = this.getMyMarkParser().getColorFieldIndexAtDimension();
                    colorValue = dimKeyInCell.getMember(colorDimensionIdx);
                    String colorText = this.formatValue(colorValue, this.getMyMarkParser().getColorField());
                    color = this.makeDiscreteColorValue(new AbstractChartModel.OrderingObject(colorValue), colorText);
                    colorLevelIndex = colorDimensionIdx;
                }
            } else {
                color = this.getDefaultColorValue();
                colorLevelIndex = 0;
            }
            String colorStringValue = this.formatValue(colorValue, this.getMyMarkParser().getColorField());
            root.append(dimKeyInCell, size, colorLevelIndex, color, colorStringValue);
        }
        root.calculateSizeValue();
        return root;
    }

    private TreeMapChartModel.TreeMapNode convertToTreeMapNode(Node root) {
        TreeMapChartModel.TreeMapNode chartRoot = new TreeMapChartModel.TreeMapNode("root", null);
        for (Map.Entry<Object, Node> entry : root.getChildren().entrySet()) {
            this.convertChildrenNode(chartRoot, 0, entry.getKey(), entry.getValue(), root.getSizeValue());
        }
        return chartRoot;
    }

    private void convertChildrenNode(TreeMapChartModel.TreeMapNode chartParentNode, int compositeKeyIndex, Object key, Node child, BigDecimal totalSum) {
        TreeMapChartModel.TreeMapNode subChartNode = null;
        if (this.getModelAssistantStructure().getCellDimensionFields().size() == 0) {
            subChartNode = chartParentNode.addChildNode(null, null);
        } else {
            AnalyticalField keyAnalyticalField = this.getModelAssistantStructure().getCellDimensionFields().get(compositeKeyIndex);
            String label = this.formatValue(key, keyAnalyticalField);
            String value = FlatBuilderForTreeMap.encodeCategoryValue(key, label);
            subChartNode = chartParentNode.addChildNode(label, value);
        }
        subChartNode.setColor(child.getColor());
        subChartNode.setColorText(child.getColorValue() == null ? null : child.getColorValue().toString());
        if (this.getMyMarkParser().hasSizeField()) {
            boolean isZero = totalSum.compareTo(BigDecimal.ZERO) <= 0;
            double percentage = isZero ? 0.0 : child.getSizeValue().divide(totalSum, 10, 4).doubleValue();
            BigDecimal sizeValue = child.getSizeValue();
            subChartNode.setSizeText(this.formatNumber(sizeValue, this.getMyMarkParser().getSizeField()));
            subChartNode.setSize(percentage);
        }
        for (Map.Entry<Object, Node> entry : child.getChildren().entrySet()) {
            this.convertChildrenNode(subChartNode, compositeKeyIndex + 1, entry.getKey(), entry.getValue(), child.getSizeValue());
        }
    }

    @Override
    protected void makeRedundance() {
        TreeMapChartModel chart = new TreeMapChartModel();
        List<AnalyticalField> cellDimensions = this.getModelAssistantStructure().getCellDimensionFields();
        String[] cellDimensionTitles = new String[cellDimensions.size()];
        for (int i = 0; i < cellDimensions.size(); ++i) {
            AnalyticalField field = cellDimensions.get(i);
            cellDimensionTitles[i] = field.getTitle(this.getI18nCtx());
        }
        chart.setDimTitles(cellDimensionTitles);
        if (this.getMyMarkParser().hasColorField()) {
            chart.setColorFieldTitle(this.getMyMarkParser().getColorField().getTitle(this.getI18nCtx()));
        }
        if (this.getMyMarkParser().hasSizeField()) {
            chart.setSizeFieldTitle(this.getMyMarkParser().getSizeField().getTitle(this.getI18nCtx()));
        }
        ChartCell cell = new ChartCell();
        cell.setChart(chart);
        this.getTableView().setCommonCell(cell);
    }

    private static class Node {
        private String color;
        private Object colorValue;
        private BigDecimal sizeValue = BigDecimal.ZERO;
        private int negativeCount = 0;
        private Map<Object, Node> children = new HashMap<Object, Node>();

        private Node() {
        }

        public BigDecimal calculateSizeValue() {
            if (this.children.isEmpty()) {
                return this.sizeValue;
            }
            for (Map.Entry<Object, Node> entry : this.children.entrySet()) {
                Node node = entry.getValue();
                this.sizeValue = this.sizeValue.add(node.calculateSizeValue());
            }
            return this.sizeValue;
        }

        public void append(CompositeKey key, BigDecimal sizeValue, int colorLevelIndex, String color, Object colorValue) {
            if (sizeValue == null) {
                return;
            }
            if (BigDecimal.ZERO.compareTo(sizeValue) >= 0) {
                ++this.negativeCount;
                return;
            }
            Node node = this.getOrCreateNode(key, 0, colorLevelIndex, color, colorValue);
            node.sizeValue = sizeValue;
        }

        private Node getOrCreateNode(CompositeKey compositeKey, int keyMemberIdx, int colorIdx, String color, Object colorValue) {
            Object keyValue = compositeKey == null ? null : compositeKey.getMember(keyMemberIdx);
            Node node = this.children.get(keyValue);
            if (node == null) {
                node = new Node();
                this.children.put(keyValue, node);
                if (keyMemberIdx == colorIdx) {
                    node.setColor(color);
                    node.setColorValue(colorValue);
                }
            }
            if (compositeKey != null && keyMemberIdx < compositeKey.getMemberCount() - 1) {
                return node.getOrCreateNode(compositeKey, ++keyMemberIdx, colorIdx, color, colorValue);
            }
            return node;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public Object getColorValue() {
            return this.colorValue;
        }

        public void setColorValue(Object colorValue) {
            this.colorValue = colorValue;
        }

        public Map<Object, Node> getChildren() {
            return this.children;
        }

        public BigDecimal getSizeValue() {
            return this.sizeValue;
        }

        public String getColor() {
            return this.color;
        }

        public int getNegativeCount() {
            return this.negativeCount;
        }
    }

    private class MarkParserForTreeMap
    extends AbstractMarkParser {
        private AnalyticalField _sizeMarkField;
        private int _sizeFieldIndexAtMeasure = -1;
        private AnalyticalField _colorMarkField;
        private boolean _isColorAsMeasure;
        private int _colorFieldIndexAtMeasure = -1;
        private int _colorFieldIndexAtDimension = -1;

        private MarkParserForTreeMap() {
        }

        @Override
        protected void confirmWhichMeasureToDraw(List<AnalyticalField> measureFields, boolean[] whichMeasureToDraw) {
            int colorIdx;
            for (int i = 0; i < whichMeasureToDraw.length; ++i) {
                whichMeasureToDraw[i] = true;
            }
            int sizeIdx = this.searchMarkAsMeasure("size");
            if (sizeIdx >= 0) {
                this._sizeMarkField = this.getModel().getField(sizeIdx);
                this._sizeFieldIndexAtMeasure = MarkParserForTreeMap.getIndexAtMeasure(this._sizeMarkField, measureFields);
            }
            if ((colorIdx = this.searchMarkAsMeasure("color")) >= 0) {
                this._isColorAsMeasure = true;
                this._colorMarkField = this.getModel().getField(colorIdx);
                this._colorFieldIndexAtMeasure = MarkParserForTreeMap.getIndexAtMeasure(this._colorMarkField, measureFields);
            } else {
                colorIdx = this.searchMarkAsDimension("color");
                if (colorIdx >= 0) {
                    this._colorMarkField = this.getModel().getField(colorIdx);
                    this._colorFieldIndexAtDimension = FlatBuilderForTreeMap.this.getModelAssistantStructure().getCellDimensionFields().indexOf(this._colorMarkField);
                }
            }
        }

        public boolean hasColorField() {
            return this._colorMarkField != null;
        }

        public AnalyticalField getColorField() {
            return this._colorMarkField;
        }

        public boolean isMeasureAsColor() {
            return this._isColorAsMeasure;
        }

        public int getColorFieldIndexAtMeasure() {
            return this._colorFieldIndexAtMeasure;
        }

        public int getColorFieldIndexAtDimension() {
            return this._colorFieldIndexAtDimension;
        }

        public boolean hasSizeField() {
            return this._sizeMarkField != null;
        }

        public AnalyticalField getSizeField() {
            return this._sizeMarkField;
        }

        public int getSizeFieldIndexAtMeasure() {
            return this._sizeFieldIndexAtMeasure;
        }
    }
}

