/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.common.format.Formater;
import com.kingdee.bos.qing.common.format.NumberFormater;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.DataSourceGreenChannel;
import com.kingdee.bos.qing.core.engine.IEngineOutput;
import com.kingdee.bos.qing.core.engine.ParentChildDimensionMember;
import com.kingdee.bos.qing.core.engine.SubCuboidKey;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.DataTraversalException;
import com.kingdee.bos.qing.core.exception.UserStoppedException;
import com.kingdee.bos.qing.core.flattening.common.ContinuousColorConfirmer;
import com.kingdee.bos.qing.core.flattening.common.DiscreteColorConfirmer;
import com.kingdee.bos.qing.core.flattening.common.ExecutableValueCoder;
import com.kingdee.bos.qing.core.flattening.common.Palette;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.common.sort.AbstractSortProcessor;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.ContinuousColor;
import com.kingdee.bos.qing.core.model.analysis.common.CustomPalette;
import com.kingdee.bos.qing.core.model.analysis.common.PartValue;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.AbstractChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.common.Legends;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.square.SquareView;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.monitor.ICorrespondent;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSquareViewMaker {
    private II18nContext _i18nContext;
    private String _skinName;
    private ICorrespondent _correspondent;
    private AddendumDataVisitor _addendumDataVisitor;
    private SquareModel _squareModel;
    private IEngineOutput _engine;
    private Cuboid _cuboid;
    private Map<String, Formater> _mapFormater;
    private AbstractColorValueMaker _colorValueMaker;
    private SquareView _squareView;

    public final void transferContextFrom(AbstractSquareViewMaker another) {
        this.setQingContext(another.getI18nContext(), another.getSkinName());
        this.setAddendumDataVisitor(another.getAddendumDataVisitor());
        this.setModel(another.getModel());
        this.setEngineOutputer(another.getEngineOutputer());
    }

    public final void setQingContext(II18nContext i18nCtx, String skinName) {
        this._i18nContext = i18nCtx;
        this._skinName = skinName;
    }

    protected final II18nContext getI18nContext() {
        return this._i18nContext;
    }

    public final String getSkinName() {
        return this._skinName;
    }

    public final void setModel(SquareModel model) {
        this._squareModel = model;
    }

    protected final SquareModel getModel() {
        return this._squareModel;
    }

    public final void setEngineOutputer(IEngineOutput eo) {
        this._engine = eo;
    }

    private IEngineOutput getEngineOutputer() {
        return this._engine;
    }

    protected final Cuboid getCuboid() {
        if (this._cuboid == null) {
            this._cuboid = this._engine.getCuboid();
        }
        return this._cuboid;
    }

    protected final void updateCuboid(Cuboid cuboid) {
        this._cuboid = cuboid;
    }

    protected final Cuboid getGrandTotalCuboid() {
        Cuboid subCuboid = null;
        Collection<SubCuboidKey> tags = this.getEngineOutputer().getSubCuboidTags();
        if (tags.size() == 1) {
            Iterator<SubCuboidKey> itSubCuboids = tags.iterator();
            SubCuboidKey subCuboidKey = itSubCuboids.next();
            subCuboid = this.getEngineOutputer().getSubCuboid(subCuboidKey);
        }
        return subCuboid;
    }

    protected final void checkUserStop() throws UserStoppedException {
        if (this._correspondent != null) {
            this._correspondent.checkStoppedByUser();
        }
    }

    public final void setCorrespondent(ICorrespondent correspondent) {
        this._correspondent = correspondent;
    }

    protected final ICorrespondent getCorrespondent() {
        return this._correspondent;
    }

    public final void make() throws AnalysisException {
        boolean isCutTooLarge;
        AbstractChartModel chart = this.makeChart();
        this._squareView = new SquareView();
        this._squareView.setDataEmpty(this.getCuboid().getCellCount() == 0);
        this._squareView.setChartType(this.getModel().getChartModel().getChartType());
        this._squareView.setChart(chart);
        if (this._colorValueMaker != null && this.getModel().getChartModel().getChartProperty().getShowLegend() != AbstractChartProperty.ShowLegend.NON) {
            Legends legends = new Legends();
            this._colorValueMaker.createLegends(legends);
            this._squareView.setLegends(legends);
        }
        if (isCutTooLarge = this.cutTooLargeChart(chart)) {
            String warning = Messages.getLangMessage(this.getI18nContext(), "cutTooLargeChart", "\u6570\u636e\u91cf\u8d85\u51fa\u89c6\u56fe\u5c55\u73b0\u80fd\u529b\uff0c\u5df2\u505a\u88c1\u526a\u3002");
            this._squareView.setWarning(warning);
        } else if (this._squareView.isDataEmpty() && this.getModel().getChartModel().getChartProperty().isShowDataEmptyTips()) {
            String warning = Messages.getLangMessage(this.getI18nContext(), "squareNothingToDisplay", "\u6ca1\u6709\u53ef\u5c55\u73b0\u7684\u6570\u636e");
            this._squareView.setWarning(warning);
        }
    }

    public final SquareView getSquareView() {
        return this._squareView;
    }

    protected abstract AbstractChartModel makeChart() throws AnalysisException;

    protected final String getMeasureTitle(AnalyticalField field) {
        return field.getTitle(this._i18nContext);
    }

    protected final AbstractNormalChartModel.Node createNode(BigDecimal measureValue, AnalyticalField measureField) {
        if (measureValue == null) {
            return null;
        }
        return this.createNodeNotNull(measureValue, measureField);
    }

    protected final AbstractNormalChartModel.Node createNodeNotNull(BigDecimal measureValue, AnalyticalField measureField) {
        AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
        node.setOrigin(measureValue);
        node.setValue(measureValue == null ? "" : measureValue.toString());
        if (measureField == null) {
            node.setText(node.getValue());
        } else {
            node.setText(this.formatNumber(measureValue, measureField));
        }
        return node;
    }

    protected final String formatNumber(BigDecimal value, AnalyticalField analyticalField) {
        Comparable<BigDecimal> formatTarget;
        if (value == null) {
            return "";
        }
        String formatString = analyticalField.getUsableFormat(this._i18nContext);
        if (analyticalField.isFormatingAsDate()) {
            formatTarget = Aggregator.bigDecimalToCalendar(value);
        } else {
            formatTarget = value;
            if (formatString == null || formatString.length() == 0) {
                int scale = value.scale();
                formatString = "#,##0" + (scale == 0 ? "" : (scale == 1 ? ".0" : ".00"));
            }
        }
        Formater formater = this.getFormater(formatString);
        return formater.format((Object)formatTarget);
    }

    protected final String formatNumber(BigDecimal value, String formatString) {
        if (value == null) {
            return "";
        }
        Formater formater = this.getFormater(formatString);
        return formater.format((Object)value);
    }

    protected final String formatValue(Object value, AnalyticalField analyticalField) {
        if (value == null) {
            return "";
        }
        if (DataType.STRING == analyticalField.getDataType()) {
            return value.toString();
        }
        String formatString = analyticalField.getUsableFormat(this.getI18nContext());
        if (formatString == null || formatString.length() == 0) {
            return value.toString();
        }
        Formater formater = this.getFormater(formatString);
        if (value instanceof Calendar) {
            int formatingPart = PartValue.constraintFormating(analyticalField.getPartValue());
            return formater.format((Calendar)value, formatingPart);
        }
        return formater.format(value);
    }

    private Formater getFormater(String formatString) {
        Formater formater;
        if (this._mapFormater == null) {
            this._mapFormater = new HashMap<String, Formater>();
        }
        if ((formater = this._mapFormater.get(formatString)) == null) {
            formater = new Formater();
            formater.setFormatString(formatString);
            formater.setI18nContext(this._i18nContext);
            this._mapFormater.put(formatString, formater);
        }
        return formater;
    }

    protected final String getDefaultColor() {
        CustomPalette customPalette = this.getModel().getChartModel().getChartProperty().getCustomPalette();
        if (customPalette != null && !customPalette.getColors().isEmpty()) {
            return customPalette.getColors().get(0);
        }
        return Palette.getDefaultColor(this.getSkinName());
    }

    protected final void setColorValueMaker(AbstractColorValueMaker colorValueMaker) {
        this._colorValueMaker = colorValueMaker;
    }

    protected final AbstractColorValueMaker getColorValueMaker() {
        if (this._colorValueMaker == null) {
            this._colorValueMaker = this.createColorValueMaker();
        }
        return this._colorValueMaker;
    }

    protected AbstractColorValueMaker createColorValueMaker() {
        return new CommonDiscreateColorValueMaker();
    }

    protected final ContinuousColorValueMaker createContinuousColorValueMaker(AnalyticalField colorField, ContinuousColor colorDefine, String legendFormat) {
        return new ContinuousColorValueMaker(colorDefine, colorField, legendFormat);
    }

    protected final String makeDiscreteColorValue(AbstractChartModel.IOrderingSupported object, String text, boolean isLegendLonelyIgnored) {
        return ((CommonDiscreateColorValueMaker)this.getColorValueMaker()).makeDiscreteColorValue(object, text, isLegendLonelyIgnored);
    }

    protected Palette.PaletteType getPaletteType() {
        return Palette.PaletteType.BASE;
    }

    protected float getPaletteTranslucenceAlpha() {
        return 1.0f;
    }

    protected boolean cutTooLargeChart(AbstractChartModel chart) {
        boolean isHappened = false;
        if (chart instanceof AbstractNormalChartModel) {
            int categoryLimitedCount = this.getCategoryMemberLimitedCount();
            int seriesLimitedCount = this.getSeriesMemberLimitedCount();
            AbstractNormalChartModel nc = (AbstractNormalChartModel)chart;
            isHappened = nc.cutTooLarge(categoryLimitedCount, seriesLimitedCount);
        }
        return isHappened;
    }

    protected int getCategoryMemberLimitedCount() {
        return 512;
    }

    protected int getSeriesMemberLimitedCount() {
        return 32;
    }

    protected final AbstractNormalChartModel.Category createCategoryForOthers(AbstractSortProcessor.OthersMember others, AnalyticalField categoryField) throws AnalysisException {
        AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
        String text = Messages.getLangMessage(this.getI18nContext(), "others", "\u5176\u5b83");
        Set<Object> members = others.getAllRealMembers();
        String value = AbstractSquareViewMaker.encodeCategoryValue(members);
        category.setLabel(text);
        category.setValue(value);
        for (Object member : members) {
            if (!this.searchPcdChildrenExist(member, categoryField)) continue;
            category.setAsParent(true);
            break;
        }
        return category;
    }

    protected final void makePcdCategoryAsParent(Object member, AnalyticalField categoryField, AbstractNormalChartModel.Category category) throws AnalysisException {
        if (this.searchPcdChildrenExist(member, categoryField)) {
            category.setAsParent(true);
        }
    }

    private boolean searchPcdChildrenExist(Object member, AnalyticalField categoryField) throws AnalysisException {
        if (member instanceof ParentChildDimensionMember && categoryField.isParentChildDimension()) {
            String parentIdFieldName = categoryField.getParentChildDimensionParentIdField().getFullName();
            Object idValue = ((ParentChildDimensionMember)member).getIdValue();
            return this.getAddendumDataVisitor().isDataExist(parentIdFieldName, idValue);
        }
        return false;
    }

    public final void setAddendumDataVisitor(AddendumDataVisitor addendumDataVisitor) {
        this._addendumDataVisitor = addendumDataVisitor;
    }

    protected final AddendumDataVisitor getAddendumDataVisitor() {
        return this._addendumDataVisitor;
    }

    protected static final String encodeCategoryValue(Set<Object> values) {
        return ExecutableValueCoder.dimemsionMembersToJsonString(values);
    }

    protected static final String encodeCategoryValue(Object categoryValue, String label) {
        return ExecutableValueCoder.dimemsionMemberToJsonString(categoryValue, label);
    }

    protected static class ContinuousColorValueMaker
    extends AbstractColorValueMaker {
        private ContinuousColor _model;
        private AnalyticalField _colorField;
        private String _legendFormat;
        private ContinuousColorConfirmer _continuousColorConfirmer;

        public ContinuousColorValueMaker(ContinuousColor model, AnalyticalField colorField, String legendFormat) {
            this._model = model;
            this._colorField = colorField;
            this._legendFormat = legendFormat;
        }

        public String makeContinuousColorValue(BigDecimal measureValue, Scope scope) {
            if (this._continuousColorConfirmer == null) {
                this._continuousColorConfirmer = new ContinuousColorConfirmer(scope.getMin(), scope.getMax());
                this._continuousColorConfirmer.setDefinition(this._model);
            }
            if (measureValue == null) {
                measureValue = scope.getMin();
            }
            return this._continuousColorConfirmer.getColor(measureValue);
        }

        @Override
        public void createLegends(Legends legends) {
            if (this._continuousColorConfirmer != null) {
                String format = this._legendFormat == null ? this._colorField.getUsableNumberFormat() : this._legendFormat;
                NumberFormater formater = new NumberFormater();
                formater.setFormatString(format);
                String minText = formater.format(this._continuousColorConfirmer.getScopeLeft());
                String maxText = formater.format(this._continuousColorConfirmer.getScopeRight());
                Legends.ContinuousColorLegend ccl = this._continuousColorConfirmer.createLegend(minText, maxText);
                legends.setContinuousColorLegend(ccl);
            }
        }
    }

    public class CommonDiscreateColorValueMaker
    extends AbstractColorValueMaker {
        private DiscreteColorConfirmer _discreteColorConfirmer;

        public String makeDiscreteColorValue(AbstractChartModel.IOrderingSupported object, String text, boolean isLegendLonelyIgnored) {
            if (this._discreteColorConfirmer == null) {
                List<String> colors = null;
                CustomPalette customPalette = AbstractSquareViewMaker.this.getModel().getChartModel().getChartProperty().getCustomPalette();
                if (customPalette != null) {
                    colors = customPalette.getColors();
                }
                if (colors == null || colors.size() == 0) {
                    this._discreteColorConfirmer = new DiscreteColorConfirmer(AbstractSquareViewMaker.this._skinName, AbstractSquareViewMaker.this._i18nContext, AbstractSquareViewMaker.this.getPaletteType());
                } else {
                    String[] paletteColors = colors.toArray(new String[0]);
                    this._discreteColorConfirmer = new DiscreteColorConfirmer(paletteColors, AbstractSquareViewMaker.this._i18nContext);
                }
                this._discreteColorConfirmer.setTranslucence(AbstractSquareViewMaker.this.getPaletteTranslucenceAlpha());
            }
            this._discreteColorConfirmer.setLegendLonelyIgnored(isLegendLonelyIgnored);
            return this._discreteColorConfirmer.getColor(object, text);
        }

        @Override
        public void createLegends(Legends legends) {
            if (this._discreteColorConfirmer != null && !this._discreteColorConfirmer.isLegendIgnored()) {
                Legends.DiscreteColorLegend dcl = this._discreteColorConfirmer.createLegend();
                legends.setDiscreteColorLegend(dcl);
            }
        }
    }

    public static abstract class AbstractColorValueMaker {
        public abstract void createLegends(Legends var1);
    }

    public static class AddendumDataVisitor {
        private IDataSourceVisitor _dataSourceVisitor;
        private Map<String, Set<Object>> _distinctValuePool;

        public AddendumDataVisitor(IDataSourceVisitor dataSourceVisitor) {
            this._dataSourceVisitor = dataSourceVisitor;
        }

        private Set<Object> getDistinctValueSet(final String metaFieldFullName) throws DataTraversalException, UserStoppedException {
            Set<Object> dictinctValueSet;
            if (this._distinctValuePool == null) {
                this._distinctValuePool = new HashMap<String, Set<Object>>();
            }
            if ((dictinctValueSet = this._distinctValuePool.get(metaFieldFullName)) == null) {
                final HashSet<Object> dvs = new HashSet<Object>();
                DataSourceGreenChannel greenChannel = new DataSourceGreenChannel(this._dataSourceVisitor);
                try {
                    greenChannel.getDistinctValue(metaFieldFullName, new DataSourceGreenChannel.AbstractValueCollecter(){

                        @Override
                        public void accept(Map<String, Object> values) {
                            Object value = values.get(metaFieldFullName);
                            dvs.add(value);
                        }
                    });
                }
                catch (AbstractDataSourceException e) {
                    throw new DataTraversalException((Exception)((Object)e));
                }
                this._distinctValuePool.put(metaFieldFullName, dvs);
                dictinctValueSet = dvs;
            }
            return dictinctValueSet;
        }

        public boolean isDataExist(String metaFieldFullName, Object value) throws AnalysisException {
            return this.getDistinctValueSet(metaFieldFullName).contains(value);
        }
    }
}

