/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.flattening.common.DiscreteColorConfirmer;
import com.kingdee.bos.qing.core.flattening.common.Palette;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.square.AbstractSquareViewMaker;
import com.kingdee.bos.qing.core.flattening.square.refline.AbstractReflineCalculator;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.Refline;
import com.kingdee.bos.qing.core.model.analysis.square.chart.Scatter;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.ScatterChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class MakerForScatter
extends AbstractSquareViewMaker {
    private MultiSeriesChartModel _chart;
    private boolean _hasCategoryField;
    private boolean _hasSeriesField;
    private boolean _hasXAxisField;
    private boolean _hasYAxisField;
    private boolean _hasZAxisField;
    private Map<Object, Integer> _categoryIndexMap = new HashMap<Object, Integer>();
    private Map<Object, AbstractNormalChartModel.Category> _categoryMap = new HashMap<Object, AbstractNormalChartModel.Category>();
    private Map<Object, AbstractNormalChartModel.Series> _seriesMap = new HashMap<Object, AbstractNormalChartModel.Series>();
    private List<AbstractReflineCalculator> _xReflineCalculators;
    private List<AbstractReflineCalculator> _yReflineCalculators;

    MakerForScatter() {
    }

    private Scatter getDesignChartModel() {
        return (Scatter)this.getModel().getChartModel();
    }

    private ScatterChartProperty getDesignChartProperty() {
        return (ScatterChartProperty)this.getModel().getChartModel().getChartProperty();
    }

    @Override
    protected Palette.PaletteType getPaletteType() {
        return Palette.PaletteType.CONTRASTING_AREA;
    }

    @Override
    protected float getPaletteTranslucenceAlpha() {
        if (this.getDesignChartModel().getZAxisFieldSet().getFieldCount() == 0) {
            return 1.0f;
        }
        return 0.7f;
    }

    @Override
    protected AbstractChartModel makeChart() throws AnalysisException {
        this._chart = new MultiSeriesChartModel();
        if (this.getCuboid().getCellCount() > 0) {
            this.parseDesignModel();
            this.scanDimension();
            this.scanMeasure();
            this.outputReflines();
        }
        return this._chart;
    }

    private void parseDesignModel() {
        AbstractReflineCalculator calculator;
        AnalyticalField measureField;
        List<Refline> reflines;
        this._hasCategoryField = this.getDesignChartModel().getCategoryFieldSet().getFieldCount() > 0;
        this._hasSeriesField = this.getDesignChartModel().getSeriesFieldSet().getFieldCount() > 0;
        this._hasXAxisField = this.getDesignChartModel().getXAxisFieldSet().getFieldCount() > 0;
        this._hasYAxisField = this.getDesignChartModel().getYAxisFieldSet().getFieldCount() > 0;
        boolean bl = this._hasZAxisField = this.getDesignChartModel().getZAxisFieldSet().getFieldCount() > 0;
        if (this._hasXAxisField && (reflines = this.getDesignChartProperty().getXReflines()) != null) {
            measureField = this.getDesignChartModel().getXAxisFieldSet().getField(0);
            for (Refline refline : reflines) {
                calculator = AbstractReflineCalculator.create(refline);
                calculator.setMeasureField(measureField);
                if (this._xReflineCalculators == null) {
                    this._xReflineCalculators = new ArrayList<AbstractReflineCalculator>();
                }
                this._xReflineCalculators.add(calculator);
            }
        }
        if (this._hasYAxisField && (reflines = this.getDesignChartProperty().getYReflines()) != null) {
            measureField = this.getDesignChartModel().getYAxisFieldSet().getField(0);
            for (Refline refline : reflines) {
                calculator = AbstractReflineCalculator.create(refline);
                calculator.setMeasureField(measureField);
                if (this._yReflineCalculators == null) {
                    this._yReflineCalculators = new ArrayList<AbstractReflineCalculator>();
                }
                this._yReflineCalculators.add(calculator);
            }
        }
    }

    private void scanDimension() {
        AnalyticalField categoryField = this._hasCategoryField ? this.getDesignChartModel().getCategoryFieldSet().getField(0) : null;
        AnalyticalField seriesField = this._hasSeriesField ? this.getDesignChartModel().getSeriesFieldSet().getField(0) : null;
        Iterator<CompositeKey> itKeys = this.getCuboid().createDimensionKeyIterator();
        while (itKeys.hasNext()) {
            String value;
            String text;
            Object seriesMember;
            Object categoryMember;
            CompositeKey dimKey = itKeys.next();
            Object object = categoryMember = this._hasCategoryField ? dimKey.getMember(0) : null;
            Object object2 = this._hasSeriesField ? (this._hasCategoryField ? dimKey.getMember(1) : dimKey.getMember(0)) : (seriesMember = null);
            if (!this._categoryMap.containsKey(categoryMember)) {
                AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
                if (this._hasCategoryField) {
                    text = this.formatValue(categoryMember, categoryField);
                    value = MakerForScatter.encodeCategoryValue(categoryMember, text);
                    category.setLabel(text);
                    category.setValue(value);
                }
                this._categoryIndexMap.put(categoryMember, this._chart.getCategories().size());
                this._chart.addCategory(category);
                this._categoryMap.put(categoryMember, category);
            }
            if (this._seriesMap.containsKey(seriesMember)) continue;
            AbstractNormalChartModel.Series series = this._chart.addSeries("");
            if (this._hasSeriesField) {
                text = this.formatValue(seriesMember, seriesField);
                value = MakerForScatter.encodeCategoryValue(seriesMember, text);
                series.setSeriesFieldValueText(value, text);
                series.setOrderingValue(seriesMember);
            } else {
                String color = this.getDefaultColor();
                color = DiscreteColorConfirmer.createColorWithAlpha(color, this.getPaletteTranslucenceAlpha());
                series.setColor(color);
            }
            this._seriesMap.put(seriesMember, series);
        }
        if (this._hasCategoryField) {
            this._chart.setCategoryTitle(categoryField.getTitle(this.getI18nContext()));
        }
        if (this._hasSeriesField) {
            this._chart.setSeriesFieldTitle(seriesField.getTitle(this.getI18nContext()));
            this._chart.sortSeries(this.getI18nContext().getLanManager().getLocale());
            for (AbstractNormalChartModel.Series series : this._chart.getSeries()) {
                series.setColor(this.makeDiscreteColorValue(series, series.getSeriesFieldText(), false));
            }
        }
    }

    private void scanMeasure() {
        Scope scopeX = new Scope();
        Scope scopeY = new Scope();
        Scope scopeZ = new Scope();
        int categoryCount = this._chart.getCategories().size();
        Cuboid cuboid = this.getCuboid();
        Iterator<CompositeKey> itKeys = cuboid.createDimensionKeyIterator();
        while (itKeys.hasNext()) {
            Aggregator agg;
            CompositeKey dimKey = itKeys.next();
            Object seriesMember = this._hasSeriesField ? (this._hasCategoryField ? dimKey.getMember(1) : dimKey.getMember(0)) : null;
            int categoryIdx = 0;
            if (this._hasCategoryField) {
                Object categoryMember = dimKey.getMember(0);
                categoryIdx = this._categoryIndexMap.get(categoryMember);
            }
            AbstractNormalChartModel.Series series = this._seriesMap.get(seriesMember);
            List<AbstractNormalChartModel.INode> nodes = series.getCategoryFitnessNodeList(categoryCount);
            AbstractNormalChartModel.XYNode node = new AbstractNormalChartModel.XYNode();
            nodes.set(categoryIdx, node);
            int measureIdx = 0;
            Aggregator[] aggs = cuboid.getCellAggregators(dimKey);
            if (this._hasXAxisField) {
                BigDecimal xValue;
                node.setXAxisValue((xValue = (agg = aggs[measureIdx++]).getNumberValue()) == null ? "" : xValue.toString());
                scopeX.join(xValue);
                this.dealReflines(this._xReflineCalculators, xValue);
            } else {
                node.setXAxisValue("0");
            }
            if (this._hasYAxisField) {
                BigDecimal yValue;
                node.setYAxisValue((yValue = (agg = aggs[measureIdx++]).getNumberValue()) == null ? "" : yValue.toString());
                scopeY.join(yValue);
                this.dealReflines(this._yReflineCalculators, yValue);
            } else {
                node.setYAxisValue("0");
            }
            if (!this._hasZAxisField) continue;
            agg = aggs[measureIdx];
            BigDecimal zValue = agg.getNumberValue();
            node.setZAxisValue(zValue == null ? null : zValue.toString());
            scopeZ.join(zValue);
        }
        this.reflineJoinInScope(this._xReflineCalculators, scopeX);
        this.reflineJoinInScope(this._yReflineCalculators, scopeY);
        AbstractNormalChartModel.AxisValueScope chartScopeX = this._chart.addValueScope(scopeX.getMin().toString(), scopeX.getMax().toString());
        scopeX.makeRulerScale(chartScopeX);
        AbstractNormalChartModel.AxisValueScope chartScopeY = this._chart.addValueScope(scopeY.getMin().toString(), scopeY.getMax().toString());
        scopeY.makeRulerScale(chartScopeY);
        if (this._hasXAxisField) {
            AnalyticalField field = this.getDesignChartModel().getXAxisFieldSet().getField(0);
            chartScopeX.setTitle(this.getMeasureTitle(field));
            chartScopeX.setFormatString(field.getUsableNumberFormat());
        }
        if (this._hasYAxisField) {
            AnalyticalField field = this.getDesignChartModel().getYAxisFieldSet().getField(0);
            chartScopeY.setTitle(this.getMeasureTitle(field));
            chartScopeY.setFormatString(field.getUsableNumberFormat());
        }
        if (this._hasZAxisField) {
            AbstractNormalChartModel.AxisValueScope chartScopeZ = this._chart.addValueScope(scopeZ.getMin().toString(), scopeZ.getMax().toString());
            scopeZ.makeRulerScale(chartScopeZ);
            AnalyticalField field = this.getDesignChartModel().getZAxisFieldSet().getField(0);
            chartScopeZ.setTitle(this.getMeasureTitle(field));
            chartScopeZ.setFormatString(field.getUsableNumberFormat());
        }
    }

    private void dealReflines(List<AbstractReflineCalculator> reflineCalculators, BigDecimal measureValue) {
        if (reflineCalculators != null) {
            for (AbstractReflineCalculator calculator : reflineCalculators) {
                calculator.collect(measureValue);
            }
        }
    }

    private void reflineJoinInScope(List<AbstractReflineCalculator> reflineCalculators, Scope scope) {
        if (reflineCalculators != null) {
            for (AbstractReflineCalculator calculator : reflineCalculators) {
                BigDecimal value = calculator.getLineValue();
                if (value == null) continue;
                scope.join(value);
            }
        }
    }

    private void outputReflines() {
        List<AbstractNormalChartModel.PaintableLine> pls;
        if (this._xReflineCalculators != null) {
            pls = this._chart.createOneAxisPaintableLines();
            for (AbstractReflineCalculator calculator : this._xReflineCalculators) {
                pls.add(calculator.getResult(this.getI18nContext()));
            }
        }
        if (this._yReflineCalculators != null) {
            if (this._xReflineCalculators == null) {
                this._chart.createOneAxisPaintableLines();
            }
            pls = this._chart.createOneAxisPaintableLines();
            for (AbstractReflineCalculator calculator : this._yReflineCalculators) {
                pls.add(calculator.getResult(this.getI18nContext()));
            }
        }
    }
}

