/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.common.TreeChartHandler;
import com.kingdee.bos.qing.core.flattening.square.AbstractSquareViewMaker;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.chart.Sunburst;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.SunburstChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.TreeChartModel;
import java.math.BigDecimal;

class MakerForSunburst
extends AbstractSquareViewMaker {
    private TreeChartHandler _treeChartHandler;

    MakerForSunburst() {
    }

    private Sunburst getDesignChart() {
        return (Sunburst)this.getModel().getChartModel();
    }

    private SunburstChartProperty getDesignChartProperty() {
        return (SunburstChartProperty)this.getModel().getChartModel().getChartProperty();
    }

    @Override
    protected boolean cutTooLargeChart(AbstractChartModel chart) {
        return this._treeChartHandler.isCutTooLarge();
    }

    @Override
    protected AbstractChartModel makeChart() throws AnalysisException {
        this._treeChartHandler = new TreeChartHandler();
        this._treeChartHandler.setI18nContext(this.getI18nContext());
        this._treeChartHandler.setChartProperty(this.getDesignChartProperty().isHideNegative(), this.getDesignChartProperty().getLegendOrderMode());
        this._treeChartHandler.setCuboid(this.getCuboid());
        this._treeChartHandler.setHandlerRelative(new TreeChartHandler.AbstractRelative(){

            @Override
            public String formatValue(Object value, AnalyticalField analyticalField) {
                return MakerForSunburst.this.formatValue(value, analyticalField);
            }

            @Override
            public String formatNumber(BigDecimal value, AnalyticalField analyticalField) {
                return MakerForSunburst.this.formatNumber(value, analyticalField);
            }

            @Override
            public String encodeCategoryValue(Object categoryValue, String label) {
                return MakerForSunburst.encodeCategoryValue(categoryValue, label);
            }

            @Override
            public String getDefaultColor() {
                return MakerForSunburst.this.makeDiscreteColorValue(new AbstractChartModel.OrderingObject(""), "", true);
            }

            @Override
            public String makeDiscreteColorValue(AbstractChartModel.IOrderingSupported object, String text) {
                return MakerForSunburst.this.makeDiscreteColorValue(object, text, false);
            }

            @Override
            public String makeContinuousColorValue(BigDecimal measureValue, Scope scope, AnalyticalField colorField) {
                throw new UnsupportedOperationException();
            }
        });
        this.parseDesignModel();
        TreeChartModel chart = this._treeChartHandler.makeChartModel();
        return chart;
    }

    private void parseDesignModel() {
        if (this.getDesignChart().getMeasureSet().getFieldCount() > 0) {
            AnalyticalField field = this.getDesignChart().getMeasureSet().getField(0);
            int measureIdx = 0;
            this._treeChartHandler.setSizeDefine(field, measureIdx);
        }
        if (this.getDesignChart().getDimensionSet().getFieldCount() > 0) {
            AnalyticalField colorField = this.getDesignChart().getDimensionSet().getField(0);
            int colorDimensionIdx = 0;
            this._treeChartHandler.setDiscreteColorDefine(colorField, colorDimensionIdx);
        }
    }
}

