/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square;

import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.sort.CommonComparator;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.flattening.common.DiscreteColorConfirmer;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.square.AbstractSquareViewMaker;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.CustomPalette;
import com.kingdee.bos.qing.core.model.analysis.square.chart.Waterfall;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.WaterfallChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

class MakerForWaterfall
extends AbstractSquareViewMaker {
    private boolean _hasStage;
    private AnalyticalField _stageField;
    private AnalyticalField _clauseField;
    private AnalyticalField _measureField;
    private CommonComparator _comparer;
    private String _positiveColor;
    private String _negativeColor;
    private String _stageColor;
    private MultiSeriesChartModel _chart;
    private Scope _scope;
    private List<AbstractNormalChartModel.INode> _distanceValueNodes;
    private List<AbstractNormalChartModel.INode> _startValueNodes;

    MakerForWaterfall() {
    }

    private Waterfall getDesignChartModel() {
        return (Waterfall)this.getModel().getChartModel();
    }

    private WaterfallChartProperty getDesignChartProperty() {
        return (WaterfallChartProperty)this.getModel().getChartModel().getChartProperty();
    }

    private void parseDesignModel() {
        this._hasStage = this.getDesignChartModel().getStageFieldSet().getFieldCount() > 0;
        this._stageField = this._hasStage ? this.getDesignChartModel().getStageFieldSet().getField(0) : null;
        this._clauseField = this.getDesignChartModel().getClauseFieldSet().getField(0);
        this._measureField = this.getDesignChartModel().getMeasureFieldSet().getField(0);
    }

    @Override
    protected AbstractChartModel makeChart() throws AnalysisException {
        this._chart = new MultiSeriesChartModel();
        this._distanceValueNodes = this._chart.addSeries("value").getNodes();
        this._startValueNodes = this._chart.addSeries("start").getNodes();
        this._scope = new Scope();
        if (this.getDesignChartModel().getClauseFieldSet().getFieldCount() > 0 && this.getDesignChartModel().getMeasureFieldSet().getFieldCount() > 0) {
            if (this.getCuboid().getCellCount() == 0) {
                this.makeChartWhenDataEmpty();
            } else {
                this.parseDesignModel();
                this.prepareColor();
                List<SortableItem> items = this.sort();
                this.runningAdd(items);
                this._chart.getSeries(0).setFormatString(this._measureField.getUsableNumberFormat());
            }
            this._chart.addValueScope(this._scope.getMin().toString(), this._scope.getMax().toString());
        }
        return this._chart;
    }

    private void makeChartWhenDataEmpty() {
        this._chart.addCategory(new AbstractNormalChartModel.Category());
        this._startValueNodes.add(this.createNodeNotNull(BigDecimal.ZERO, null));
        this._distanceValueNodes.add(this.createNodeNotNull(BigDecimal.ZERO, null));
        this._scope.join(BigDecimal.ONE);
    }

    private void prepareColor() {
        List<String> colors = null;
        CustomPalette customPalette = this.getDesignChartProperty().getCustomPalette();
        if (customPalette == null) {
            return;
        }
        colors = customPalette.getColors();
        if (colors == null || colors.isEmpty()) {
            return;
        }
        String[] paletteColors = colors.toArray(new String[0]);
        DiscreteColorConfirmer discreteColorConfirmer = new DiscreteColorConfirmer(paletteColors, this.getI18nContext());
        this._positiveColor = this.makeColor(discreteColorConfirmer, 1);
        this._negativeColor = this.makeColor(discreteColorConfirmer, -1);
        this._stageColor = this.makeColor(discreteColorConfirmer, 0);
    }

    private List<SortableItem> sort() {
        ArrayList<SortableItem> items = new ArrayList<SortableItem>();
        Iterator<CompositeKey> it = this.getCuboid().createDimensionKeyIterator();
        while (it.hasNext()) {
            Object clause;
            Object stage;
            CompositeKey dimKey = it.next();
            if (this._hasStage) {
                stage = dimKey.getMember(0);
                clause = dimKey.getMember(1);
            } else {
                stage = null;
                clause = dimKey.getMember(0);
            }
            BigDecimal measure = this.getCuboid().getCellAggregators(dimKey)[0].getNumberValue();
            SortableItem item = new SortableItem(stage, clause, measure);
            items.add(item);
        }
        Collections.sort(items);
        return items;
    }

    private void runningAdd(List<SortableItem> items) {
        OutputConfirmer confirmer = null;
        if (!this.getDesignChartProperty().isSortByName()) {
            confirmer = new OutputConfirmer(this.getDesignChartProperty().getNegativeTopN(), this.getDesignChartProperty().getPositiveTopN(), this.getDesignChartProperty().isNegativeAhead());
        }
        boolean outputClause = !this._hasStage || !this.getDesignChartProperty().isStartFromStage();
        Comparable<?> lastStage = null;
        BigDecimal total = BigDecimal.ZERO;
        for (SortableItem item : items) {
            Comparable<?> stage = item.getStage();
            BigDecimal measure = item.getMeasure();
            if (this._hasStage && lastStage != null && this.getCommonComparator().compare(stage, lastStage) != 0) {
                outputClause = true;
                if (confirmer != null && confirmer.stageFinish() == Output.StoredAndThis) {
                    this.appendClauseOfOthers(confirmer);
                }
                String label = this.formatValue(lastStage, this._stageField);
                this.appendStage(label, total);
            }
            if (outputClause) {
                Output output;
                Output output2 = output = confirmer == null ? Output.This : confirmer.accept(measure, total);
                if (output == Output.StoredAndThis) {
                    this.appendClauseOfOthers(confirmer);
                }
                if (output == Output.This || output == Output.StoredAndThis) {
                    String label = this.formatValue(item.getClause(), this._clauseField);
                    BigDecimal startValue = total;
                    BigDecimal distanceValue = measure;
                    this.appendClause(label, startValue, distanceValue);
                }
            }
            lastStage = stage;
            if (measure == null) continue;
            total = total.add(measure);
            this._scope.join(total);
        }
        if (confirmer != null && confirmer.stageFinish() == Output.StoredAndThis) {
            this.appendClauseOfOthers(confirmer);
        }
        if (this._hasStage || !this.getDesignChartProperty().isWithoutTotal()) {
            String label = this._hasStage ? this.formatValue(lastStage, this._stageField) : Messages.getLangMessage(this.getI18nContext(), "total", "\u7d2f\u8ba1");
            this.appendStage(label, total);
        }
    }

    private void appendStage(String label, BigDecimal distanceValue) {
        this.addOneCategory(label, this._stageColor);
        this._startValueNodes.add(null);
        this._distanceValueNodes.add(this.createNodeNotNull(distanceValue, this._measureField));
    }

    private void appendClause(String label, BigDecimal startValue, BigDecimal distanceValue) {
        String color = MakerForWaterfall.isNegative(distanceValue) ? this._negativeColor : this._positiveColor;
        this.addOneCategory(label, color);
        this._startValueNodes.add(this.createNodeNotNull(startValue, null));
        this._distanceValueNodes.add(this.createNodeNotNull(distanceValue, this._measureField));
    }

    private void appendClauseOfOthers(OutputConfirmer confirmer) {
        String label = Messages.getLangMessage(this.getI18nContext(), "others", "\u5176\u5b83");
        BigDecimal startValue = confirmer.getOthersStart();
        BigDecimal distanceValue = confirmer.getOthersDistance();
        this.appendClause(label, startValue, distanceValue);
    }

    private void addOneCategory(String label, String color) {
        AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
        category.setLabel(label);
        if (color != null) {
            category.setColor(color);
        }
        this._chart.addCategory(category);
    }

    private String makeColor(DiscreteColorConfirmer discreteColorConfirmer, int tag) {
        AbstractNormalChartModel.Category category = new AbstractNormalChartModel.Category();
        category.setOrderingValue(tag);
        return discreteColorConfirmer.getColor(category, "");
    }

    private CommonComparator getCommonComparator() {
        if (this._comparer == null) {
            Locale locale = this.getI18nContext().getLanManager().getLocale();
            this._comparer = new CommonComparator(locale);
            this._comparer.setEmptyAheadAlways(false);
        }
        return this._comparer;
    }

    private static boolean isNegative(BigDecimal value) {
        return value != null && value.signum() < 0;
    }

    private class SortableItem
    implements Comparable<SortableItem> {
        private Comparable<?> _stage;
        private Comparable<?> _clause;
        private BigDecimal _measure;

        public SortableItem(Object stage, Object clause, BigDecimal measure) {
            this._stage = (Comparable)stage;
            this._clause = (Comparable)clause;
            this._measure = measure;
        }

        public Comparable<?> getStage() {
            return this._stage;
        }

        public Comparable<?> getClause() {
            return this._clause;
        }

        public BigDecimal getMeasure() {
            return this._measure;
        }

        @Override
        public int compareTo(SortableItem o) {
            int compared = MakerForWaterfall.this.getCommonComparator().compare(this._stage, o._stage);
            if (compared == 0) {
                if (MakerForWaterfall.this.getDesignChartProperty().isSortByName()) {
                    compared = MakerForWaterfall.this.getCommonComparator().compare(this._clause, o._clause);
                } else {
                    compared = MakerForWaterfall.this.getCommonComparator().compare(this._measure, o._measure);
                    if (compared == 0) {
                        compared = MakerForWaterfall.this.getCommonComparator().compare(this._clause, o._clause);
                    } else if (this._measure != null && o._measure != null) {
                        boolean thisNegative = MakerForWaterfall.isNegative(this._measure);
                        boolean anotherNegative = MakerForWaterfall.isNegative(o._measure);
                        if (thisNegative && anotherNegative) {
                            if (!MakerForWaterfall.this.getDesignChartProperty().isNegativeOrderAsc()) {
                                compared = -compared;
                            }
                        } else if (!thisNegative && !anotherNegative) {
                            if (!MakerForWaterfall.this.getDesignChartProperty().isPositiveOrderAsc()) {
                                compared = -compared;
                            }
                        } else if (!MakerForWaterfall.this.getDesignChartProperty().isNegativeAhead()) {
                            compared = -compared;
                        }
                    }
                }
            }
            return compared;
        }
    }

    private static class TopNHandler {
        private int _topN;
        private int _count;
        private BigDecimal _othersStart;
        private BigDecimal _othersDistance;

        public TopNHandler(int topN) {
            this._topN = topN;
            this.reset();
        }

        public void reset() {
            this._count = 0;
            this._othersStart = null;
            this._othersDistance = null;
        }

        public Output handle(BigDecimal value, BigDecimal start) {
            Output output;
            if (this._count < this._topN) {
                output = Output.This;
            } else {
                if (this._count == this._topN) {
                    this._othersStart = start;
                }
                this._othersDistance = this._othersDistance == null ? value : this._othersDistance.add(value);
                output = Output.None;
            }
            ++this._count;
            return output;
        }

        public boolean isStoredOthers() {
            return this._count >= this._topN + 1;
        }

        public BigDecimal[] keepOthers() {
            return new BigDecimal[]{this._othersStart, this._othersDistance};
        }
    }

    private static class OutputConfirmer {
        private int _negativeTopN;
        private int _positiveTopN;
        private boolean _negativeAhead;
        private TopNHandler _negativeHandler;
        private TopNHandler _positiveHandler;
        private boolean _handlingNegative;
        private BigDecimal[] _othersWaitingToVisit;

        public OutputConfirmer(int negativeTopN, int positiveTopN, boolean negativeAhead) {
            this._negativeTopN = negativeTopN;
            this._positiveTopN = positiveTopN;
            this._negativeAhead = negativeAhead;
            this._negativeHandler = this._negativeTopN > 0 ? new TopNHandler(this._negativeTopN) : null;
            this._positiveHandler = this._positiveTopN > 0 ? new TopNHandler(this._positiveTopN) : null;
            this.restart();
        }

        public Output stageFinish() {
            return this.restart();
        }

        private Output restart() {
            boolean stored = false;
            if (this._negativeHandler != null) {
                if (this._handlingNegative) {
                    stored = this._negativeHandler.isStoredOthers();
                    this._othersWaitingToVisit = this._negativeHandler.keepOthers();
                }
                this._negativeHandler.reset();
            }
            if (this._positiveHandler != null) {
                if (!this._handlingNegative) {
                    stored = this._positiveHandler.isStoredOthers();
                    this._othersWaitingToVisit = this._positiveHandler.keepOthers();
                }
                this._positiveHandler.reset();
            }
            this._handlingNegative = this._negativeAhead;
            return stored ? Output.StoredAndThis : Output.None;
        }

        public Output accept(BigDecimal value, BigDecimal start) {
            if (this._negativeHandler == null && this._positiveHandler == null) {
                return Output.This;
            }
            if (this._negativeAhead) {
                return this.handleNagativeAhead(value, start);
            }
            return this.handlePositiveAhead(value, start);
        }

        private Output handleNagativeAhead(BigDecimal value, BigDecimal start) {
            Output output;
            if (MakerForWaterfall.isNegative(value)) {
                output = this._negativeHandler != null ? this._negativeHandler.handle(value, start) : Output.This;
            } else {
                output = this._positiveHandler != null ? this._positiveHandler.handle(value, start) : Output.This;
                if (this._handlingNegative) {
                    this._handlingNegative = false;
                    if (this._negativeHandler != null && this._negativeHandler.isStoredOthers()) {
                        this._othersWaitingToVisit = this._negativeHandler.keepOthers();
                        output = Output.StoredAndThis;
                    }
                }
            }
            return output;
        }

        private Output handlePositiveAhead(BigDecimal value, BigDecimal start) {
            Output output;
            if (!MakerForWaterfall.isNegative(value)) {
                output = this._positiveHandler != null ? this._positiveHandler.handle(value, start) : Output.This;
            } else {
                output = this._negativeHandler != null ? this._negativeHandler.handle(value, start) : Output.This;
                if (!this._handlingNegative) {
                    this._handlingNegative = true;
                    if (this._positiveHandler != null && this._positiveHandler.isStoredOthers()) {
                        this._othersWaitingToVisit = this._positiveHandler.keepOthers();
                        output = Output.StoredAndThis;
                    }
                }
            }
            return output;
        }

        public BigDecimal getOthersStart() {
            return this._othersWaitingToVisit[0];
        }

        public BigDecimal getOthersDistance() {
            return this._othersWaitingToVisit[1];
        }
    }

    private static enum Output {
        This,
        None,
        StoredAndThis;

    }
}

