/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.square.refline;

import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.flattening.square.refline.AbstractReflineCalculator;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.analysis.common.Refline;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class MedCalculator
extends AbstractReflineCalculator {
    private List<BigDecimal> _collector = new ArrayList<BigDecimal>();

    public MedCalculator(Refline model) {
        super(model);
    }

    @Override
    public void collect(BigDecimal value) {
        if (value != null) {
            this._collector.add(value);
        }
    }

    @Override
    public BigDecimal getLineValue() {
        Object mid;
        int size = this._collector.size();
        if (size == 0) {
            return null;
        }
        Object[] ary = this._collector.toArray(new BigDecimal[0]);
        Arrays.sort(ary);
        int half = size >> 1;
        if (size % 2 == 0) {
            Object mid1 = ary[half - 1];
            Object mid2 = ary[half];
            int scale = Math.max(((BigDecimal)mid1).scale(), ((BigDecimal)mid2).scale());
            scale = Math.min(15, Math.max(8, scale));
            mid = ((BigDecimal)mid1).add((BigDecimal)mid2).divide(new BigDecimal(2), scale, 4);
        } else {
            mid = ary[half];
        }
        return mid;
    }

    @Override
    public AbstractNormalChartModel.PaintableLine getResult(II18nContext i18nCtx) {
        AbstractNormalChartModel.PaintableLine pl = null;
        BigDecimal mid = this.getLineValue();
        if (mid != null) {
            pl = new AbstractNormalChartModel.PaintableLine();
            String tipsTitle = Messages.getLangMessage(i18nCtx, "reflineMedTipsTitle", "#1\u7684\u4e2d\u4f4d\u6570");
            tipsTitle = tipsTitle.replaceFirst("#1", this.getMeasreTitle(i18nCtx));
            String label = this.getDesignModel().getLabel();
            if (label == null || label.isEmpty()) {
                pl.setLabel(null);
            } else {
                pl.setLabel(label);
            }
            pl.setLineValue(mid.toString());
            pl.setTipsTitle(tipsTitle);
            pl.setTipsText(this.format(mid));
        }
        return pl;
    }
}

