/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.common;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.util.XmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class ContinuousColor {
    private GradientColor forward;
    private GradientColor backward;
    private Integer segment;
    private String min;
    private String middle;
    private String max;
    private boolean wholeColorRange;

    public GradientColor getColorForward() {
        return this.forward;
    }

    public void setColorForward(GradientColor color) {
        this.forward = color;
    }

    public GradientColor getColorBackward() {
        return this.backward;
    }

    public void setColorBackward(GradientColor color) {
        this.backward = color;
    }

    public Integer getSegment() {
        return this.segment;
    }

    public void setSegment(Integer segment) {
        this.segment = segment;
    }

    public String getMin() {
        return this.min;
    }

    public void setMin(String min) {
        this.min = min;
    }

    public String getMiddle() {
        return this.middle;
    }

    public void setMiddle(String middle) {
        this.middle = middle;
    }

    public String getMax() {
        return this.max;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public boolean isUsingWholeColorRange() {
        return this.wholeColorRange;
    }

    public void setUsingWholeColorRange(boolean value) {
        this.wholeColorRange = value;
    }

    public void toXml(Element node) {
        if (this.forward != null) {
            Element nodeForward = new Element("Forward");
            this.forward.toXml(nodeForward);
            node.addContent((Content)nodeForward);
        }
        if (this.backward != null) {
            Element nodeBackward = new Element("Backward");
            this.backward.toXml(nodeBackward);
            node.addContent((Content)nodeBackward);
        }
        XmlUtil.writeAttrIntWhenExist((Element)node, (String)"segment", (Integer)this.segment);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"min", (String)this.min);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"middle", (String)this.middle);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"max", (String)this.max);
        XmlUtil.writeAttrDefaultFalse((Element)node, (String)"wholeColorRange", (boolean)this.wholeColorRange);
    }

    public void fromXml(Element node) throws PersistentModelParseException {
        Element nodeForward = XmlUtil.getChild((Element)node, (String)"Forward");
        if (nodeForward == null) {
            this.forward = null;
        } else {
            this.forward = new GradientColor();
            this.forward.fromXml(nodeForward);
        }
        Element nodeBackward = XmlUtil.getChild((Element)node, (String)"Backward");
        if (nodeBackward == null) {
            this.backward = null;
        } else {
            this.backward = new GradientColor();
            this.backward.fromXml(nodeBackward);
        }
        this.segment = XmlUtil.readAttrIntWhenExist((Element)node, (String)"segment");
        this.min = XmlUtil.readAttrWhenExist((Element)node, (String)"min");
        this.middle = XmlUtil.readAttrWhenExist((Element)node, (String)"middle");
        this.max = XmlUtil.readAttrWhenExist((Element)node, (String)"max");
        this.wholeColorRange = XmlUtil.readAttrDefaultFalse((Element)node, (String)"wholeColorRange");
    }

    public static class GradientColor {
        private int ha;
        private int sa;
        private int la;
        private int hb;
        private int sb;
        private int lb;

        private GradientColor() {
        }

        public GradientColor(int ha, int sa, int la, int hb, int sb, int lb) {
            this.ha = ha;
            this.sa = sa;
            this.la = la;
            this.hb = hb;
            this.sb = sb;
            this.lb = lb;
        }

        public int getHueA() {
            return this.ha;
        }

        public int getSaturationA() {
            return this.sa;
        }

        public int getLightnessA() {
            return this.la;
        }

        public int getHueB() {
            return this.hb;
        }

        public int getSaturationB() {
            return this.sb;
        }

        public int getLightnessB() {
            return this.lb;
        }

        public void toXml(Element node) {
            String valueA = this.encode(this.ha, this.sa, this.la);
            String valueB = this.encode(this.hb, this.sb, this.lb);
            XmlUtil.writeAttrNotNull((Element)node, (String)"a", (String)valueA);
            XmlUtil.writeAttrNotNull((Element)node, (String)"b", (String)valueB);
        }

        public void fromXml(Element node) throws PersistentModelParseException {
            String valueB;
            String valueA;
            try {
                valueA = XmlUtil.readAttrNotNull((Element)node, (String)"a");
                valueB = XmlUtil.readAttrNotNull((Element)node, (String)"b");
            }
            catch (XmlUtil.NullException ex) {
                throw new PersistentModelParseException(ex);
            }
            int[] hslA = this.decode(valueA);
            this.ha = hslA[0];
            this.sa = hslA[1];
            this.la = hslA[2];
            int[] hslB = this.decode(valueB);
            this.hb = hslB[0];
            this.sb = hslB[1];
            this.lb = hslB[2];
        }

        private String encode(int h, int s, int l) {
            return h + "," + s + "," + l;
        }

        private int[] decode(String str) {
            String[] parts = str.split(",");
            int[] hsl = new int[3];
            if (parts.length == 3) {
                hsl[0] = Math.abs(this.parseValue(parts[0])) % 360;
                hsl[1] = Math.max(0, Math.min(100, this.parseValue(parts[1])));
                hsl[2] = Math.max(0, Math.min(100, this.parseValue(parts[2])));
            }
            return hsl;
        }

        private int parseValue(String value) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }
    }
}

