/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.common;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.util.XmlUtil;
import java.math.BigDecimal;
import java.util.Calendar;
import org.jdom2.Element;

public class ExecutableValue {
    private DataType dataType;
    private String value;
    private transient Object _value;

    public ExecutableValue() {
    }

    public ExecutableValue(DataType dataType) {
        this.dataType = dataType;
    }

    public ExecutableValue(DataType dataType, String value) {
        this.dataType = dataType;
        this.value = value;
    }

    public Object getOriginalValue() {
        if (this._value == null) {
            switch (this.dataType) {
                case Str: {
                    this._value = this.value;
                    break;
                }
                case Int: {
                    this._value = Integer.parseInt(this.value);
                    break;
                }
                case Num: {
                    this._value = new BigDecimal(this.value);
                    break;
                }
                case Date: {
                    long ms = Long.parseLong(this.value);
                    Calendar c = Calendar.getInstance();
                    c.setTimeInMillis(ms);
                    this._value = c;
                    break;
                }
                case Subtotal: {
                    this._value = "com.kingdee.bos.qing.All";
                    break;
                }
                case Null: {
                    this._value = null;
                    break;
                }
                default: {
                    throw new RuntimeException("Modify here.");
                }
            }
        }
        return this._value;
    }

    public Element toXml() {
        Element node = new Element("Item");
        XmlUtil.writeAttrNotNull((Element)node, (String)"dataType", (String)this.dataType.toPersistance());
        node.setText(this.value);
        return node;
    }

    public void fromXml(Element node) throws PersistentModelParseException {
        String dt;
        try {
            dt = XmlUtil.readAttrNotNull((Element)node, (String)"dataType");
        }
        catch (XmlUtil.NullException ex) {
            throw new PersistentModelParseException(ex);
        }
        this.dataType = DataType.fromPersistance(dt);
        this.value = node.getText();
    }

    public static enum DataType {
        Null,
        Subtotal,
        Str,
        Int,
        Num,
        Date;


        public String toPersistance() {
            return this.name();
        }

        public static DataType fromPersistance(String name) throws PersistentModelParseException {
            try {
                return DataType.valueOf(name);
            }
            catch (Exception ex) {
                throw new PersistentModelParseException("Unknown ExecutableValue.DataType: " + name);
            }
        }
    }
}

