/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.square;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.RollFieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.SquareChartType;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.AbstractChartProperty;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class AbstractChart {
    private SquareChartType chartType;
    private RollFieldSet roll;
    private AbstractChartProperty chartProperty;

    public AbstractChart(SquareChartType chartType) {
        this.chartType = chartType;
    }

    public final SquareChartType getChartType() {
        return this.chartType;
    }

    public final RollFieldSet getRoll() {
        return this.roll;
    }

    public final AbstractChartProperty getChartProperty() {
        return this.chartProperty;
    }

    public final void setChartProperty(AbstractChartProperty chartProperty) {
        this.chartProperty = chartProperty;
    }

    protected abstract AbstractChartProperty createChartPropertyInstance();

    protected boolean isRollSupported() {
        return false;
    }

    protected OutsideReference getOutsideReference() {
        return null;
    }

    public final void toXml(Element node) {
        if (this.chartProperty != null) {
            Element nodeChartProperty = new Element("Property");
            this.chartProperty.toXml(nodeChartProperty);
            node.addContent((Content)nodeChartProperty);
        }
        if (this.isRollSupported() && this.roll != null) {
            Element nodeRoll = new Element("Roll");
            this.roll.toXml(nodeRoll);
            node.addContent((Content)nodeRoll);
        }
        this.toXmlImpl(node);
    }

    public final void fromXml(Element node) throws PersistentModelParseException {
        this.chartProperty = this.createChartPropertyInstance();
        Element nodeChartProperty = XmlUtil.getChild((Element)node, (String)"Property");
        if (nodeChartProperty != null) {
            this.chartProperty.fromXml(nodeChartProperty);
        }
        Element nodeRoll = XmlUtil.getChild((Element)node, (String)"Roll");
        if (this.isRollSupported() && nodeRoll != null) {
            this.roll = new RollFieldSet();
            this.roll.fromXml(nodeRoll);
        }
        this.fromXmlImpl(node);
    }

    protected abstract void toXmlImpl(Element var1);

    protected abstract void fromXmlImpl(Element var1) throws PersistentModelParseException;

    public final AbstractChart copy() {
        AbstractChart inst = this.copyImpl();
        inst.roll = this.roll == null ? null : this.roll.copy();
        inst.chartProperty = this.chartProperty;
        return inst;
    }

    protected abstract AbstractChart copyImpl();

    public final List<AnalyticalField> searchAllDimensions() {
        ArrayList<AnalyticalField> collector = new ArrayList<AnalyticalField>();
        AbstractFieldVisitor visitor = AbstractChart.createDimensionSearcher(collector, Integer.MAX_VALUE);
        this.visitAllFields(visitor);
        return collector;
    }

    public final List<AnalyticalField> searchAllMeasures() {
        ArrayList<AnalyticalField> collector = new ArrayList<AnalyticalField>();
        AbstractFieldVisitor visitor = AbstractChart.createMeasureSearcher(collector, Integer.MAX_VALUE);
        this.visitAllFields(visitor);
        return collector;
    }

    public abstract void visitAllFields(AbstractFieldVisitor var1);

    public void visitEachField(AbstractFieldVisitor visitor) {
        boolean isBreak = false;
        if (this.roll != null) {
            for (int i = 0; i < this.roll.getFieldCount() && !(isBreak = visitor.visit(this.roll.getField(i))); ++i) {
            }
        }
        if (!isBreak) {
            this.visitAllFields(visitor);
        }
    }

    public static AbstractFieldVisitor createDimensionSearcher(final List<AnalyticalField> collector, final int limitedLength) {
        AbstractFieldVisitor visitor = new AbstractFieldVisitor(){

            @Override
            public boolean visit(AnalyticalField field) {
                boolean isBreak = false;
                if (AbstractChart.isValidDimensionField(field)) {
                    collector.add(field);
                    isBreak = collector.size() >= limitedLength;
                }
                return isBreak;
            }
        };
        return visitor;
    }

    public static AbstractFieldVisitor createMeasureSearcher(final List<AnalyticalField> collector, final int limitedLength) {
        AbstractFieldVisitor visitor = new AbstractFieldVisitor(){

            @Override
            public boolean visit(AnalyticalField field) {
                boolean isBreak = false;
                if (AbstractChart.isValidkMeasureField(field)) {
                    collector.add(field);
                    isBreak = collector.size() >= limitedLength;
                }
                return isBreak;
            }
        };
        return visitor;
    }

    public static AbstractFieldVisitor createDimensionOrMeasureSearcher(final List<AnalyticalField> collector, final int limitedLength) {
        AbstractFieldVisitor visitor = new AbstractFieldVisitor(){

            @Override
            public boolean visit(AnalyticalField field) {
                boolean isBreak = false;
                if (AbstractChart.isValidDimensionField(field) || AbstractChart.isValidkMeasureField(field)) {
                    collector.add(field);
                    isBreak = collector.size() >= limitedLength;
                }
                return isBreak;
            }
        };
        return visitor;
    }

    private static boolean isValidDimensionField(AnalyticalField field) {
        if (!field.isDimension()) {
            return false;
        }
        MetaField mf = field.getMetaField();
        if (mf.isCalculation()) {
            if (!mf.isValidCalculation()) {
                return false;
            }
            if (MetaField.FormulaAggStatus.isRelativeAggregation(mf.getFormulaAggStatus())) {
                return false;
            }
        }
        return true;
    }

    private static boolean isValidkMeasureField(AnalyticalField field) {
        if (!field.isMeasure()) {
            return false;
        }
        MetaField mf = field.getMetaField();
        return !mf.isCalculation() || mf.isValidCalculation();
    }

    public static class JsonDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractChart> {
        protected AbstractChart decode(JsonUtil.AbstractJsonDecoder.Json json) {
            String name = json.getAttrValue("chartType");
            SquareChartType chartType = SquareChartType.valueOf(name);
            return (AbstractChart)this.fromJson(json, chartType.getChartClass());
        }
    }

    public static abstract class AbstractFieldVisitor {
        public abstract boolean visit(AnalyticalField var1);

        public final void visit(FieldSet fieldSet) {
            if (fieldSet != null) {
                boolean isBreak;
                int c = fieldSet.getFieldCount();
                for (int i = 0; i < c && !(isBreak = this.visit(fieldSet.getField(i))); ++i) {
                }
            }
        }
    }
}

