/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.square;

import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.ParentChildDimensionMember;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.flattening.common.ExecutableValueCoder;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.ExecutableValue;
import com.kingdee.bos.qing.core.model.analysis.square.AbstractFieldSet;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class RollFieldSet
extends AbstractFieldSet {
    private List<RollInStateItem> state;

    public int getStateItemCount() {
        int count = 0;
        if (this.state != null) {
            for (RollInStateItem stateItem : this.state) {
                if (stateItem == null) break;
                ++count;
            }
        }
        return count;
    }

    public RollInStateItem getStateItem(int idx) {
        if (this.state != null && idx < this.state.size()) {
            return this.state.get(idx);
        }
        return null;
    }

    public void clearAllState() {
        this.state = null;
    }

    @Override
    public void toXml(Element node) {
        int c = Math.max(this.getStateItemCount(), this.getFieldCount());
        for (int i = 0; i < c; ++i) {
            RollInStateItem stateItem;
            Element nodeItem = new Element("Item");
            if (i < this.getFieldCount()) {
                AnalyticalField field = this.getField(i);
                Element nodeField = new Element("Field");
                field.toXml(nodeField);
                nodeItem.addContent((Content)nodeField);
            }
            if ((stateItem = this.getStateItem(i)) != null) {
                stateItem.toXml(nodeItem);
            }
            node.addContent((Content)nodeItem);
        }
    }

    @Override
    public void fromXml(Element node) throws PersistentModelParseException {
        ArrayList<AnalyticalField> fieldList = new ArrayList<AnalyticalField>();
        ArrayList<RollInStateItem> stateList = new ArrayList<RollInStateItem>();
        if (node != null) {
            boolean isFieldOver = false;
            boolean isStateGoOn = true;
            List children = XmlUtil.getChildren((Element)node, (String)"Item");
            for (Element nodeChild : children) {
                Element nodeField = nodeChild.getChild("Field");
                if (nodeField == null) {
                    isFieldOver = true;
                } else {
                    if (isFieldOver) {
                        throw new PersistentModelParseException("<Item> must be with <Field>, just last one can be excepted.");
                    }
                    AnalyticalField field = new AnalyticalField();
                    field.fromXml(nodeField);
                    fieldList.add(field);
                }
                if (!isStateGoOn) continue;
                RollInStateItem state = new RollInStateItem();
                if (state.fromXml(nodeChild)) {
                    stateList.add(state);
                    continue;
                }
                isStateGoOn = false;
            }
        }
        this.setFields(fieldList);
        this.state = stateList;
    }

    public RollFieldSet copy() {
        ArrayList<AnalyticalField> fieldList = new ArrayList<AnalyticalField>();
        ArrayList<RollInStateItem> stateList = new ArrayList<RollInStateItem>();
        int c = Math.max(this.getStateItemCount(), this.getFieldCount());
        for (int i = 0; i < c; ++i) {
            RollInStateItem stateItem;
            if (i < this.getFieldCount()) {
                AnalyticalField field = this.getField(i);
                fieldList.add(field.copy());
            }
            stateList.add((stateItem = this.getStateItem(i)) == null ? null : stateItem.copy());
        }
        RollFieldSet inst = new RollFieldSet();
        inst.setFields(fieldList);
        inst.state = stateList;
        return inst;
    }

    public static class RollInStateItem {
        private List<String> values;
        private List<String> texts;
        private Boolean pcdNextLevel;
        private transient List<String> _parsed;

        public List<String> getParsedValue(AnalyticalField field, II18nContext i18nCtx) {
            if (this._parsed == null) {
                this._parsed = this.decode(field, i18nCtx);
            }
            return this._parsed;
        }

        public void toXml(Element nodeParent) {
            for (int i = 0; i < this.values.size(); ++i) {
                String value = this.values.get(i);
                String text = this.texts.get(i);
                Element nodeState = new Element("State");
                XmlUtil.writeAttrWhenExist((Element)nodeState, (String)"text", (String)text);
                Element nodeValue = new Element("Value");
                XmlUtil.addCDATA((Element)nodeValue, (String)value);
                nodeState.addContent((Content)nodeValue);
                nodeParent.addContent((Content)nodeState);
            }
            if (this.isPcdNextLevel()) {
                nodeParent.setAttribute("pcdNextLevel", "true");
            }
        }

        public boolean fromXml(Element nodeParent) throws PersistentModelParseException {
            List stateNodes = nodeParent.getChildren("State");
            if (stateNodes == null || stateNodes.size() == 0) {
                return false;
            }
            this.values = new ArrayList<String>(stateNodes.size());
            this.texts = new ArrayList<String>(stateNodes.size());
            for (int i = 0; i < stateNodes.size(); ++i) {
                Element nodeValue;
                Element nodeState = (Element)stateNodes.get(i);
                this.texts.add(XmlUtil.readAttrWhenExist((Element)nodeState, (String)"text"));
                try {
                    nodeValue = XmlUtil.getChildNotNull((Element)nodeState, (String)"Value");
                }
                catch (XmlUtil.NullException ex) {
                    throw new PersistentModelParseException(ex);
                }
                this.values.add(nodeValue.getText());
            }
            String nextLevel = nodeParent.getAttributeValue("pcdNextLevel");
            if (nextLevel != null) {
                this.pcdNextLevel = Boolean.parseBoolean(nextLevel);
            }
            this._parsed = null;
            return true;
        }

        public RollInStateItem copy() {
            RollInStateItem inst = new RollInStateItem();
            inst.values = this.values;
            inst.texts = this.texts;
            inst.pcdNextLevel = this.pcdNextLevel;
            return inst;
        }

        public boolean isPcdNextLevel() {
            return this.pcdNextLevel == null ? false : this.pcdNextLevel;
        }

        private List<String> decode(AnalyticalField field, II18nContext i18nCtx) {
            boolean isPcdNextLevel = this.isPcdNextLevel() && field.isParentChildDimension();
            String lastValue = this.values == null || this.values.size() == 0 ? null : this.values.get(this.values.size() - 1);
            List<ExecutableValue> list = ExecutableValueCoder.decodeComplexValue(lastValue);
            FilterPreparedValueGainer.GainerPeers gainerPeer = new FilterPreparedValueGainer.GainerPeers(field, i18nCtx);
            gainerPeer.setAppointedAsTree(isPcdNextLevel);
            for (ExecutableValue ev : list) {
                Object value = ev.getOriginalValue();
                if (isPcdNextLevel) {
                    value = ParentChildDimensionMember.createSearchingKey(value);
                }
                gainerPeer.gain(value);
            }
            List<String> values = gainerPeer.getAllPreparedValue();
            return values;
        }
    }
}

