/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.square;

import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.exception.BriefOutputException;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.analysis.AbstractQingModel;
import com.kingdee.bos.qing.core.model.analysis.IPreferences;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.core.model.analysis.common.brief.BriefOutputDefinition;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.square.AbstractChart;
import com.kingdee.bos.qing.core.model.analysis.square.FilterItem;
import com.kingdee.bos.qing.core.model.analysis.square.SquareChartType;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.AbstractChartProperty;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.core.model.parser.StyleScriptParser;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;

public class SquareModel
extends AbstractQingModel {
    private List<FilterItem> filters;
    private AbstractChart chart;

    @Override
    public void fixReferences(List<OutsideReference> refItems) {
        OutsideReference reference = this.chart.getOutsideReference();
        if (reference == null) {
            return;
        }
        HashMap<String, OutsideReference> searching = new HashMap<String, OutsideReference>(refItems.size());
        int c = refItems.size();
        for (int i = 0; i < c; ++i) {
            OutsideReference item = refItems.get(i);
            searching.put(item.getUid(), item);
        }
        OutsideReference ref = (OutsideReference)searching.get(reference.getUid());
        if (ref != null) {
            reference.accept(ref);
        }
    }

    @Override
    public List<OutsideReference> pickReferences() {
        ArrayList<OutsideReference> refItems = new ArrayList<OutsideReference>();
        OutsideReference reference = this.chart.getOutsideReference();
        if (reference != null && !"map20180808_china".equals(reference.getUid())) {
            refItems.add(reference);
        }
        return refItems;
    }

    public void setChartModel(AbstractChart chart) {
        this.chart = chart;
    }

    public AbstractChart getChartModel() {
        return this.chart;
    }

    public void setFilters(List<FilterItem> filters) {
        this.filters = filters;
    }

    public List<FilterItem> getFilters() {
        return this.filters;
    }

    public void parseConditionStyleExprs() {
        AbstractChartProperty property = this.chart.getChartProperty();
        List<String> scripts = property.getStyleScripts();
        StyleScriptParser.Type parserType = property.getStyleScriptParserType();
        if (scripts != null && parserType != null) {
            ArrayList<IExpr> exprs = null;
            for (int i = 0; i < scripts.size(); ++i) {
                String formula = scripts.get(i);
                IExpr expr = null;
                try {
                    expr = StyleScriptParser.parse(parserType, formula);
                }
                catch (ParserException ex) {
                    LogUtil.debug((String)"", (Throwable)ex);
                }
                if (expr == null) continue;
                if (exprs == null) {
                    exprs = new ArrayList<IExpr>();
                }
                exprs.add(expr);
            }
            property.setStyleExprs(exprs);
        }
    }

    public void parseBriefOutputExprs(II18nContext i18nCtx) throws BriefOutputException {
        List<BriefOutputDefinition> bods = this.getBriefOutputDefinitions();
        if (bods != null) {
            for (BriefOutputDefinition bod : bods) {
                SquareModel.parseBriefOutputExprs(bod, i18nCtx);
            }
        }
    }

    @Override
    public void safetyTemplate() {
        if (this.filters != null) {
            for (FilterItem item : this.filters) {
                item.getFilter().safety();
            }
        }
    }

    @Override
    public void bindPreferences(IPreferences preferences) {
    }

    @Override
    protected void fixMetaFieldBinding(Meta meta) {
        final Map<String, MetaField> metaFields = meta.createSearchingMap();
        this.chart.visitEachField(new AbstractChart.AbstractFieldVisitor(){

            @Override
            public boolean visit(AnalyticalField field) {
                field.fixMetaFieldBinding(metaFields);
                return false;
            }
        });
        if (this.filters != null) {
            for (FilterItem item : this.filters) {
                item.getField().fixMetaFieldBinding(metaFields);
            }
        }
    }

    public void fixMetaFieldBinding(AnalyticalField field) {
        Map<String, MetaField> metaFields = this.getMeta().createSearchingMap();
        field.fixMetaFieldBinding(metaFields);
    }

    public void searchMissingMetaFields(final List<String> lostMetaFields, final List<String> invalidMetaFields) {
        AbstractChart.AbstractFieldVisitor visitor = new AbstractChart.AbstractFieldVisitor(){

            @Override
            public boolean visit(AnalyticalField field) {
                MetaField mf = field.getMetaField();
                if (mf.isLost()) {
                    String displayName = mf.getFullDisplayName();
                    displayName = displayName == null || "".equals(displayName) ? mf.getFullName() : displayName;
                    lostMetaFields.add(displayName);
                } else if (mf.isInvalid()) {
                    invalidMetaFields.add(mf.getFullDisplayName());
                }
                return false;
            }
        };
        this.chart.visitEachField(visitor);
        if (this.filters != null) {
            for (int i = 0; i < this.filters.size(); ++i) {
                AnalyticalField field = this.filters.get(i).getField();
                visitor.visit(field);
            }
        }
    }

    @Override
    public Set<String> lookupUsedMetaFields() {
        Set<String> fieldsInsideProperty;
        final HashSet<String> fields = new HashSet<String>();
        AbstractChart.AbstractFieldVisitor visitor = new AbstractChart.AbstractFieldVisitor(){

            @Override
            public boolean visit(AnalyticalField field) {
                MetaField mf = field.getMetaField();
                if (mf.isCalculation()) {
                    Set<String> dependence = mf.getAllDependence();
                    if (dependence != null) {
                        fields.addAll(dependence);
                    }
                } else {
                    fields.add(mf.getFullName());
                }
                return false;
            }
        };
        this.chart.visitEachField(visitor);
        if (this.filters != null) {
            for (int i = 0; i < this.filters.size(); ++i) {
                AnalyticalField field = this.filters.get(i).getField();
                visitor.visit(field);
            }
        }
        if ((fieldsInsideProperty = this.chart.getChartProperty().searchUsedMetaFields()) != null) {
            fields.addAll(fieldsInsideProperty);
        }
        return fields;
    }

    @Override
    public void visitFilters(AbstractQingModel.IFilterVisitor visitor) {
        if (this.filters != null) {
            for (FilterItem filterItem : this.filters) {
                AnalyticalField field = filterItem.getField();
                AbstractAnalyticalFilter filter = filterItem.getFilter();
                visitor.visit(field, filter);
            }
        }
    }

    @Override
    public void toXml(Element node) {
        this.sharedToXml(node);
        if (this.filters != null) {
            Element nodeFilters = new Element("Filters");
            node.addContent((Content)nodeFilters);
            for (FilterItem item : this.filters) {
                Element nodeFilter = new Element("Item");
                item.toXml(nodeFilter);
                nodeFilters.addContent((Content)nodeFilter);
            }
        }
        Element nodeChart = new Element("Chart");
        this.chart.toXml(nodeChart);
        XmlUtil.writeAttrNotNull((Element)nodeChart, (String)"type", (String)this.chart.getChartType().toPersistance());
        node.addContent((Content)nodeChart);
    }

    @Override
    public void fromXml(Element node) throws PersistentModelParseException {
        String type;
        Element nodeChart;
        this.sharedFromXml(node);
        Element nodeFilters = XmlUtil.getChild((Element)node, (String)"Filters");
        if (nodeFilters != null) {
            List itemNodes = XmlUtil.getChildren((Element)nodeFilters, (String)"Item");
            this.filters = new ArrayList<FilterItem>(itemNodes.size());
            for (Element nodeItem : itemNodes) {
                FilterItem item = new FilterItem();
                item.fromXml(nodeItem);
                this.filters.add(item);
            }
        }
        try {
            nodeChart = XmlUtil.getChildNotNull((Element)node, (String)"Chart");
            type = XmlUtil.readAttrNotNull((Element)nodeChart, (String)"type");
        }
        catch (XmlUtil.NullException ex) {
            throw new PersistentModelParseException(ex);
        }
        SquareChartType chartType = SquareChartType.fromPersistance(type);
        Class<? extends AbstractChart> clazz = chartType.getChartClass();
        try {
            this.chart = clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw new PersistentModelParseException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new PersistentModelParseException(ex);
        }
        this.chart.fromXml(nodeChart);
    }

    public SquareModel copy() {
        SquareModel inst = new SquareModel();
        this.sharedCopy(inst);
        inst.chart = this.chart.copy();
        inst.filters = new ArrayList<FilterItem>();
        if (this.filters != null) {
            for (FilterItem item : this.filters) {
                inst.filters.add(item.copy());
            }
        }
        return inst;
    }

    public boolean isContainsCubeInterlineCalculation() {
        final HashSet isFound = new HashSet();
        this.chart.visitAllFields(new AbstractChart.AbstractFieldVisitor(){

            @Override
            public boolean visit(AnalyticalField field) {
                if (field.getMetaField().isCubeInterlineCalculation()) {
                    isFound.add(true);
                    return true;
                }
                return false;
            }
        });
        return !isFound.isEmpty();
    }

    public Set<AnalyticalField> getCubeInterlineDimensions(final AnalyticalField filterField) {
        final HashSet<AnalyticalField> collector = new HashSet<AnalyticalField>();
        this.chart.visitAllFields(new AbstractChart.AbstractFieldVisitor(){

            @Override
            public boolean visit(AnalyticalField field) {
                if (field.isDimension() && field.getMetaField() == filterField.getMetaField() && (field.getDataType() == DataType.DATE && field.getPartValue() == filterField.getPartValue() || field.getMetaField().getCustomPeriod() != null)) {
                    collector.add(field);
                }
                return false;
            }
        });
        return collector;
    }
}

