/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.square.chart.property;

import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.CustomPalette;
import com.kingdee.bos.qing.core.model.analysis.common.linkage.LinkTargets;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.CompositeChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.CustomListChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.DialChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.FunnelChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.GridChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.KpiChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.LineChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.MapChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.MapGisChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.PieChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.ProgressBarProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.ProgressCircleProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.ProgressColumnProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.RadarChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.RectTreeChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.RingChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.RoseChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.ScatterChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.SunburstChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.WaterfallChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.XSYNChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.YSXNChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.sub.Sort;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.core.model.parser.StyleScriptParser;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class AbstractChartProperty {
    private static Map<String, Class<? extends AbstractChartProperty>> REGISTER = new HashMap<String, Class<? extends AbstractChartProperty>>();
    private String type;
    private String title;
    private Boolean showLabel;
    private Boolean labelOverlappable;
    private String labelFormat;
    private ShowLegend showLegend;
    private ShowDataEmptyTips showDataEmptyTips;
    private String description;
    private LinkTargets linkTargets;
    private List<String> styleScripts;
    private CustomPalette palette;
    private transient List<IExpr> _styleExprs;

    public final void setTitle(String title) {
        this.title = title;
    }

    public final String getTitle() {
        return this.title;
    }

    public final void setShowLabel(boolean isShowLabel) {
        this.showLabel = isShowLabel ? Boolean.TRUE : null;
    }

    public final boolean isShowLabel() {
        return this.showLabel != null ? this.showLabel : false;
    }

    public final void setLabelOverlappable(boolean labelOverlappable) {
        this.labelOverlappable = labelOverlappable;
    }

    public final boolean isLabelOverlappable() {
        return this.labelOverlappable != null && this.labelOverlappable != false;
    }

    public final void setShowLegend(ShowLegend showLegend) {
        this.showLegend = showLegend;
    }

    public final ShowLegend getShowLegend() {
        return this.showLegend;
    }

    public final void setShowDataEmptyTips(ShowDataEmptyTips showDataEmptyTips) {
        this.showDataEmptyTips = showDataEmptyTips;
    }

    public final ShowDataEmptyTips getShowDataEmptyTips() {
        return this.showDataEmptyTips;
    }

    public final boolean isShowDataEmptyTips() {
        if (this.showDataEmptyTips == ShowDataEmptyTips.YES) {
            return true;
        }
        if (this.showDataEmptyTips == ShowDataEmptyTips.NO) {
            return false;
        }
        return this.isShowDataEmptyTipsByDefault();
    }

    protected boolean isShowDataEmptyTipsByDefault() {
        return true;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final String getDescription() {
        return this.description;
    }

    public final LinkTargets getLinkage() {
        if (this.linkTargets == null) {
            this.linkTargets = new LinkTargets();
        }
        return this.linkTargets;
    }

    public final boolean hasLinkageTarget() {
        return this.linkTargets != null && this.linkTargets.getItemsCount() > 0;
    }

    public final List<String> getStyleScripts() {
        return this.styleScripts;
    }

    public StyleScriptParser.Type getStyleScriptParserType() {
        return null;
    }

    public final void setStyleExprs(List<IExpr> exprs) {
        this._styleExprs = exprs;
    }

    public final List<IExpr> getStyleExprs() {
        return this._styleExprs;
    }

    public final CustomPalette getCustomPalette() {
        return this.palette;
    }

    public final void setCustomPalette(CustomPalette palette) {
        this.palette = palette;
    }

    public final String getLabelFormat() {
        return this.labelFormat;
    }

    public final Set<String> searchUsedMetaFields() {
        final HashSet<String> fields = new HashSet<String>();
        if (this instanceof IAdditionalMeasureProvider) {
            ((IAdditionalMeasureProvider)((Object)this)).confirmAdditionalMeasure(null, new IAdditionalMeasureProvider.IMetaFieldSearcher(){

                @Override
                public MetaField search(String fullName) {
                    fields.add(fullName);
                    return null;
                }
            });
        }
        if (this.linkTargets != null) {
            int c = this.linkTargets.getItemsCount();
            for (int i = 0; i < c; ++i) {
                LinkTargets.LinkTargetItem item = this.linkTargets.getItem(i);
                String field = item.getForeignKey();
                if (field == null) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public final void toXml(Element node) {
        this.toXmlBase(node);
        this.toXmlMore(node);
    }

    private void toXmlBase(Element node) {
        XmlUtil.writeAttrWhenExist((Element)node, (String)"title", (String)this.title);
        if (this.description != null) {
            String encoded = this.description.replaceAll("\r", "\u2506").replaceAll("\n", "\u2507");
            XmlUtil.writeAttrWhenExist((Element)node, (String)"description", (String)encoded);
        }
        XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"showLabel", (Boolean)this.showLabel);
        XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"labelOverlappable", (Boolean)this.labelOverlappable);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"labelFormat", (String)this.labelFormat);
        if (this.showLegend != null) {
            XmlUtil.writeAttrWhenExist((Element)node, (String)"showLegend", (String)this.showLegend.toPersistance());
        }
        if (this.showDataEmptyTips != null && this.showDataEmptyTips != ShowDataEmptyTips.AUTO) {
            XmlUtil.writeAttrWhenExist((Element)node, (String)"showDataEmptyTips", (String)this.showDataEmptyTips.toPersistance());
        }
        if (this.linkTargets != null) {
            Element nodeLinkage = new Element("Linkage");
            this.linkTargets.toXml(nodeLinkage);
            node.addContent((Content)nodeLinkage);
        }
        if (this.styleScripts != null) {
            Element nodeScripts = new Element("StyleScript");
            for (int i = 0; i < this.styleScripts.size(); ++i) {
                String script = this.styleScripts.get(i);
                Element nodeItem = new Element("Item");
                XmlUtil.addCDATA((Element)nodeItem, (String)script);
                nodeScripts.addContent((Content)nodeItem);
            }
            node.addContent((Content)nodeScripts);
        }
        if (this.palette != null) {
            Element nodePalette = new Element("Palette");
            this.palette.toXml(nodePalette);
            node.addContent((Content)nodePalette);
        }
    }

    public final void fromXml(Element node) throws PersistentModelParseException {
        this.fromXmlBase(node);
        this.fromXmlMore(node);
    }

    protected final void fromXmlBase(Element node) throws PersistentModelParseException {
        Element nodePalette;
        Element nodeScripts;
        this.title = XmlUtil.readAttrWhenExist((Element)node, (String)"title");
        this.description = XmlUtil.readAttrWhenExist((Element)node, (String)"description");
        if (this.description != null) {
            this.description = this.description.replaceAll("\u2506", "\r").replaceAll("\u2507", "\n");
        }
        this.showLabel = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"showLabel");
        this.labelOverlappable = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"labelOverlappable");
        this.labelFormat = XmlUtil.readAttrWhenExist((Element)node, (String)"labelFormat");
        String legend = XmlUtil.readAttrWhenExist((Element)node, (String)"showLegend");
        this.showLegend = legend == null ? null : ShowLegend.fromPersistance(legend);
        String showTips = XmlUtil.readAttrWhenExist((Element)node, (String)"showDataEmptyTips");
        this.showDataEmptyTips = showTips == null ? ShowDataEmptyTips.AUTO : ShowDataEmptyTips.fromPersistance(showTips);
        Element nodeLinkage = node.getChild("Linkage");
        if (nodeLinkage != null) {
            this.getLinkage().fromXml(nodeLinkage);
        }
        if ((nodeScripts = node.getChild("StyleScript")) != null) {
            List itemNodes = XmlUtil.getChildren((Element)nodeScripts, (String)"Item");
            for (int i = 0; i < itemNodes.size(); ++i) {
                Element nodeItem = (Element)itemNodes.get(i);
                String script = nodeItem.getTextTrim();
                if (this.styleScripts == null) {
                    this.styleScripts = new ArrayList<String>();
                }
                this.styleScripts.add(script);
            }
        }
        if ((nodePalette = node.getChild("Palette")) != null) {
            this.palette = new CustomPalette();
            this.palette.fromXml(nodePalette);
        }
    }

    protected abstract void toXmlMore(Element var1);

    protected abstract void fromXmlMore(Element var1) throws PersistentModelParseException;

    protected static void confirmAdditionalMeasure(List<AnalyticalField> measures, IAdditionalMeasureProvider.IMetaFieldSearcher metaFieldSearcher, Sort sort) {
        MetaField metaField;
        Sort.SortAccording according = sort.getSortAccording();
        if (according != null && according.getMetaFieldFullName() != null && according.getAggregation() != null && (metaField = metaFieldSearcher.search(according.getMetaFieldFullName())) != null) {
            int measureIndex = AbstractChartProperty.confirmAdditionalMeasure(measures, metaField, according.getAggregation());
            according.setRuntimeMeasureIndex(measureIndex);
        }
    }

    protected static int confirmAdditionalMeasure(List<AnalyticalField> measures, MetaField metaField, Aggregation aggregation) {
        int existIndex = -1;
        for (int i = 0; i < measures.size(); ++i) {
            AnalyticalField field = measures.get(i);
            if (aggregation != field.getAggregation() || !metaField.getFullName().equals(field.getMetaField().getFullName())) continue;
            existIndex = i;
            break;
        }
        if (existIndex == -1) {
            existIndex = measures.size();
            AnalyticalField field = new AnalyticalField();
            field.bindMetaField(metaField);
            field.setName(metaField.getFullName());
            field.setRole("measure");
            field.setAggregation(aggregation);
            field.setContinuous(true);
            measures.add(field);
        }
        return existIndex;
    }

    static {
        REGISTER.put("XSYN", XSYNChartProperty.class);
        REGISTER.put("YSXN", YSXNChartProperty.class);
        REGISTER.put("Line", LineChartProperty.class);
        REGISTER.put("Pie", PieChartProperty.class);
        REGISTER.put("Ring", RingChartProperty.class);
        REGISTER.put("Rose", RoseChartProperty.class);
        REGISTER.put("KPI", KpiChartProperty.class);
        REGISTER.put("Map", MapChartProperty.class);
        REGISTER.put("GIS", MapGisChartProperty.class);
        REGISTER.put("Radar", RadarChartProperty.class);
        REGISTER.put("ProgressBar", ProgressBarProperty.class);
        REGISTER.put("ProgressColumn", ProgressColumnProperty.class);
        REGISTER.put("ProgressCircle", ProgressCircleProperty.class);
        REGISTER.put("Composite", CompositeChartProperty.class);
        REGISTER.put("Grid", GridChartProperty.class);
        REGISTER.put("CustomList", CustomListChartProperty.class);
        REGISTER.put("Waterfall", WaterfallChartProperty.class);
        REGISTER.put("Funnel", FunnelChartProperty.class);
        REGISTER.put("Scatter", ScatterChartProperty.class);
        REGISTER.put("Dial", DialChartProperty.class);
        REGISTER.put("RectTree", RectTreeChartProperty.class);
        REGISTER.put("Sunburst", SunburstChartProperty.class);
    }

    public static interface IAdditionalMeasureProvider {
        public void confirmAdditionalMeasure(List<AnalyticalField> var1, IMetaFieldSearcher var2);

        public static interface IMetaFieldSearcher {
            public MetaField search(String var1);
        }
    }

    public static enum ShowDataEmptyTips {
        AUTO,
        YES,
        NO;


        public String toPersistance() {
            return this.name();
        }

        public static ShowDataEmptyTips fromPersistance(String name) throws PersistentModelParseException {
            try {
                return ShowDataEmptyTips.valueOf(name);
            }
            catch (Exception ex) {
                return AUTO;
            }
        }
    }

    public static enum RulerStart {
        ZERO,
        NONZERO;


        public String toPersistance() {
            return this.name();
        }

        public static RulerStart fromPersistance(String name) throws PersistentModelParseException {
            try {
                return RulerStart.valueOf(name);
            }
            catch (Exception ex) {
                return ZERO;
            }
        }
    }

    public static enum RulerScale {
        AUTO,
        LINEAR,
        LOG;


        public String toPersistance() {
            return this.name();
        }

        public static RulerScale fromPersistance(String name) throws PersistentModelParseException {
            try {
                return RulerScale.valueOf(name);
            }
            catch (Exception ex) {
                return AUTO;
            }
        }
    }

    public static enum ShowLegend {
        NON,
        RIGHT,
        BOTTOM;


        public String toPersistance() {
            return this.name();
        }

        public static ShowLegend fromPersistance(String name) throws PersistentModelParseException {
            try {
                return ShowLegend.valueOf(name);
            }
            catch (Exception ex) {
                return NON;
            }
        }
    }

    public static class JsonDecoder
    extends JsonUtil.AbstractJsonDecoder<AbstractChartProperty> {
        protected AbstractChartProperty decode(JsonUtil.AbstractJsonDecoder.Json json) {
            String type = json.getAttrValue("type");
            Class clazz = (Class)REGISTER.get(type);
            if (clazz == null) {
                throw new RuntimeException("Unknown ChartConfig type: " + type);
            }
            return (AbstractChartProperty)this.fromJson(json, clazz);
        }
    }
}

