/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.square.chart.property;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.AbstractListChartProperty;
import com.kingdee.bos.qing.core.model.parser.StyleScriptParser;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class CustomListChartProperty
extends AbstractListChartProperty {
    private int width;
    private ContentPanel head;
    private ContentPanel content;
    private ContentPanel tail;
    private String splitLineColor;
    private String bodyVAlign;

    public ContentPanel getHeadPanel() {
        return this.head;
    }

    public ContentPanel getContentPanel() {
        return this.content;
    }

    public ContentPanel getTailPanel() {
        return this.tail;
    }

    public Map<String, Object> toRenderAttr() {
        HashMap<String, Object> attr = new HashMap<String, Object>();
        attr.put("bodyMiddleAlign", "middle".equals(this.bodyVAlign));
        attr.put("splitLineColor", this.splitLineColor);
        attr.put("designingWidth", this.width);
        attr.put("content", this.contentPanelToRenderAttr(this.content));
        attr.put("head", this.head == null ? null : this.contentPanelToRenderAttr(this.head));
        attr.put("tail", this.tail == null ? null : this.contentPanelToRenderAttr(this.tail));
        return attr;
    }

    private Map<String, Object> contentPanelToRenderAttr(ContentPanel cp) {
        ArrayList attrAreas = new ArrayList();
        for (ContentArea area : cp.getAreas()) {
            HashMap<String, Integer> attrArea = new HashMap<String, Integer>();
            attrArea.put("x", area.getX());
            attrArea.put("y", area.getY());
            attrArea.put("width", area.getWidth());
            attrArea.put("height", area.getHeight());
            attrAreas.add(attrArea);
        }
        HashMap<String, Object> attrPanel = new HashMap<String, Object>();
        attrPanel.put("rowHeight", cp.getRowHeight());
        attrPanel.put("backgroundColor", cp.getBackgroundColor());
        attrPanel.put("areas", attrAreas);
        return attrPanel;
    }

    public void visitAllContentArea(IVisitor visitor) {
        int i;
        List<ContentArea> areas;
        if (this.head != null) {
            areas = this.head.getAreas();
            for (i = 0; i < areas.size(); ++i) {
                visitor.visit(this.head, i, areas.get(i));
            }
        }
        areas = this.content.getAreas();
        for (i = 0; i < areas.size(); ++i) {
            visitor.visit(this.content, i, areas.get(i));
        }
        if (this.tail != null) {
            areas = this.tail.getAreas();
            for (i = 0; i < areas.size(); ++i) {
                visitor.visit(this.tail, i, areas.get(i));
            }
        }
    }

    @Override
    public StyleScriptParser.Type getStyleScriptParserType() {
        return StyleScriptParser.Type.Grid;
    }

    @Override
    protected void toXmlMore(Element node) {
        this.listToXml(node);
        XmlUtil.writeAttrInt((Element)node, (String)"designingWidth", (int)this.width);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"splitLineColor", (String)this.splitLineColor);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"bodyVAlign", (String)this.bodyVAlign);
        if (this.head != null) {
            Element nodeHead = new Element("Head");
            this.head.toXml(nodeHead);
            node.addContent((Content)nodeHead);
        }
        Element nodeContent = new Element("Content");
        this.content.toXml(nodeContent);
        node.addContent((Content)nodeContent);
        if (this.tail != null) {
            Element nodeTail = new Element("Tail");
            this.tail.toXml(nodeTail);
            node.addContent((Content)nodeTail);
        }
    }

    @Override
    protected void fromXmlMore(Element node) throws PersistentModelParseException {
        this.listFromXml(node);
        this.width = CustomListChartProperty.readInt(node, "designingWidth", 320);
        this.splitLineColor = XmlUtil.readAttrWhenExist((Element)node, (String)"splitLineColor");
        this.bodyVAlign = XmlUtil.readAttrWhenExist((Element)node, (String)"bodyVAlign");
        this.head = null;
        Element nodeHead = XmlUtil.getChild((Element)node, (String)"Head");
        if (nodeHead != null) {
            this.head = new ContentPanel();
            this.head.fromXml(nodeHead);
        }
        Element nodeContent = XmlUtil.getChild((Element)node, (String)"Content");
        this.content = new ContentPanel();
        this.content.fromXml(nodeContent);
        this.tail = null;
        Element nodeTail = XmlUtil.getChild((Element)node, (String)"Tail");
        if (nodeTail != null) {
            this.tail = new ContentPanel();
            this.tail.fromXml(nodeTail);
        }
    }

    private static int readInt(Element node, String attributeKey, int defaultValue) {
        try {
            return XmlUtil.readAttrInt((Element)node, (String)attributeKey);
        }
        catch (XmlUtil.NullException e) {
            return defaultValue;
        }
    }

    public static class CommonStyle {
        private Integer fontSize;
        private Boolean bold;
        private Boolean italic;
        private String color;
        private String align;

        public Integer getFontSize() {
            return this.fontSize;
        }

        public Boolean isBold() {
            return this.bold;
        }

        public Boolean isItalic() {
            return this.italic;
        }

        public String getColor() {
            return this.color;
        }

        public String getAlign() {
            return this.align;
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.fontSize != null) {
                map.put("fontSize", this.fontSize);
            }
            if (this.bold != null) {
                map.put("bold", this.bold);
            }
            if (this.color != null) {
                map.put("color", this.color);
            }
            if (this.align != null) {
                map.put("align", this.align);
            }
            return map.isEmpty() ? null : map;
        }

        public void toXml(Element node) {
            XmlUtil.writeAttrIntWhenExist((Element)node, (String)"fontSize", (Integer)this.fontSize);
            XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"bold", (Boolean)this.bold);
            XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"italic", (Boolean)this.italic);
            XmlUtil.writeAttrWhenExist((Element)node, (String)"color", (String)this.color);
            XmlUtil.writeAttrWhenExist((Element)node, (String)"align", (String)this.align);
        }

        public void fromXml(Element node) {
            this.fontSize = XmlUtil.readAttrIntWhenExist((Element)node, (String)"fontSize");
            this.bold = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"bold");
            this.italic = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"italic");
            this.color = XmlUtil.readAttrWhenExist((Element)node, (String)"color");
            this.align = XmlUtil.readAttrWhenExist((Element)node, (String)"align");
        }
    }

    public static class ColorBar {
        private String min;
        private String max;
        private String color;
        private String negativeColor;
        private String axisColor;

        public String getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        public String getNormalColor() {
            return this.color;
        }

        public String getNegativeColor() {
            return this.negativeColor;
        }

        public String getAxisColor() {
            return this.axisColor;
        }

        public void toXml(Element node) {
            XmlUtil.writeAttrWhenExist((Element)node, (String)"min", (String)this.min);
            XmlUtil.writeAttrWhenExist((Element)node, (String)"max", (String)this.max);
            XmlUtil.writeAttrWhenExist((Element)node, (String)"color", (String)this.color);
            XmlUtil.writeAttrWhenExist((Element)node, (String)"negativeColor", (String)this.negativeColor);
            XmlUtil.writeAttrWhenExist((Element)node, (String)"axisColor", (String)this.axisColor);
        }

        public void fromXml(Element node) {
            this.min = XmlUtil.readAttrWhenExist((Element)node, (String)"min");
            this.max = XmlUtil.readAttrWhenExist((Element)node, (String)"max");
            this.color = XmlUtil.readAttrWhenExist((Element)node, (String)"color");
            this.negativeColor = XmlUtil.readAttrWhenExist((Element)node, (String)"negativeColor");
            this.axisColor = XmlUtil.readAttrWhenExist((Element)node, (String)"axisColor");
        }
    }

    public static class ContentArea {
        private int x;
        private int y;
        private int width;
        private int height;
        private Integer field;
        private String text;
        private ColorBar colorBar;
        private CommonStyle style;
        private transient AnalyticalField _bindField;

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public Integer getBindFieldIndex() {
            return this.field;
        }

        public String getCustomText() {
            return this.text;
        }

        public ColorBar getColorBar() {
            return this.colorBar;
        }

        public CommonStyle getStyle() {
            return this.style;
        }

        public void setBoundField(AnalyticalField field) {
            this._bindField = field;
        }

        public AnalyticalField getBoundField() {
            return this._bindField;
        }

        public void toXml(Element node) {
            XmlUtil.writeAttrInt((Element)node, (String)"x", (int)this.x);
            XmlUtil.writeAttrInt((Element)node, (String)"y", (int)this.y);
            XmlUtil.writeAttrInt((Element)node, (String)"width", (int)this.width);
            XmlUtil.writeAttrInt((Element)node, (String)"height", (int)this.height);
            XmlUtil.writeAttrIntWhenExist((Element)node, (String)"bindField", (Integer)this.field);
            if (this.text != null) {
                Element nodeText = new Element("Text");
                XmlUtil.addCDATA((Element)nodeText, (String)this.text);
                node.addContent((Content)nodeText);
            }
            if (this.colorBar != null) {
                Element nodeColorBar = new Element("ColorBar");
                this.colorBar.toXml(nodeColorBar);
                node.addContent((Content)nodeColorBar);
            }
            Element nodeStyle = new Element("Style");
            this.style.toXml(nodeStyle);
            node.addContent((Content)nodeStyle);
        }

        public void fromXml(Element node) {
            this.x = CustomListChartProperty.readInt(node, "x", 0);
            this.y = CustomListChartProperty.readInt(node, "y", 0);
            this.width = CustomListChartProperty.readInt(node, "width", 80);
            this.height = CustomListChartProperty.readInt(node, "height", 20);
            this.field = XmlUtil.readAttrIntWhenExist((Element)node, (String)"bindField");
            Element nodeText = XmlUtil.getChild((Element)node, (String)"Text");
            this.text = nodeText == null ? null : nodeText.getTextTrim();
            this.colorBar = null;
            Element nodeColorBar = XmlUtil.getChild((Element)node, (String)"ColorBar");
            if (nodeColorBar != null) {
                this.colorBar = new ColorBar();
                this.colorBar.fromXml(nodeColorBar);
            }
            Element nodeStyle = XmlUtil.getChild((Element)node, (String)"Style");
            this.style = new CommonStyle();
            this.style.fromXml(nodeStyle);
        }
    }

    public static class ContentPanel {
        private int rowHeight;
        private List<ContentArea> areas;
        private String backgroundColor;

        public int getRowHeight() {
            return this.rowHeight;
        }

        public List<ContentArea> getAreas() {
            return this.areas;
        }

        public String getBackgroundColor() {
            return this.backgroundColor;
        }

        public void toXml(Element node) {
            XmlUtil.writeAttrInt((Element)node, (String)"rowHeight", (int)this.rowHeight);
            for (ContentArea area : this.areas) {
                Element nodeArea = new Element("Area");
                area.toXml(nodeArea);
                node.addContent((Content)nodeArea);
            }
            XmlUtil.writeAttrWhenExist((Element)node, (String)"backgroundColor", (String)this.backgroundColor);
        }

        public void fromXml(Element node) {
            this.rowHeight = CustomListChartProperty.readInt(node, "rowHeight", 40);
            this.areas = new ArrayList<ContentArea>();
            List areaNodes = XmlUtil.getChildren((Element)node, (String)"Area");
            for (Element nodeArea : areaNodes) {
                ContentArea area = new ContentArea();
                area.fromXml(nodeArea);
                this.areas.add(area);
            }
            this.backgroundColor = XmlUtil.readAttrWhenExist((Element)node, (String)"backgroundColor");
        }
    }

    public static interface IVisitor {
        public void visit(ContentPanel var1, int var2, ContentArea var3);
    }
}

