/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.square.chart.property;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.analysis.common.ContinuousColor;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.AbstractChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.sub.TooltipsAutoDisplay;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class MapChartProperty
extends AbstractChartProperty {
    public static final String ArchaicTemplateId = "map20180808_china";
    private OutsideReference reference;
    private RegionMapping regionMapping;
    private String legendFormat;
    private ContinuousColor continuousColor;
    private TooltipsAutoDisplay tooltipsAutoDisplay;

    public OutsideReference getOutsideReference() {
        if (this.reference == null) {
            this.reference = new OutsideReference();
        }
        this.reference.setRefType("Map");
        return this.reference;
    }

    public void setLegendFormat(String formatString) {
        this.legendFormat = formatString;
    }

    public String getLegendFormat() {
        return this.legendFormat;
    }

    public Map<String, List<String>> getRegionMapping() {
        return this.regionMapping == null ? null : this.regionMapping.getCurrentLevel();
    }

    public void setContinuousColor(ContinuousColor continuousColor) {
        this.continuousColor = continuousColor;
    }

    public ContinuousColor getContinuousColor() {
        return this.continuousColor;
    }

    @Override
    protected void toXmlMore(Element node) {
        XmlUtil.writeAttrWhenExist((Element)node, (String)"legendFormat", (String)this.legendFormat);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"templateUid", (String)this.getOutsideReference().getUid());
        if (this.regionMapping != null) {
            Element nodeMapping = new Element("Mapping");
            this.regionMapping.toXml(nodeMapping);
            node.addContent((Content)nodeMapping);
        }
        if (this.continuousColor != null) {
            Element nodeContinuousColor = new Element("ContinuousColor");
            this.continuousColor.toXml(nodeContinuousColor);
            node.addContent((Content)nodeContinuousColor);
        }
        if (this.tooltipsAutoDisplay != null) {
            Element nodeTooltipsAutoDisplay = new Element("TooltipsAutoDisplay");
            this.tooltipsAutoDisplay.toXml(nodeTooltipsAutoDisplay);
            node.addContent((Content)nodeTooltipsAutoDisplay);
        }
    }

    @Override
    protected void fromXmlMore(Element node) throws PersistentModelParseException {
        this.legendFormat = XmlUtil.readAttrWhenExist((Element)node, (String)"legendFormat");
        this.getOutsideReference().setUid(XmlUtil.readAttrWhenExist((Element)node, (String)"templateUid"));
        this.fixReference(this.getOutsideReference());
        this.regionMapping = null;
        Element nodeMapping = XmlUtil.getChild((Element)node, (String)"Mapping");
        if (nodeMapping != null) {
            this.regionMapping = new RegionMapping();
            this.regionMapping.fromXml(nodeMapping);
        }
        this.continuousColor = null;
        Element nodeContinuousColor = XmlUtil.getChild((Element)node, (String)"ContinuousColor");
        if (nodeContinuousColor != null) {
            this.continuousColor = new ContinuousColor();
            this.continuousColor.fromXml(nodeContinuousColor);
        }
        this.tooltipsAutoDisplay = null;
        Element nodeTooltipsAutoDisplay = XmlUtil.getChild((Element)node, (String)"TooltipsAutoDisplay");
        if (nodeTooltipsAutoDisplay != null) {
            this.tooltipsAutoDisplay = new TooltipsAutoDisplay();
            this.tooltipsAutoDisplay.fromXml(nodeTooltipsAutoDisplay);
        }
    }

    private void fixReference(OutsideReference outsideReference) {
        if (ArchaicTemplateId.equals(outsideReference.getUid())) {
            outsideReference.setRefToId(outsideReference.getUid());
            outsideReference.setRefName("\u4e2d\u56fd\u7701\u4efd\u793a\u610f\u56fe");
        }
    }

    public static class RegionMapping {
        private Map<String, List<String>> mapping;
        private Map<String, RegionMapping> subLevels;

        public Map<String, List<String>> getCurrentLevel() {
            return this.mapping;
        }

        public RegionMapping getSubLevel(String regionName) {
            return this.subLevels.get(regionName);
        }

        public void toXml(Element node) {
            if (this.mapping != null) {
                for (Map.Entry<String, Object> entry : this.mapping.entrySet()) {
                    List regions = (List)entry.getValue();
                    for (int i = 0; i < regions.size(); ++i) {
                        String regionName = (String)regions.get(i);
                        Element nodeItem = new Element("Item");
                        nodeItem.setAttribute("data", entry.getKey());
                        nodeItem.setAttribute("region", regionName);
                        node.addContent((Content)nodeItem);
                    }
                }
            }
            if (this.subLevels != null) {
                for (Map.Entry<String, Object> entry : this.subLevels.entrySet()) {
                    RegionMapping subObj = (RegionMapping)entry.getValue();
                    Element nodeSubMapping = new Element("Mapping");
                    nodeSubMapping.setAttribute("parentRegion", entry.getKey());
                    subObj.toXml(nodeSubMapping);
                    node.addContent((Content)nodeSubMapping);
                }
            }
        }

        public void fromXml(Element node) {
            this.mapping = new HashMap<String, List<String>>();
            List itemNodes = XmlUtil.getChildren((Element)node, (String)"Item");
            for (Element nodeItem : itemNodes) {
                String dimensionMember = nodeItem.getAttributeValue("data");
                String regionName = nodeItem.getAttributeValue("region");
                List<String> regions = this.mapping.get(dimensionMember);
                if (regions == null) {
                    regions = new ArrayList<String>();
                    this.mapping.put(dimensionMember, regions);
                }
                regions.add(regionName);
            }
            List subMappingNodes = XmlUtil.getChildren((Element)node, (String)"Mapping");
            for (Element nodeSubMapping : subMappingNodes) {
                RegionMapping subMapping = new RegionMapping();
                subMapping.fromXml(nodeSubMapping);
                String parentRegion = nodeSubMapping.getAttributeValue("parentRegion");
                if (this.subLevels == null) {
                    this.subLevels = new HashMap<String, RegionMapping>();
                }
                this.subLevels.put(parentRegion, subMapping);
            }
        }
    }
}

