/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.meta;

import com.kingdee.bos.qing.common.grammar.IContextRelativedExprConfirmer;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractOpExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.grammar.expr.RefExpr;
import com.kingdee.bos.qing.common.grammar.expr.VariantExpr;
import com.kingdee.bos.qing.core.engine.func.AbstractAggregationFunction;
import com.kingdee.bos.qing.core.engine.func.AbstractInterlineFunction;
import com.kingdee.bos.qing.core.engine.func.AbstractWithTotalFunction;
import com.kingdee.bos.qing.core.exception.FormulaException;
import com.kingdee.bos.qing.core.exception.NecesaryDimensionMissingException;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.DimensionNecessity;
import com.kingdee.bos.qing.core.model.meta.Elimination;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.core.model.meta.MetaTable;
import com.kingdee.bos.qing.core.model.meta.ParentChildDimension;
import com.kingdee.bos.qing.core.model.parser.MetaFieldFormulaParser;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.NameUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;

public class Meta {
    private List<MetaTable> tables;
    private List<Elimination> eliminations;
    private Src src;
    private transient boolean _isEliminationsImportant = false;

    public Src getSrcMode() {
        return this.src;
    }

    public void setSrcMode(Src mode) {
        this.src = mode;
    }

    public List<MetaTable> getTables() {
        return this.tables;
    }

    public void setTables(List<MetaTable> tables) {
        this.tables = tables;
    }

    public List<Elimination> getEliminations() {
        return this.eliminations;
    }

    public void setEliminations(List<Elimination> eliminations) {
        this.eliminations = eliminations;
    }

    public boolean isEliminationsImportant() {
        return this._isEliminationsImportant;
    }

    public void setEliminationsImportant(boolean isImportant) {
        this._isEliminationsImportant = isImportant;
    }

    public Iterator<MetaField> createAllFieldsIterator() {
        return new Iterator<MetaField>(){
            private int _currentTableIdx = -1;
            private Iterator<MetaField> _currentImpl;

            @Override
            public boolean hasNext() {
                while (this._currentImpl == null || !this._currentImpl.hasNext()) {
                    if (this._currentTableIdx >= Meta.this.tables.size() - 1) {
                        return false;
                    }
                    ++this._currentTableIdx;
                    MetaTable mt = (MetaTable)Meta.this.tables.get(this._currentTableIdx);
                    this._currentImpl = mt.getFields().iterator();
                }
                return true;
            }

            @Override
            public MetaField next() {
                return this._currentImpl.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public Map<String, MetaField> createSearchingMap() {
        return this.createSearchingMap(false);
    }

    private Map<String, MetaField> createSearchingMap(boolean isDisplayName) {
        HashMap<String, MetaField> map = new HashMap<String, MetaField>();
        Iterator<MetaField> itFields = this.createAllFieldsIterator();
        while (itFields.hasNext()) {
            MetaField mf = itFields.next();
            if (isDisplayName) {
                map.put(mf.getFullDisplayName(), mf);
                continue;
            }
            map.put(mf.getFullName(), mf);
        }
        return map;
    }

    public Collection<String> checkNecessaryDimension(Set<MetaField> present) throws NecesaryDimensionMissingException {
        HashMap<String, String> indispensableFieldNames = null;
        Iterator<MetaField> it = this.createAllFieldsIterator();
        while (it.hasNext()) {
            MetaField mf = it.next();
            if (mf.getDimensionNecessity() != DimensionNecessity.Indispensable) continue;
            if (indispensableFieldNames == null) {
                indispensableFieldNames = new HashMap<String, String>();
            }
            indispensableFieldNames.put(mf.getFullName(), mf.getFullDisplayName());
        }
        HashMap<String, String> indispensablePcdNames = null;
        HashMap<String, String> rootRepresentedParentIdFieldNames = null;
        for (int i = 0; i < this.tables.size(); ++i) {
            MetaTable mt = this.tables.get(i);
            String tableName = mt.getName();
            List<ParentChildDimension> pcds = mt.getParentChildDimensions();
            if (pcds == null) continue;
            for (ParentChildDimension pcd : pcds) {
                String key;
                if (pcd.getDimensionNecessity() == DimensionNecessity.Indispensable) {
                    if (indispensablePcdNames == null) {
                        indispensablePcdNames = new HashMap<String, String>();
                    }
                    key = NameUtil.encodeFullName((String)tableName, (String)pcd.getName());
                    String alias = NameUtil.encodeFullName((String)mt.getDisplayName(), (String)pcd.getAlias());
                    indispensablePcdNames.put(key, alias);
                    continue;
                }
                if (pcd.getDimensionNecessity() != DimensionNecessity.RootRepresented) continue;
                if (rootRepresentedParentIdFieldNames == null) {
                    rootRepresentedParentIdFieldNames = new HashMap<String, String>();
                }
                key = NameUtil.encodeFullName((String)tableName, (String)pcd.getName());
                String fieldFullName = NameUtil.encodeFullName((String)tableName, (String)pcd.getParentIdFieldName());
                rootRepresentedParentIdFieldNames.put(key, fieldFullName);
            }
        }
        if (indispensableFieldNames == null && indispensablePcdNames == null && rootRepresentedParentIdFieldNames == null) {
            return null;
        }
        for (MetaField mf : present) {
            if (indispensableFieldNames != null) {
                indispensableFieldNames.remove(mf.getFullName());
            }
            if (mf.getGroupName() == null) continue;
            String key = NameUtil.encodeFullName((String)mf.getMetaTable().getName(), (String)mf.getGroupName());
            if (indispensablePcdNames != null) {
                indispensablePcdNames.remove(key);
            }
            if (rootRepresentedParentIdFieldNames == null) continue;
            rootRepresentedParentIdFieldNames.remove(key);
        }
        ArrayList allAlias = new ArrayList();
        if (indispensableFieldNames != null && indispensableFieldNames.size() > 0) {
            allAlias.addAll(indispensableFieldNames.values());
        }
        if (indispensablePcdNames != null && indispensablePcdNames.size() > 0) {
            allAlias.addAll(indispensablePcdNames.values());
        }
        if (allAlias.size() > 0) {
            throw new NecesaryDimensionMissingException(((Object)allAlias).toString());
        }
        if (rootRepresentedParentIdFieldNames != null && rootRepresentedParentIdFieldNames.size() > 0) {
            return rootRepresentedParentIdFieldNames.values();
        }
        return null;
    }

    public void writeXmlToParent(Element parent) {
        Element nodeMeta = new Element("Meta");
        parent.addContent((Content)nodeMeta);
        Element nodeTables = new Element("Tables");
        for (int i = 0; i < this.tables.size(); ++i) {
            MetaTable mt = this.tables.get(i);
            nodeTables.addContent((Content)mt.toXml());
        }
        nodeMeta.addContent((Content)nodeTables);
        if (this.eliminations != null && !this.eliminations.isEmpty()) {
            Element nodeDefines = new Element("Defines");
            nodeMeta.addContent((Content)nodeDefines);
            for (Elimination elimination : this.eliminations) {
                nodeDefines.addContent((Content)elimination.toXml());
            }
        }
    }

    public void readXmlFromParent(Element parent) throws PersistentModelParseException {
        Element nodeMeta;
        this.tables = new ArrayList<MetaTable>();
        try {
            nodeMeta = XmlUtil.getChildNotNull((Element)parent, (String)"Meta");
        }
        catch (XmlUtil.NullException ex) {
            throw new PersistentModelParseException(ex);
        }
        Element nodeTables = XmlUtil.getChild((Element)nodeMeta, (String)"Tables");
        if (nodeTables == null) {
            this.upgradeReadXml(nodeMeta);
        } else {
            List tableNodes = XmlUtil.getChildren((Element)nodeTables);
            for (int i = 0; i < tableNodes.size(); ++i) {
                Element nodeTable = (Element)tableNodes.get(i);
                MetaTable mt = new MetaTable();
                mt.fromXml(nodeTable);
                this.tables.add(mt);
            }
            Element nodeDefines = XmlUtil.getChild((Element)nodeMeta, (String)"Defines");
            if (nodeDefines != null && "true".equals(XmlUtil.readAttrWhenExist((Element)nodeDefines, (String)"important"))) {
                List nodeEliminations = XmlUtil.getChildren((Element)nodeDefines, (String)Elimination.getPersistentNodeName());
                if (nodeEliminations.size() > 0) {
                    this.eliminations = new ArrayList<Elimination>(nodeEliminations.size());
                    for (Element nodeElimination : nodeEliminations) {
                        Elimination elimination = new Elimination();
                        elimination.fromXml(nodeElimination);
                        this.eliminations.add(elimination);
                    }
                } else {
                    this.eliminations = null;
                }
            }
        }
        this.fixMetaFieldOwner();
        this.fixExprAndDependents();
    }

    private void upgradeReadXml(Element nodeMeta) throws PersistentModelParseException {
        MetaTable mt = new MetaTable();
        this.tables.add(mt);
        Element nodeFields = null;
        Element nodeDefines = null;
        nodeFields = XmlUtil.getChild((Element)nodeMeta, (String)"Fields");
        nodeDefines = XmlUtil.getChild((Element)nodeMeta, (String)"Defines");
        if (nodeFields != null) {
            List fieldNodes = XmlUtil.getChildren((Element)nodeFields);
            ArrayList<MetaField> mfs = new ArrayList<MetaField>(fieldNodes.size());
            for (Element nodeFiled : fieldNodes) {
                MetaField mf = new MetaField();
                mf.fromXml(nodeFiled);
                mfs.add(mf);
            }
            mt.setFields(mfs);
        }
        if (nodeDefines != null) {
            List nodePcds = XmlUtil.getChildren((Element)nodeDefines, (String)ParentChildDimension.getPersistentNodeName());
            if (nodePcds.size() > 0) {
                ArrayList<ParentChildDimension> pcds = new ArrayList<ParentChildDimension>(nodePcds.size());
                for (Element nodePcd : nodePcds) {
                    ParentChildDimension pcd = new ParentChildDimension();
                    pcd.fromXml(nodePcd);
                    pcds.add(pcd);
                }
                mt.setParentChildDimensions(pcds);
            } else {
                mt.setParentChildDimensions(null);
            }
            List nodeEliminations = XmlUtil.getChildren((Element)nodeDefines, (String)Elimination.getPersistentNodeName());
            if (nodeEliminations.size() > 0 && "true".equals(XmlUtil.readAttrWhenExist((Element)nodeDefines, (String)"important"))) {
                this.eliminations = new ArrayList<Elimination>(nodeEliminations.size());
                for (Element nodeElimination : nodeEliminations) {
                    Elimination elimination = new Elimination();
                    elimination.fromXml(nodeElimination);
                    this.eliminations.add(elimination);
                }
            } else {
                this.eliminations = null;
            }
        }
    }

    public void fixMetaFieldOwner() {
        for (int i = 0; i < this.tables.size(); ++i) {
            this.tables.get(i).fixMetaFieldOwner();
        }
    }

    public void fixExprAndDependents() {
        this.fixExprAndDependents(new FormulaParsingExceptionHandlerImpl());
    }

    public void checkEditingFormula(IFormulaParsingExceptionHandler exHandler) {
        this.fixExprAndDependents(exHandler);
    }

    private void fixExprAndDependents(IFormulaParsingExceptionHandler exHandler) {
        MetaField mf;
        Map<String, MetaField> metaFields = this.createSearchingMap();
        ContextRelativedExprConfirmer refConfirmer = new ContextRelativedExprConfirmer(metaFields);
        Iterator<MetaField> it = this.createAllFieldsIterator();
        while (it.hasNext()) {
            IExpr expr;
            String formula;
            mf = it.next();
            if (!mf.isCalculation() || (formula = mf.getFormula().trim()).isEmpty()) continue;
            try {
                expr = MetaFieldFormulaParser.parse(formula, refConfirmer);
            }
            catch (ParserException ex) {
                if (!exHandler.forParsing(mf, ex)) continue;
                return;
            }
            mf.setExpr(expr);
            mf.setDataType(Meta.confirmMetaFieldDataType(expr));
        }
        it = this.createAllFieldsIterator();
        while (it.hasNext()) {
            mf = it.next();
            if (!mf.isValidCalculation()) continue;
            IExpr expr = mf.getExpr();
            ArrayList<String> refQueue = new ArrayList<String>();
            refQueue.add(mf.getFullName());
            try {
                Meta.checkCycleReference(expr, metaFields, refQueue);
                mf.setFormulaAggStatus(Meta.confirmFormulaAggStatus(expr, metaFields));
                Meta.checkNestedAggregation(expr, metaFields, null);
            }
            catch (FormulaException ex) {
                if (!exHandler.forChecking(mf, ex)) continue;
                return;
            }
            HashSet<String> dependence = new HashSet<String>();
            Meta.collectDependence(expr, metaFields, dependence);
            mf.setAllDependence(dependence);
        }
    }

    public static MetaField.FormulaAggStatus checkingWrapper(IExpr root, Map<String, MetaField> metaFields, Set<String> dependenceCollector, List<String> refQueue) throws FormulaException.CycleReferenceException, FormulaException.FieldNotFoundException, FormulaException.InvalidReferenceException, FormulaException.MixedException {
        Meta.checkCycleReference(root, metaFields, refQueue);
        MetaField.FormulaAggStatus aggStatus = Meta.confirmFormulaAggStatus(root, metaFields);
        Meta.checkNestedAggregation(root, metaFields, null);
        Meta.collectDependence(root, metaFields, dependenceCollector);
        return aggStatus;
    }

    private static void checkCycleReference(IExpr root, Map<String, MetaField> metaFields, List<String> refQueue) throws FormulaException.CycleReferenceException, FormulaException.FieldNotFoundException, FormulaException.InvalidReferenceException {
        ArrayList<IExpr> queue = new ArrayList<IExpr>();
        queue.add(root);
        while (!queue.isEmpty()) {
            IExpr[] subs;
            IExpr node = (IExpr)queue.remove(0);
            if (node instanceof RefExpr) {
                String fieldName = ((RefExpr)node).getName();
                if (refQueue.contains(fieldName)) {
                    throw new FormulaException.CycleReferenceException(fieldName, node.getCharIndexAtFormula());
                }
                MetaField mf = metaFields.get(fieldName);
                if (mf == null) {
                    throw new FormulaException.FieldNotFoundException(fieldName, node.getCharIndexAtFormula());
                }
                if (mf.isInvalid()) {
                    throw new FormulaException.InvalidReferenceException(fieldName, node.getCharIndexAtFormula());
                }
                IExpr expr = mf.getExpr();
                if (expr == null) continue;
                refQueue.add(fieldName);
                try {
                    Meta.checkCycleReference(mf.getExpr(), metaFields, refQueue);
                }
                catch (FormulaException.CycleReferenceException ex) {
                    mf.setInvalid(true);
                    throw new FormulaException.CycleReferenceException(fieldName, node.getCharIndexAtFormula());
                }
                catch (FormulaException.FieldNotFoundException ex) {
                    mf.setInvalid(true);
                    throw new FormulaException.InvalidReferenceException(fieldName, node.getCharIndexAtFormula());
                }
                refQueue.remove(refQueue.size() - 1);
                continue;
            }
            if (!(node instanceof AbstractOpExpr)) continue;
            for (IExpr sub : subs = ((AbstractOpExpr)node).getSubExprs()) {
                queue.add(sub);
            }
        }
    }

    private static MetaField.FormulaAggStatus confirmFormulaAggStatus(IExpr root, Map<String, MetaField> metaFields) throws FormulaException.MixedException {
        MetaField.FormulaAggStatus mergedStatus = null;
        LinkedList<IExpr> queue = new LinkedList<IExpr>();
        queue.add(root);
        while (!queue.isEmpty()) {
            MetaField.FormulaAggStatus subStatus = null;
            IExpr node = (IExpr)queue.remove();
            if (node instanceof RefExpr) {
                IExpr[] fieldName = ((RefExpr)node).getName();
                MetaField mf = metaFields.get(fieldName);
                if (mf == null || mf.isInvalid()) {
                    throw new RuntimeException("Impossible here");
                }
                try {
                    subStatus = mf.isCalculation() ? Meta.getNotNullFieldAggStatus(mf, metaFields) : MetaField.FormulaAggStatus.Ref;
                }
                catch (FormulaException.MixedException ex) {
                    mf.setInvalid(true);
                    throw ex;
                }
            }
            if (node instanceof AbstractAggregationFunction) {
                subStatus = MetaField.FormulaAggStatus.Agg;
            } else if (node instanceof AbstractInterlineFunction) {
                subStatus = MetaField.FormulaAggStatus.Interline;
                for (IExpr param : ((AbstractInterlineFunction)node).getSubExprs()) {
                    Meta.confirmFormulaAggStatus(param, metaFields);
                }
            } else if (node instanceof AbstractWithTotalFunction) {
                subStatus = MetaField.FormulaAggStatus.WithTotal;
                for (IExpr param : ((AbstractWithTotalFunction)node).getSubExprs()) {
                    Meta.confirmFormulaAggStatus(param, metaFields);
                }
            } else if (node instanceof AbstractOpExpr) {
                IExpr[] subs;
                for (IExpr sub : subs = ((AbstractOpExpr)node).getSubExprs()) {
                    queue.add(sub);
                }
            }
            if (subStatus == null) continue;
            if (MetaField.FormulaAggStatus.isRelativeAggregation(mergedStatus) && subStatus == MetaField.FormulaAggStatus.Ref || mergedStatus == MetaField.FormulaAggStatus.Ref && MetaField.FormulaAggStatus.isRelativeAggregation(subStatus)) {
                throw new FormulaException.MixedException(FormulaException.MixedException.Type.AggMixRef, node.getCharIndexAtFormula());
            }
            mergedStatus = mergedStatus == null || mergedStatus.getLevel() < subStatus.getLevel() ? subStatus : mergedStatus;
        }
        return mergedStatus;
    }

    private static MetaField.FormulaAggStatus getNotNullFieldAggStatus(MetaField mf, Map<String, MetaField> metaFields) throws FormulaException.MixedException {
        MetaField.FormulaAggStatus status = mf.getFormulaAggStatus();
        if (status == null) {
            status = Meta.confirmFormulaAggStatus(mf.getExpr(), metaFields);
            mf.setFormulaAggStatus(status);
        }
        return status;
    }

    private static MetaField.FormulaAggStatus checkNestedAggregation(IExpr node, Map<String, MetaField> metaFields, MetaField.FormulaAggStatus ancestorAggStatus) throws FormulaException.MixedException {
        MetaField.FormulaAggStatus aggStatus = null;
        if (node instanceof RefExpr) {
            String fieldName = ((RefExpr)node).getName();
            MetaField mf = metaFields.get(fieldName);
            if (mf == null || mf.isInvalid()) {
                throw new RuntimeException("Impossible here");
            }
            if (mf.isCalculation()) {
                try {
                    aggStatus = Meta.getNotNullFieldAggStatus(mf, metaFields);
                }
                catch (FormulaException.MixedException ex) {
                    aggStatus = MetaField.FormulaAggStatus.Agg;
                }
            }
        } else if (node instanceof AbstractAggregationFunction) {
            aggStatus = MetaField.FormulaAggStatus.Agg;
        } else if (node instanceof AbstractInterlineFunction) {
            aggStatus = MetaField.FormulaAggStatus.Interline;
        } else if (node instanceof AbstractWithTotalFunction) {
            aggStatus = MetaField.FormulaAggStatus.WithTotal;
        }
        if (ancestorAggStatus == MetaField.FormulaAggStatus.Agg && aggStatus == MetaField.FormulaAggStatus.Agg) {
            throw new FormulaException.MixedException(FormulaException.MixedException.Type.NestedAgg, node.getCharIndexAtFormula());
        }
        if (ancestorAggStatus != MetaField.FormulaAggStatus.Interline || aggStatus == MetaField.FormulaAggStatus.Interline) {
            // empty if block
        }
        if (ancestorAggStatus == MetaField.FormulaAggStatus.WithTotal && aggStatus == MetaField.FormulaAggStatus.WithTotal) {
            throw new FormulaException.MixedException(FormulaException.MixedException.Type.NestedInterline, node.getCharIndexAtFormula());
        }
        if (ancestorAggStatus == MetaField.FormulaAggStatus.Agg && aggStatus == MetaField.FormulaAggStatus.Interline) {
            throw new FormulaException.MixedException(FormulaException.MixedException.Type.AggBeforeInterline, node.getCharIndexAtFormula());
        }
        if (ancestorAggStatus == MetaField.FormulaAggStatus.Agg && aggStatus == MetaField.FormulaAggStatus.WithTotal) {
            throw new FormulaException.MixedException(FormulaException.MixedException.Type.AggBeforeInterline, node.getCharIndexAtFormula());
        }
        if (ancestorAggStatus == MetaField.FormulaAggStatus.Interline && aggStatus == MetaField.FormulaAggStatus.WithTotal) {
            throw new FormulaException.MixedException(FormulaException.MixedException.Type.NestedInterline, node.getCharIndexAtFormula());
        }
        if (node instanceof AbstractOpExpr) {
            MetaField.FormulaAggStatus aggStatusForDescendant = null;
            aggStatusForDescendant = ancestorAggStatus == null ? aggStatus : (aggStatus == null ? ancestorAggStatus : (ancestorAggStatus.getLevel() > aggStatus.getLevel() ? ancestorAggStatus : aggStatus));
            IExpr[] subs = ((AbstractOpExpr)node).getSubExprs();
            ArrayList<MetaField.FormulaAggStatus> descendantAggStatus = new ArrayList<MetaField.FormulaAggStatus>(subs.length);
            for (IExpr sub : subs) {
                descendantAggStatus.add(Meta.checkNestedAggregation(sub, metaFields, aggStatusForDescendant));
            }
            MetaField.FormulaAggStatus merged = null;
            for (MetaField.FormulaAggStatus d : descendantAggStatus) {
                if (d == null) continue;
                merged = merged == null || merged.getLevel() < d.getLevel() ? d : merged;
            }
            if (aggStatus == MetaField.FormulaAggStatus.Interline && !MetaField.FormulaAggStatus.isRelativeAggregation(merged)) {
                throw new FormulaException.MixedException(FormulaException.MixedException.Type.InterlineWithoutAgg, node.getCharIndexAtFormula());
            }
            if (aggStatus == MetaField.FormulaAggStatus.WithTotal && merged != MetaField.FormulaAggStatus.Agg && merged != MetaField.FormulaAggStatus.Interline) {
                throw new FormulaException.MixedException(FormulaException.MixedException.Type.InterlineWithoutAgg, node.getCharIndexAtFormula());
            }
            if (aggStatus == null) {
                aggStatus = merged;
            }
        }
        return aggStatus;
    }

    private static void collectDependence(IExpr root, Map<String, MetaField> metaFields, Set<String> collector) {
        ArrayList<IExpr> queue = new ArrayList<IExpr>();
        queue.add(root);
        while (!queue.isEmpty()) {
            IExpr[] subs;
            IExpr node = (IExpr)queue.remove(0);
            if (node instanceof RefExpr) {
                String fieldName = ((RefExpr)node).getName();
                MetaField mf = metaFields.get(fieldName);
                if (mf == null || mf.isInvalid()) {
                    throw new RuntimeException("Impossible here");
                }
                if (mf.isCalculation()) {
                    Set<String> dependence = mf.getAllDependence();
                    if (dependence == null) {
                        dependence = new HashSet<String>();
                        Meta.collectDependence(mf.getExpr(), metaFields, dependence);
                        mf.setAllDependence(dependence);
                    }
                    collector.add(fieldName);
                    collector.addAll(dependence);
                    continue;
                }
                collector.add(fieldName);
                continue;
            }
            if (!(node instanceof AbstractOpExpr)) continue;
            for (IExpr sub : subs = ((AbstractOpExpr)node).getSubExprs()) {
                queue.add(sub);
            }
        }
    }

    public static DataType confirmMetaFieldDataType(IExpr expr) {
        switch (expr.getReturnDataType()) {
            case 2: {
                return DataType.NUMBER;
            }
            case 3: 
            case 4: 
            case 5: {
                return DataType.DATE;
            }
        }
        return DataType.STRING;
    }

    public static int confirmExprDataType(MetaField mf) {
        if (mf.getDataType() == null) {
            return 0;
        }
        switch (mf.getDataType()) {
            case NUMBER: {
                return 2;
            }
            case DATE: {
                return 3;
            }
        }
        return 1;
    }

    public static enum Src {
        ER,
        MD;

    }

    private static class ContextRelativedExprConfirmer
    implements IContextRelativedExprConfirmer {
        private Map<String, MetaField> _metaFields;

        public ContextRelativedExprConfirmer(Map<String, MetaField> metaFields) {
            this._metaFields = metaFields;
        }

        public void checkRefExpr(RefExpr expr) throws ParserException {
            MetaField mf = this._metaFields.get(expr.getName());
            if (mf == null) {
                throw new ParserException(11, expr.getCharIndexAtFormula());
            }
            if (mf.isInvalid()) {
                throw new ParserException(12, expr.getCharIndexAtFormula());
            }
            expr.setReturnDataType(Meta.confirmExprDataType(mf));
        }

        public void checkVariantExpr(VariantExpr expr) throws ParserException {
            throw new ParserException(17, expr.getCharIndexAtFormula());
        }
    }

    private static class FormulaParsingExceptionHandlerImpl
    implements IFormulaParsingExceptionHandler {
        private FormulaParsingExceptionHandlerImpl() {
        }

        @Override
        public boolean forParsing(MetaField mf, ParserException ex) {
            mf.setInvalid(true);
            if (LogUtil.isDebugEnabled()) {
                LogUtil.debug((String)("Parser formula error: " + mf.getFormula()), (Throwable)ex);
            }
            return false;
        }

        @Override
        public boolean forChecking(MetaField mf, FormulaException ex) {
            mf.setInvalid(true);
            if (LogUtil.isDebugEnabled()) {
                LogUtil.debug((String)("Check formula error: " + mf.getExpr().encode()), (Throwable)((Object)ex));
            }
            return false;
        }
    }

    public static interface IFormulaParsingExceptionHandler {
        public boolean forParsing(MetaField var1, ParserException var2);

        public boolean forChecking(MetaField var1, FormulaException var2);
    }
}

