/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.meta;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.core.model.meta.ParentChildDimension;
import com.kingdee.bos.qing.core.model.meta.view.AbstractViewItem;
import com.kingdee.bos.qing.core.model.meta.view.MetaTableSubView;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class MetaTable {
    private String name;
    private String displayName;
    private String parentName;
    private List<MetaField> fields;
    private List<ParentChildDimension> parentChildDimensions;
    private List<MetaTableSubView> subViews = null;
    private List<AbstractViewItem> viewItems = null;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setFields(List<MetaField> metaFields) {
        this.fields = metaFields;
    }

    public List<MetaField> getFields() {
        return this.fields;
    }

    public void setParentChildDimensions(List<ParentChildDimension> pcds) {
        this.parentChildDimensions = pcds;
    }

    public List<ParentChildDimension> getParentChildDimensions() {
        return this.parentChildDimensions;
    }

    public ParentChildDimension searchParentChildDimension(String name) {
        if (this.parentChildDimensions != null) {
            for (ParentChildDimension pcd : this.parentChildDimensions) {
                if (!name.equals(pcd.getName())) continue;
                return pcd;
            }
        }
        return null;
    }

    public void setSubViews(List<MetaTableSubView> subViews) {
        this.subViews = subViews;
    }

    public List<MetaTableSubView> getSubViews() {
        if (this.subViews == null) {
            this.subViews = new ArrayList<MetaTableSubView>();
        }
        return this.subViews;
    }

    public void setViewItems(List<AbstractViewItem> items) {
        this.viewItems = items;
    }

    public List<AbstractViewItem> getViewItems() {
        if (this.viewItems == null) {
            this.viewItems = new ArrayList<AbstractViewItem>();
        }
        return this.viewItems;
    }

    public Element toXml() {
        Element node = new Element("Table");
        XmlUtil.writeAttrWhenExist((Element)node, (String)"name", (String)this.name);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"displayName", (String)this.displayName);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"parent", (String)this.parentName);
        Element nodeFields = new Element("Fields");
        node.addContent((Content)nodeFields);
        for (int i = 0; i < this.fields.size(); ++i) {
            MetaField mf = this.fields.get(i);
            nodeFields.addContent((Content)mf.toXml());
        }
        if (this.parentChildDimensions != null && !this.parentChildDimensions.isEmpty()) {
            Element nodeDefines = new Element("Defines");
            node.addContent((Content)nodeDefines);
            for (ParentChildDimension pcd : this.parentChildDimensions) {
                nodeDefines.addContent((Content)pcd.toXml());
            }
        }
        if (this.viewItems != null && !this.viewItems.isEmpty()) {
            Element nodeItems = AbstractViewItem.itemsToXml(this.viewItems);
            node.addContent((Content)nodeItems);
        }
        if (this.subViews != null && !this.subViews.isEmpty()) {
            Element nodeSubViews = MetaTableSubView.subViewsToXml(this.subViews);
            node.addContent((Content)nodeSubViews);
        }
        return node;
    }

    public void fromXml(Element node) throws PersistentModelParseException {
        this.name = XmlUtil.readAttrWhenExist((Element)node, (String)"name");
        this.displayName = XmlUtil.readAttrWhenExist((Element)node, (String)"displayName");
        this.parentName = XmlUtil.readAttrWhenExist((Element)node, (String)"parent");
        Element nodeFields = null;
        try {
            nodeFields = XmlUtil.getChildNotNull((Element)node, (String)"Fields");
        }
        catch (XmlUtil.NullException ex) {
            throw new PersistentModelParseException(ex);
        }
        List fieldNodes = XmlUtil.getChildren((Element)nodeFields);
        ArrayList<MetaField> fieldList = new ArrayList<MetaField>(fieldNodes.size());
        for (Element nodeFiled : fieldNodes) {
            MetaField mf = new MetaField();
            mf.fromXml(nodeFiled);
            fieldList.add(mf);
        }
        this.setFields(fieldList);
        Element nodeDefines = XmlUtil.getChild((Element)node, (String)"Defines");
        if (nodeDefines != null) {
            List nodePcds = XmlUtil.getChildren((Element)nodeDefines, (String)ParentChildDimension.getPersistentNodeName());
            if (nodePcds.isEmpty()) {
                this.parentChildDimensions = null;
            } else {
                this.parentChildDimensions = new ArrayList<ParentChildDimension>(nodePcds.size());
                for (Element nodePcd : nodePcds) {
                    ParentChildDimension pcd = new ParentChildDimension();
                    pcd.fromXml(nodePcd);
                    this.parentChildDimensions.add(pcd);
                }
            }
        }
        this.viewItems = AbstractViewItem.itemsFromXml(node);
        this.subViews = MetaTableSubView.subViewsFromXml(node);
    }

    public void fixMetaFieldOwner() {
        for (int i = 0; i < this.fields.size(); ++i) {
            MetaField mf = this.fields.get(i);
            mf.setMetaTable(this);
        }
    }
}

