/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.parser;

import com.kingdee.bos.qing.common.grammar.IContextRelativedExprConfirmer;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.grammar.expr.RefExpr;
import com.kingdee.bos.qing.common.grammar.expr.VariantExpr;
import com.kingdee.bos.qing.core.flattening.common.func.FunctionRegister;
import com.kingdee.bos.qing.core.model.parser.AbstractFormulaParserPool;
import com.kingdee.bos.qing.core.model.parser.SharedFunctionProvider;

public class StyleScriptParser
extends AbstractFormulaParserPool {
    private static StyleScriptParser instance = new StyleScriptParser();
    private static SharedFunctionProvider functionProviderForNormal = new SharedFunctionProvider();
    private static SharedFunctionProvider functionProviderForGrid = new SharedFunctionProvider();
    private static SharedFunctionProvider functionProviderForKpi = new SharedFunctionProvider();

    public static IExpr parse(Type type, String formula) throws ParserException {
        ContextRelativedExprConfirmer refConfirmer = new ContextRelativedExprConfirmer(type);
        switch (type) {
            case Normal: {
                return instance.parseImpl(functionProviderForNormal, formula, refConfirmer);
            }
            case Grid: {
                return instance.parseImpl(functionProviderForGrid, formula, refConfirmer);
            }
            case Kpi: {
                return instance.parseImpl(functionProviderForKpi, formula, refConfirmer);
            }
        }
        throw new RuntimeException("Impossible");
    }

    private StyleScriptParser() {
    }

    static {
        FunctionRegister.registAboutNormalChart(functionProviderForNormal);
        FunctionRegister.registAboutGridChart(functionProviderForGrid);
        FunctionRegister.registAboutKpiChart(functionProviderForKpi);
    }

    private static class ContextRelativedExprConfirmer
    implements IContextRelativedExprConfirmer {
        private Type _type;

        public ContextRelativedExprConfirmer(Type type) {
            this._type = type;
        }

        public void checkRefExpr(RefExpr expr) throws ParserException {
            throw new ParserException(11, expr.getCharIndexAtFormula());
        }

        public void checkVariantExpr(VariantExpr expr) throws ParserException {
            switch (this._type) {
                case Normal: {
                    this.checkForNormal(expr);
                    break;
                }
                case Grid: {
                    this.checkForGrid(expr);
                    break;
                }
                case Kpi: {
                    this.checkForKpi(expr);
                    break;
                }
                default: {
                    throw new RuntimeException("Impossible");
                }
            }
        }

        private void checkForNormal(VariantExpr expr) throws ParserException {
            if ("CATEGORY".equalsIgnoreCase(expr.getName())) {
                expr.setReturnDataType(0);
            } else if ("MEASURE".equalsIgnoreCase(expr.getName())) {
                expr.setReturnDataType(2);
            } else if ("SERIES_INDEX".equalsIgnoreCase(expr.getName())) {
                expr.setReturnDataType(2);
            } else {
                throw new ParserException(17, expr.getCharIndexAtFormula());
            }
        }

        private void checkForGrid(VariantExpr expr) throws ParserException {
            if ("ROW_NUM".equalsIgnoreCase(expr.getName())) {
                expr.setReturnDataType(2);
            } else if ("COLUMN_NUM".equalsIgnoreCase(expr.getName())) {
                expr.setReturnDataType(2);
            } else if ("COLUMN_NAME".equalsIgnoreCase(expr.getName())) {
                expr.setReturnDataType(1);
            } else if ("VALUE".equalsIgnoreCase(expr.getName())) {
                expr.setReturnDataType(0);
            } else {
                throw new ParserException(17, expr.getCharIndexAtFormula());
            }
        }

        private void checkForKpi(VariantExpr expr) throws ParserException {
            if (!"VALUE".equalsIgnoreCase(expr.getName())) {
                throw new ParserException(17, expr.getCharIndexAtFormula());
            }
            expr.setReturnDataType(2);
        }
    }

    public static enum Type {
        Normal,
        Grid,
        Kpi;

    }
}

