/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.model.widget;

import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.affected.AffectedTargets;
import com.kingdee.bos.qing.dashboard.model.widget.AbstractWidget;
import com.kingdee.bos.qing.dashboard.model.withlabel.InputCtrlWithLabel;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.Calendar;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class AbstractCalendar
extends AbstractWidget {
    private Boolean containNull;
    private Long dateFrom;
    private Long dateTo;
    private AffectedTargets affectedTargets;
    private InputCtrlWithLabel withLabel;

    public static long[] parseRange(SimpleRalative relative, String part) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.set(11, 0);
        calendar1.set(12, 0);
        calendar1.set(13, 0);
        calendar1.set(14, 0);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        int offset = relative.getOffset();
        if (offset != 0) {
            int field;
            if ("Y".equals(part)) {
                field = 1;
            } else if ("YQ".equals(part)) {
                field = 2;
                offset *= 3;
            } else {
                field = "YM".equals(part) ? 2 : 5;
            }
            calendar1.add(field, offset);
            calendar2.add(field, offset);
        }
        int year = calendar1.get(1);
        if ("Y".equals(part)) {
            calendar1.set(year, 0, 1);
            calendar2.set(year, 11, 31);
        } else if ("YQ".equals(part)) {
            int firstMonth = calendar1.get(2) / 3 * 3;
            int lastMonth = firstMonth + 2;
            calendar1.set(year, firstMonth, 1);
            calendar2.set(year, lastMonth, 1);
            int lastDay = calendar2.getActualMaximum(5);
            calendar2.set(5, lastDay);
        } else if ("YM".equals(part)) {
            int firstDay = 1;
            int lastDay = calendar2.getActualMaximum(5);
            calendar1.set(5, firstDay);
            calendar2.set(5, lastDay);
        }
        long dateStart = calendar1.getTimeInMillis();
        long dateEnd = calendar2.getTimeInMillis();
        return new long[]{dateStart, dateEnd};
    }

    @Override
    protected final void toXmlMore(Element node) {
        XmlUtil.writeAttrLongWhenExist((Element)node, (String)"dateFrom", (Long)this.dateFrom);
        XmlUtil.writeAttrLongWhenExist((Element)node, (String)"dateTo", (Long)this.dateTo);
        XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"containNull", (Boolean)this.containNull);
        if (this.affectedTargets != null) {
            Element nodeAffectedTarget = new Element("Affected");
            node.addContent((Content)nodeAffectedTarget);
            this.affectedTargets.toXml(nodeAffectedTarget);
        }
        InputCtrlWithLabel.withLabelToXml(this.withLabel, node);
        this.calendarToXml(node);
    }

    protected abstract void calendarToXml(Element var1);

    @Override
    protected final void fromXmlMore(Element node) throws PersistentModelParseException {
        this.dateFrom = XmlUtil.readAttrLongWhenExist((Element)node, (String)"dateFrom");
        this.dateTo = XmlUtil.readAttrLongWhenExist((Element)node, (String)"dateTo");
        this.containNull = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"containNull");
        Element nodeAffectedTarget = node.getChild("Affected");
        if (nodeAffectedTarget != null) {
            this.affectedTargets = new AffectedTargets();
            this.affectedTargets.fromXml(nodeAffectedTarget);
        }
        this.withLabel = InputCtrlWithLabel.withLabelFromXml(node);
        this.calendarFromXml(node);
    }

    protected abstract void calendarFromXml(Element var1) throws PersistentModelParseException;

    public static class SimpleRalative {
        public static final String PART_Y = "Y";
        public static final String PART_YQ = "YQ";
        public static final String PART_YM = "YM";
        public static final String PART_YMD = "YMD";
        private Integer offset;

        public int getOffset() {
            return this.offset == null ? 0 : this.offset;
        }

        public void toXml(Element node) {
            XmlUtil.writeAttrIntWhenExist((Element)node, (String)"offset", (Integer)this.offset);
        }

        public void fromXml(Element node) {
            this.offset = XmlUtil.readAttrIntWhenExist((Element)node, (String)"offset");
        }
    }
}

