/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.model.widget;

import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.widget.AbstractWidget;
import com.kingdee.bos.qing.dashboard.model.widget.WidgetTypeName;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class AbstractContainer
extends AbstractWidget {
    private List<AbstractWidget> widgets;

    public int getChildrenCount() {
        return this.widgets == null ? 0 : this.widgets.size();
    }

    public AbstractWidget getChild(int idx) {
        return this.widgets.get(idx);
    }

    @Override
    protected void toXmlMore(Element node) {
        Element nodeChildren = new Element("Children");
        for (AbstractWidget widget : this.widgets) {
            Element nodeChild = widget.toXml();
            nodeChildren.addContent((Content)nodeChild);
        }
        node.addContent((Content)nodeChildren);
    }

    @Override
    protected void fromXmlMore(Element node) throws PersistentModelParseException {
        this.widgets = new ArrayList<AbstractWidget>();
        Element nodeChildren = node.getChild("Children");
        if (nodeChildren != null) {
            List childrenNodes = nodeChildren.getChildren();
            for (Element nodeChild : childrenNodes) {
                WidgetTypeName widgetTypeName = WidgetTypeName.fromXmlNodeName(nodeChild.getName());
                AbstractWidget widget = null;
                try {
                    widget = widgetTypeName.getWidgetClass().newInstance();
                }
                catch (InstantiationException ex) {
                    throw PersistentModelParseException.createParseError(ex);
                }
                catch (IllegalAccessException ex) {
                    throw PersistentModelParseException.createParseError(ex);
                }
                widget.fromXml(nodeChild);
                this.widgets.add(widget);
            }
        }
    }
}

