/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dashboard.model.widget;

import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.widget.AbstractContainer;
import com.kingdee.bos.qing.dashboard.model.widget.AbstractWidget;
import com.kingdee.bos.qing.dashboard.model.widget.Picture;
import com.kingdee.bos.qing.dashboard.model.widget.WidgetTypeName;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.LinkedList;
import org.jdom2.Content;
import org.jdom2.Element;

public class Page
extends AbstractContainer {
    private String exhibitionMode;
    private String skin;
    private String watermark;
    private Background background;
    private String mobileLayoutConverter;
    private Boolean mobileSkinActive;

    @Override
    protected WidgetTypeName getWidgetTypeName() {
        return WidgetTypeName.Page;
    }

    public Background getBackgroundPicture() {
        return this.background;
    }

    @Override
    protected void toXmlMore(Element node) {
        XmlUtil.writeAttrWhenExist((Element)node, (String)"exhibitionMode", (String)this.exhibitionMode);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"skin", (String)this.skin);
        XmlUtil.writeAttrWhenExist((Element)node, (String)"watermark", (String)this.watermark);
        if (this.background != null) {
            Element nodeBackground = this.background.toXml();
            nodeBackground.setName("Background");
            node.addContent((Content)nodeBackground);
        }
        XmlUtil.writeAttrWhenExist((Element)node, (String)"mobileLayoutConverter", (String)this.mobileLayoutConverter);
        XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"mobileSkinActive", (Boolean)this.mobileSkinActive);
        super.toXmlMore(node);
    }

    @Override
    protected void fromXmlMore(Element node) throws PersistentModelParseException {
        this.exhibitionMode = XmlUtil.readAttrWhenExist((Element)node, (String)"exhibitionMode");
        this.skin = XmlUtil.readAttrWhenExist((Element)node, (String)"skin");
        this.watermark = XmlUtil.readAttrWhenExist((Element)node, (String)"watermark");
        Element nodeBackground = node.getChild("Background");
        if (nodeBackground != null) {
            this.background = new Background();
            this.background.fromXml(nodeBackground);
        }
        this.mobileLayoutConverter = XmlUtil.readAttrWhenExist((Element)node, (String)"mobileLayoutConverter");
        this.mobileSkinActive = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"mobileSkinActive");
        super.fromXmlMore(node);
    }

    public void visitAllWidgets(IWidgetVisitor visitor) {
        LinkedList<AbstractContainer> queue = new LinkedList<AbstractContainer>();
        queue.addLast(this);
        while (!queue.isEmpty()) {
            AbstractContainer container = (AbstractContainer)queue.removeFirst();
            int c = container.getChildrenCount();
            for (int i = 0; i < c; ++i) {
                AbstractWidget child = container.getChild(i);
                boolean isBreak = visitor.visiting(child);
                if (isBreak) {
                    return;
                }
                if (!(child instanceof AbstractContainer)) continue;
                queue.addLast((AbstractContainer)child);
            }
        }
    }

    public static class Background
    extends Picture {
        @Override
        public Element toXml() {
            Element node = new Element("N");
            this.toXmlMore(node);
            return node;
        }

        @Override
        public void fromXml(Element node) throws PersistentModelParseException {
            this.fromXmlMore(node);
        }
    }

    public static interface IWidgetVisitor {
        public boolean visiting(AbstractWidget var1);
    }
}

