/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.i18n.DefaultI18nContext;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.DataParseException;
import com.kingdee.bos.qing.core.exception.EnvCeilingException;
import com.kingdee.bos.qing.core.exception.MetaParseException;
import com.kingdee.bos.qing.core.model.exhibition.longer.TableView;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IMetaVisitor;
import com.kingdee.bos.qing.monitor.ICorrespondent;
import com.kingdee.bos.qing.monitor.RuntimeMonitor;

public abstract class AbstractDomain {
    private IDataSourceCreator _dataSourceCreator;
    private II18nContext _i18nContext;
    private String _skin;

    public AbstractDomain(IDataSourceCreator dataSourceCreator) {
        this._dataSourceCreator = dataSourceCreator;
    }

    protected final IMetaVisitor createMetaVisitor() throws MetaParseException {
        try {
            return this._dataSourceCreator.createMetaVisitor();
        }
        catch (AbstractDataSourceException ex) {
            throw new MetaParseException(ex);
        }
    }

    protected final IDataSourceVisitor createDataSourceVisitor() throws DataParseException {
        try {
            return this._dataSourceCreator.createDataSourceVisitor();
        }
        catch (AbstractDataSourceException ex) {
            throw new DataParseException(ex);
        }
    }

    protected final IDataSourceCreator getDataSourceCreator() {
        return this._dataSourceCreator;
    }

    public final void setI18nContext(II18nContext i18nCtx) {
        this._i18nContext = i18nCtx;
    }

    protected final II18nContext getI18nContext() {
        if (this._i18nContext == null) {
            this._i18nContext = new DefaultI18nContext();
        }
        return this._i18nContext;
    }

    public final void setSkinName(String skin) {
        this._skin = skin;
    }

    public final String getSkinName() {
        return this._skin;
    }

    protected static ICorrespondent createExecutingCorrespondent() throws EnvCeilingException {
        return RuntimeMonitor.regist("");
    }

    protected static void destroyExecutingCorrespondent(ICorrespondent correspondent) {
        if (correspondent != null) {
            RuntimeMonitor.unregist(correspondent);
        }
    }

    public static interface IExhibitionCacheReader {
        public String getCachedJson(String var1, int var2, int var3) throws AnalysisException;

        public String getCachedJsonForTree(String var1, int var2, int var3, int var4) throws AnalysisException;
    }

    public static interface IExhibitionCacheWriter {
        public String createCacheKey();

        public void asyncCache(TableView var1, boolean var2);
    }

    public static interface IDataCacheSupporter {
        public IDataSourceVisitor createCachedDataSourceVisitor(String var1) throws AbstractDataSourceException;

        public IExhibitionCacheWriter createExhibitionCacheWriter(QingContext var1);

        public IExhibitionCacheReader createExhibitionCacheReader();
    }

    public static interface IDataSourceCreator
    extends IDataCacheSupporter {
        public IMetaVisitor createMetaVisitor() throws AbstractDataSourceException;

        public IDataSourceVisitor createDataSourceVisitor() throws AbstractDataSourceException;
    }
}

