/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.exception.MetaParseException;
import com.kingdee.bos.qing.core.flattening.common.ExecutableValueCoder;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.ExecutableValue;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.ContinuousDateFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.DiscreteFilter;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.FilterFieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.FilterItem;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.MetaDomain;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdditionalFilterDomain
extends AbstractDomain {
    public AdditionalFilterDomain(AbstractDomain.IDataSourceCreator dataSourceCreator) {
        super(dataSourceCreator);
    }

    public void mergeInto(IQingModel model, AdditionalFilters additionalFilters) throws MetaParseException {
        if (model instanceof SquareModel) {
            this.mergeIntoSquare((SquareModel)model, additionalFilters);
        } else if (model instanceof AnalyticalModel) {
            this.mergeIntoLonger((AnalyticalModel)model, additionalFilters);
        } else {
            throw new RuntimeException("Modify here.");
        }
    }

    public void mergeIntoSquare(SquareModel model, AdditionalFilters additionalFilters) throws MetaParseException {
        final List<FilterItem> filters = model.getFilters();
        Map<String, MetaField> metaFields = this.getMeta().createSearchingMap();
        this.traversal(additionalFilters, metaFields, new IActor(){

            @Override
            public void act(AnalyticalField field, AbstractAnalyticalFilter filter) {
                FilterItem filterItem = new FilterItem();
                filterItem.setField(field);
                filterItem.setFilter(filter);
                filters.add(filterItem);
            }
        });
        this.traversal(additionalFilters, model);
    }

    public void mergeIntoLonger(AnalyticalModel model, AdditionalFilters additionalFilters) throws MetaParseException {
        final FilterFieldSet filterFieldSet = model.getFilterFieldSet();
        Map<String, MetaField> metaFields = this.getMeta().createSearchingMap();
        this.traversal(additionalFilters, metaFields, new IActor(){

            @Override
            public void act(AnalyticalField field, AbstractAnalyticalFilter filter) {
                filterFieldSet.getFields().add(field);
                filterFieldSet.getFilters().add(filter);
            }
        });
        this.traversal(additionalFilters, model);
    }

    private Meta getMeta() throws MetaParseException {
        Meta meta = new MetaDomain(this.getDataSourceCreator()).getMeta();
        return meta;
    }

    private void traversal(AdditionalFilters additionalFilters, IQingModel model) {
        for (AdditionalFilterItem additionalFilterItem : additionalFilters.getItems()) {
            if (additionalFilterItem.isMetaFieldBound()) continue;
            String name = additionalFilterItem.getParameterName();
            String value = additionalFilterItem.getDowngradingSelectedValue();
            model.getParameters().getNotNullItem(name).setValue(value);
        }
    }

    private void traversal(AdditionalFilters additionalFilters, Map<String, MetaField> metaFields, IActor actor) {
        for (AdditionalFilterItem additionalFilterItem : additionalFilters.getItems()) {
            AbstractAnalyticalFilter filter;
            MetaField metaField;
            if (!additionalFilterItem.isMetaFieldBound() || (metaField = metaFields.get(additionalFilterItem.getMetaFieldFullName())) == null || !metaField.getDataType().name().equals(additionalFilterItem.getValueDataType())) continue;
            AnalyticalField field = new AnalyticalField();
            field.setName(additionalFilterItem.getMetaFieldFullName());
            field.setRole("dimension");
            field.bindMetaField(metaField);
            field.fixMetaFieldBinding(metaFields);
            if (metaField.getDataType() == DataType.STRING) {
                filter = this.createDiscreteFilter(field, additionalFilterItem);
            } else if (metaField.getDataType() == DataType.DATE) {
                filter = this.createDateRangeFilter(field, additionalFilterItem);
            } else {
                throw new RuntimeException("Unsupported");
            }
            actor.act(field, filter);
        }
    }

    private DiscreteFilter createDiscreteFilter(AnalyticalField field, AdditionalFilterItem afi) {
        if (field.isParentChildDimension()) {
            MetaField mf = field.getParentChildDimensionIdField();
            field.setName(mf.getFullName());
            field.bindMetaField(mf);
        }
        FilterPreparedValueGainer.GainerPeers gainerPeer = new FilterPreparedValueGainer.GainerPeers(field, this.getI18nContext());
        gainerPeer.setAppointedAsTree(false);
        List<String> selectedValue = afi.getSelectedValue();
        for (String selectedComplexValue : selectedValue) {
            List<ExecutableValue> list = ExecutableValueCoder.decodeComplexValue(selectedComplexValue);
            for (ExecutableValue ev : list) {
                gainerPeer.gain(ev.getOriginalValue());
            }
        }
        List<String> selecteds = gainerPeer.getAllPreparedValue();
        DiscreteFilter filter = new DiscreteFilter();
        filter.setSelecteds(selecteds);
        return filter;
    }

    private ContinuousDateFilter createDateRangeFilter(AnalyticalField field, AdditionalFilterItem afi) {
        String value = afi.getDowngradingSelectedValue();
        DateFilterSelectedValue dfsv = (DateFilterSelectedValue)JsonUtil.decodeFromString((String)value, DateFilterSelectedValue.class);
        DateFilterSelectedValue.Range range = dfsv.getDateRange();
        ContinuousDateFilter filter = new ContinuousDateFilter();
        filter.setContainNull(range.isContainNull());
        filter.setDateFrom(range.getDateFrom());
        filter.setDateTo(range.getDateTo());
        return filter;
    }

    public static class DateFilterSelectedValue {
        private Range dateRange;

        public Range getDateRange() {
            return this.dateRange;
        }

        public static class Range {
            private Boolean containNull;
            private Long dateFrom;
            private Long dateTo;

            public boolean isContainNull() {
                return this.containNull == null ? false : this.containNull;
            }

            public long getDateFrom() {
                return this.dateFrom;
            }

            public long getDateTo() {
                return this.dateTo;
            }
        }
    }

    public static class AdditionalFilterItem {
        private boolean isMetaFieldBound;
        private String key;
        private List<String> selectedValue;
        private String valueDataType;

        public void setKey(String key) {
            this.key = key;
        }

        public void setSelectedValue(List<String> valueDataType) {
            this.selectedValue = valueDataType;
        }

        public void setMetaFieldBound(boolean isMetaFieldBound) {
            this.isMetaFieldBound = isMetaFieldBound;
        }

        public void setValueDataType(String valueDataType) {
            this.valueDataType = valueDataType;
        }

        public boolean isMetaFieldBound() {
            return this.isMetaFieldBound;
        }

        public String getParameterName() {
            return this.key;
        }

        public String getMetaFieldFullName() {
            return this.key;
        }

        public List<String> getSelectedValue() {
            return this.selectedValue;
        }

        public String getDowngradingSelectedValue() {
            if (this.selectedValue == null || this.selectedValue.size() == 0) {
                return null;
            }
            return this.selectedValue.get(0);
        }

        public String getValueDataType() {
            return this.valueDataType;
        }
    }

    public static class AdditionalFilters {
        private List<AdditionalFilterItem> items;

        public List<AdditionalFilterItem> getItems() {
            return this.items;
        }

        public void addItems(String key, List<String> entityName) {
            if (this.items == null) {
                this.items = new ArrayList<AdditionalFilterItem>();
            }
            AdditionalFilterItem additionalFilterItem = new AdditionalFilterItem();
            additionalFilterItem.setKey(key);
            additionalFilterItem.setSelectedValue(entityName);
            additionalFilterItem.setMetaFieldBound(true);
            additionalFilterItem.setValueDataType("STRING");
            this.items.add(additionalFilterItem);
        }

        public static AdditionalFilters decodeAdditionalFilters(String jsonString) {
            return (AdditionalFilters)JsonUtil.decodeFromString((String)jsonString, AdditionalFilters.class);
        }
    }

    static interface IActor {
        public void act(AnalyticalField var1, AbstractAnalyticalFilter var2);
    }
}

