/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.core.brief.BriefOutput;
import com.kingdee.bos.qing.core.brief.BriefOutputExecutor;
import com.kingdee.bos.qing.core.engine.IEngineOutput;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.BriefOutputException;
import com.kingdee.bos.qing.core.model.analysis.AbstractQingModel;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.common.brief.BriefOutputDefinition;
import com.kingdee.bos.qing.domain.AbstractBriefOutputDomain;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.AdditionalFilterDomain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BriefOutputDomain
extends AbstractBriefOutputDomain {
    public BriefOutputDomain(AbstractDomain.IDataSourceCreator dataSourceCreator) {
        super(dataSourceCreator);
    }

    public BriefOutput execute(IQingModel model, BriefOutputDefinition definition) {
        IEngineOutput engineOutput;
        try {
            engineOutput = this.makeCube(model, null);
        }
        catch (AnalysisException ex) {
            return new BriefOutput(ex.getErrorCode(), ex.getMessage());
        }
        boolean display = true;
        boolean preview = true;
        return this.makeBrief(engineOutput, definition, display, preview);
    }

    public Map<String, BriefOutput> execute(IQingModel model, AdditionalFilterDomain.AdditionalFilters additionalFilters, List<String> paramNames) {
        HashMap<String, BriefOutputDefinition> definitionMap = new HashMap<String, BriefOutputDefinition>();
        List<BriefOutputDefinition> definitions = model.getBriefOutputDefinitions();
        for (BriefOutputDefinition definition : definitions) {
            definitionMap.put(definition.getName(), definition);
        }
        IEngineOutput engineOutput = null;
        BriefOutput makeCubeError = null;
        try {
            engineOutput = this.makeCube(model, additionalFilters);
        }
        catch (AnalysisException ex) {
            makeCubeError = new BriefOutput(ex.getErrorCode(), ex.getMessage());
        }
        HashMap<String, BriefOutput> briefOutputMap = new HashMap<String, BriefOutput>();
        for (String paramName : paramNames) {
            BriefOutputDefinition definition = (BriefOutputDefinition)definitionMap.get(paramName);
            BriefOutput briefOutput = null;
            if (definition != null) {
                if (engineOutput == null) {
                    briefOutput = makeCubeError;
                } else {
                    boolean display = true;
                    boolean preview = false;
                    briefOutput = this.makeBrief(engineOutput, definition, display, preview);
                }
            }
            briefOutputMap.put(paramName, briefOutput);
        }
        return briefOutputMap;
    }

    private BriefOutput makeBrief(IEngineOutput engineOutput, BriefOutputDefinition definition, boolean display, boolean preview) {
        try {
            AbstractQingModel.parseBriefOutputExprs(definition, this.getI18nContext());
        }
        catch (BriefOutputException ex) {
            return new BriefOutput(ex.getErrorCode(), ex.getMessage());
        }
        BriefOutputExecutor briefOutputer = new BriefOutputExecutor();
        briefOutputer.setI18nContext(this.getI18nContext());
        briefOutputer.setEngineOutput(engineOutput);
        briefOutputer.setDefinition(definition);
        briefOutputer.setUsageContext(display, preview);
        BriefOutput briefOutput = briefOutputer.pickCube();
        return briefOutput;
    }
}

