/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.engine.DataSourceGreenChannel;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.exception.DataParseException;
import com.kingdee.bos.qing.core.exception.UserStoppedException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.PartValue;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractPreparedValue;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.dashboard.exception.DashboardException;
import com.kingdee.bos.qing.dashboard.exception.FilterPreparedValueException;
import com.kingdee.bos.qing.dashboard.exception.FilterPreparedValueTooManyItemsException;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourceNoDataException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.AdditionalFilterDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DashboardDomain
extends AbstractDomain {
    private static final int MAX_ITEM_COUNT = 1000;

    public DashboardDomain(AbstractDomain.IDataSourceCreator dataSourceCreator) {
        super(dataSourceCreator);
    }

    public AbstractPreparedValue getFilterPreparedValue(FilterFormalizedType type, MetaField valueMetaField, MetaField displayMetaField, MetaField orderByMetaField, boolean isOrderByAsc, Meta meta, AdditionalFilterDomain.AdditionalFilters myFilters, boolean isLightWeight) throws DashboardException, UserStoppedException {
        if (type == FilterFormalizedType.Discrete) {
            IDataSourceVisitor dataSourceVisitor = this.getDataSourceVisitor();
            return this.getDiscreteValue(dataSourceVisitor, valueMetaField, displayMetaField, orderByMetaField, isOrderByAsc, meta, myFilters, isLightWeight);
        }
        throw new RuntimeException("Modify here.");
    }

    private IDataSourceVisitor getDataSourceVisitor() throws FilterPreparedValueException {
        try {
            return this.createDataSourceVisitor();
        }
        catch (DataParseException ex) {
            throw new FilterPreparedValueException((Throwable)((Object)ex));
        }
    }

    private AbstractPreparedValue getDiscreteValue(IDataSourceVisitor dataSourceVisitor, MetaField valueMetaField, MetaField displayMetaField, MetaField orderByMetaField, boolean isOrderByAsc, Meta meta, AdditionalFilterDomain.AdditionalFilters additionalFilters, boolean isLightWeight) throws DashboardException, UserStoppedException {
        AnalyticalField valueField = DashboardDomain.createAnalyticalField(valueMetaField);
        AnalyticalField displayField = null;
        AnalyticalField orderByField = null;
        ArrayList<AnalyticalField> fields = new ArrayList<AnalyticalField>();
        fields.add(valueField);
        if (displayMetaField != null) {
            displayField = DashboardDomain.createAnalyticalField(displayMetaField);
            fields.add(displayField);
        }
        if (orderByMetaField != null) {
            orderByField = DashboardDomain.createAnalyticalField(orderByMetaField);
            fields.add(orderByField);
        }
        ValueCollector collector = new ValueCollector(valueField, displayField, orderByField, this.getI18nContext(), isOrderByAsc);
        collector.setLightWeight(isLightWeight);
        Map<MetaField, List<String>> filters = DashboardDomain.createFilters(additionalFilters, meta);
        DataSourceGreenChannel greenChannel = new DataSourceGreenChannel(dataSourceVisitor);
        try {
            greenChannel.getDistinctValueWithFilter(fields, filters, collector);
        }
        catch (DataSourceNoDataException dataSourceNoDataException) {
        }
        catch (AbstractDataSourceException ex) {
            throw new FilterPreparedValueException(ex);
        }
        if (collector.isTooManyItems()) {
            throw new FilterPreparedValueTooManyItemsException();
        }
        return ((AbstractMyValueCollecter)collector).getResult();
    }

    private static AnalyticalField createAnalyticalField(MetaField metaField) {
        AnalyticalField analyticalField = new AnalyticalField();
        analyticalField.setRole("dimension");
        analyticalField.setName(metaField.getFullName());
        analyticalField.bindMetaField(metaField);
        if (DataType.DATE == metaField.getDataType()) {
            analyticalField.setPartValue(PartValue.DATE_YMD);
            analyticalField.setDateFormat("yyyy-MM-dd");
        }
        return analyticalField;
    }

    private static Map<MetaField, List<String>> createFilters(AdditionalFilterDomain.AdditionalFilters additionalFilters, Meta meta) {
        HashMap<MetaField, List<String>> filters = null;
        if (additionalFilters != null) {
            filters = new HashMap<MetaField, List<String>>(additionalFilters.getItems().size());
            Map<String, MetaField> metaFieldsMap = meta.createSearchingMap();
            for (AdditionalFilterDomain.AdditionalFilterItem item : additionalFilters.getItems()) {
                MetaField mf = metaFieldsMap.get(item.getMetaFieldFullName());
                if (mf == null || !mf.getDataType().name().equals(item.getValueDataType())) continue;
                List<String> selecteds = item.getSelectedValue();
                filters.put(mf, selecteds);
            }
        }
        return filters;
    }

    public static enum FilterFormalizedType {
        Discrete;

    }

    private static class ValueCollector
    extends AbstractMyValueCollecter {
        private String _valueFieldName;
        private String _displayFieldName;
        private String _orderByFieldName;
        private FilterPreparedValueGainer.SharedMultiValueGainer _gainer;

        public ValueCollector(AnalyticalField valueField, AnalyticalField displayField, AnalyticalField orderByField, II18nContext i18nCtx, boolean isAsc) {
            this._valueFieldName = valueField.getName();
            this._displayFieldName = displayField == null ? null : displayField.getName();
            this._orderByFieldName = orderByField == null ? null : orderByField.getName();
            this._gainer = new FilterPreparedValueGainer.SharedMultiValueGainer(valueField, displayField, orderByField, i18nCtx);
            this._gainer.setToSort(true);
            this._gainer.setAsc(isAsc);
            this._gainer.setEmptyAheadAlways(false);
        }

        @Override
        public void accept(Map<String, Object> values) {
            Object value = values.get(this._valueFieldName);
            Object display = this._displayFieldName == null ? null : values.get(this._displayFieldName);
            Object orderBy = this._orderByFieldName == null ? null : values.get(this._orderByFieldName);
            this._gainer.gain(value, display, orderBy);
        }

        @Override
        public boolean isBreak() {
            if (this.isLightWeight() && this._gainer.getItemsCount() > 1000) {
                this.setTooManyItems(true);
                return true;
            }
            return false;
        }

        @Override
        public AbstractPreparedValue getResult() {
            return this._gainer.getFruit().getPreparedValue();
        }
    }

    private static abstract class AbstractMyValueCollecter
    extends DataSourceGreenChannel.AbstractValueCollecter {
        private boolean _isLightWeight = true;
        private boolean _isTooManyItems = false;

        private AbstractMyValueCollecter() {
        }

        public final void setLightWeight(boolean isLightWeight) {
            this._isLightWeight = isLightWeight;
        }

        protected final boolean isLightWeight() {
            return this._isLightWeight;
        }

        public final boolean isTooManyItems() {
            return this._isTooManyItems;
        }

        protected final void setTooManyItems(boolean isTooManyItems) {
            this._isTooManyItems = isTooManyItems;
        }

        public abstract AbstractPreparedValue getResult();
    }
}

