/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.runner.square.EngineRunnerForFilterPreparedValue;
import com.kingdee.bos.qing.core.engine.runner.square.EngineRunnerForRelativedFilterPreparedValue;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.square.FilterItem;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractPreparedValue;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.AbstractFilterDomain;
import com.kingdee.bos.qing.monitor.ICorrespondent;
import java.util.List;

public class SquareFilterDomain
extends AbstractFilterDomain {
    public SquareFilterDomain(AbstractDomain.IDataSourceCreator dataSourceCreator) {
        super(dataSourceCreator);
    }

    public AbstractPreparedValue getFilterPreparedValue(SquareModel model, AnalyticalField field) throws AnalysisException {
        boolean isFilteredByOthers = false;
        boolean isAffected = false;
        AbstractAnalyticalFilter myFilter = null;
        List<FilterItem> filterItems = model.getFilters();
        if (filterItems != null) {
            for (FilterItem item : filterItems) {
                AbstractAnalyticalFilter filter = item.getFilter();
                if (item.getField().isSame(field)) {
                    isAffected = filter.isAffected();
                    myFilter = filter;
                    continue;
                }
                if (filter.isFullValue()) continue;
                isFilteredByOthers = true;
            }
        }
        return super.getFilterPreparedValue(model, field, myFilter, isFilteredByOthers, isAffected);
    }

    @Override
    protected FilterPreparedValueGainer.IPreparedValueFruit getAllPreparedValueByEngine(IQingModel model, AnalyticalField field, ICorrespondent correspondent) throws AnalysisException {
        SquareModel mo = (SquareModel)model;
        IDataSourceVisitor dataSourceVisitor = this.createDataSourceVisitor();
        EngineRunnerForFilterPreparedValue runnerForAll = new EngineRunnerForFilterPreparedValue(dataSourceVisitor, mo, field, this.getI18nContext());
        runnerForAll.run(correspondent);
        FilterPreparedValueGainer.IPreparedValueFruit pvfAll = runnerForAll.getPreparedValueFruits().get(0);
        return pvfAll;
    }

    @Override
    protected FilterPreparedValueGainer.IPreparedValueFruit getRelativedPreparedValue(IQingModel model, AnalyticalField field, ICorrespondent correspondent) throws AnalysisException {
        SquareModel mo = (SquareModel)model;
        IDataSourceVisitor dataSourceVisitor = this.createDataSourceVisitor();
        EngineRunnerForRelativedFilterPreparedValue runnerForRelatived = new EngineRunnerForRelativedFilterPreparedValue(dataSourceVisitor, mo, field, this.getI18nContext());
        runnerForRelatived.setTargetFilterField(field);
        runnerForRelatived.run(correspondent);
        FilterPreparedValueGainer.IPreparedValueFruit pvfRelatived = runnerForRelatived.getPreparedValueFruits().get(0);
        return pvfRelatived;
    }
}

