/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.core.brief.WarningRule;
import com.kingdee.bos.qing.core.brief.WarningRuleExecutor;
import com.kingdee.bos.qing.core.engine.IEngineOutput;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.WarningRuleException;
import com.kingdee.bos.qing.core.model.analysis.AbstractQingModel;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.common.brief.WarningRuleDefinition;
import com.kingdee.bos.qing.domain.AbstractBriefOutputDomain;
import com.kingdee.bos.qing.domain.AbstractDomain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WarningRuleDomain
extends AbstractBriefOutputDomain {
    public WarningRuleDomain(AbstractDomain.IDataSourceCreator dataSourceCreator) {
        super(dataSourceCreator);
    }

    public WarningRule execute(IQingModel model, WarningRuleDefinition definition) {
        IEngineOutput engineOutput;
        try {
            engineOutput = this.makeCube(model, null);
        }
        catch (AnalysisException ex) {
            return new WarningRule(ex.getErrorCode(), ex.getMessage());
        }
        boolean preview = true;
        return this.makeBrief(engineOutput, definition, preview);
    }

    public Map<String, WarningRule> execute(IQingModel model, List<String> warningRuleNames) {
        HashMap<String, WarningRuleDefinition> definitionMap = new HashMap<String, WarningRuleDefinition>();
        List<WarningRuleDefinition> definitions = model.getWarningRuleDefinitions();
        for (WarningRuleDefinition definition : definitions) {
            definitionMap.put(definition.getName(), definition);
        }
        IEngineOutput engineOutput = null;
        WarningRule makeCubeError = null;
        try {
            engineOutput = this.makeCube(model, null);
        }
        catch (AnalysisException ex) {
            makeCubeError = new WarningRule(ex.getErrorCode(), ex.getMessage());
        }
        HashMap<String, WarningRule> warningRuleMap = new HashMap<String, WarningRule>();
        for (String name : warningRuleNames) {
            WarningRuleDefinition definition = (WarningRuleDefinition)definitionMap.get(name);
            WarningRule warningRule = null;
            if (definition != null) {
                if (engineOutput == null) {
                    warningRule = makeCubeError;
                } else {
                    boolean preview = false;
                    warningRule = this.makeBrief(engineOutput, definition, preview);
                }
            }
            warningRuleMap.put(name, warningRule);
        }
        return warningRuleMap;
    }

    private WarningRule makeBrief(IEngineOutput engineOutput, WarningRuleDefinition definition, boolean preview) {
        try {
            AbstractQingModel.parseWarningRuleExprs(definition, this.getI18nContext());
        }
        catch (WarningRuleException ex) {
            return new WarningRule(ex.getErrorCode(), ex.getMessage());
        }
        WarningRuleExecutor executor = new WarningRuleExecutor();
        executor.setI18nContext(this.getI18nContext());
        executor.setEngineOutput(engineOutput);
        executor.setDefinition(definition);
        executor.setUsageContext(preview);
        WarningRule warningRule = executor.pickCube();
        return warningRule;
    }
}

