/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart;

import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.export.chart.jsengine.IJsRtEnv;
import com.kingdee.bos.qing.export.chart.jsengine.JsEngineFactory;
import com.kingdee.bos.qing.export.chart.mock.Canvas;
import com.kingdee.bos.qing.export.chart.mock.Context2D;
import com.kingdee.bos.qing.export.chart.model.rhino.QingScriptableObject;
import com.kingdee.bos.qing.export.common.exception.ExportJavaScriptException;
import com.kingdee.bos.qing.export.common.util.JavaModelWrapUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.List;

public class JsDrawChart {
    private static volatile JsDrawChart instance = null;
    private IJsRtEnv jsRtEnv;

    private JsDrawChart() throws ExportJavaScriptException {
        HashMap<String, Object> prePutObjects = new HashMap<String, Object>();
        prePutObjects.put("com", (Object)new QingScriptableObject());
        this.jsRtEnv = JsEngineFactory.createJsEngine(prePutObjects, "/com/kingdee/bos/qing/export/chart/js/qing-common.js", "/com/kingdee/bos/qing/export/chart/js/mock.js", "/com/kingdee/bos/qing/export/chart/js/chart-model.js", "/com/kingdee/bos/qing/export/chart/js/chart-render.js", "/com/kingdee/bos/qing/export/chart/js/chart-draw.js");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsDrawChart getInstance() throws ExportJavaScriptException {
        if (instance != null) return instance;
        Class<JsDrawChart> clazz = JsDrawChart.class;
        synchronized (JsDrawChart.class) {
            if (instance != null) return instance;
            instance = new JsDrawChart();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private Context2D createContext2D(Graphics jdkGraphics, int canvasWidth, int canvasHeight) {
        Canvas htmlCanvas = new Canvas();
        htmlCanvas.width = canvasWidth;
        htmlCanvas.height = canvasHeight;
        htmlCanvas.setJdkGraphics(jdkGraphics);
        return htmlCanvas.getContext2D();
    }

    private Object executeFunction(String function, Object ... args) {
        return this.jsRtEnv.executeFunction(function, args);
    }

    public Canvas drawChart(String function, int canvasWidth, int canvasHeight, Object model, Graphics jdkGraphics, Object ... otherParams) {
        Object[] jsParams;
        Context2D ctx = this.createContext2D(jdkGraphics, canvasWidth, canvasHeight);
        int len = 4;
        if (otherParams != null) {
            int preLen = len;
            jsParams = new Object[len += otherParams.length];
            int paramsStartIndex = 0;
            for (int i = preLen; i < len; ++i) {
                jsParams[i] = otherParams[paramsStartIndex++];
            }
        } else {
            jsParams = new Object[len];
        }
        jsParams[0] = ctx;
        jsParams[1] = canvasWidth;
        jsParams[2] = canvasHeight;
        if (model != null) {
            jsParams[3] = this.executeFunction("changeStringToJsModel", model.getClass().getSimpleName(), JsonUtil.encodeToString((Object)model));
        }
        this.executeFunction(function, jsParams);
        return ctx.canvas;
    }

    public Canvas drawPie(int canvasWidth, int canvasHeight, AbstractChartModel model, String size, Graphics jdkGraphics, boolean isShowLabel, boolean isHideNegative, int iLabelType) {
        return this.drawChart("drawPie", canvasWidth, canvasHeight, model, jdkGraphics, size, isShowLabel, isHideNegative, iLabelType);
    }

    public Canvas drawHorizontalAxis(int canvasWidth, int canvasHeight, AbstractChartModel model, Graphics jdkGraphics, boolean isShowLabel, boolean isLabelInBar) {
        return this.drawChart("drawHorizontalAxis", canvasWidth, canvasHeight, model, jdkGraphics, isShowLabel, isLabelInBar);
    }

    public Canvas drawVerticalAxis(int canvasWidth, int canvasHeight, AbstractChartModel model, Graphics jdkGraphics, boolean isShowLabel, boolean isLabelInBar) {
        return this.drawChart("drawVerticalAxis", canvasWidth, canvasHeight, model, jdkGraphics, isShowLabel, isLabelInBar);
    }

    public Canvas drawVerticalBar(int canvasWidth, int canvasHeight, AbstractChartModel model, Graphics jdkGraphics, boolean isShowLabel, boolean isLabelInBar) {
        return this.drawChart("drawVerticalBar", canvasWidth, canvasHeight, model, jdkGraphics, isShowLabel, isLabelInBar);
    }

    public Canvas drawHorizontalBar(int canvasWidth, int canvasHeight, AbstractChartModel model, Graphics jdkGraphics, boolean isShowLabel, boolean isLabelInBar) {
        return this.drawChart("drawHorizontalBar", canvasWidth, canvasHeight, model, jdkGraphics, isShowLabel, isLabelInBar);
    }

    public Canvas drawLineChart(int canvasWidth, int canvasHeight, AbstractChartModel model, Graphics jdkGraphics, boolean isShowLabel) {
        return this.drawChart("drawSeparatedLineChart", canvasWidth, canvasHeight, model, jdkGraphics, isShowLabel);
    }

    public Canvas drawLineChartNumberAxis(int canvasWidth, int canvasHeight, AbstractChartModel model, Graphics jdkGraphics, boolean isShowLabel) {
        return this.drawChart("drawSeparatedLineChartNumberAxis", canvasWidth, canvasHeight, model, jdkGraphics, isShowLabel);
    }

    public Canvas drawLineChartCategoryAxis(int canvasWidth, int canvasHeight, AbstractChartModel model, Graphics jdkGraphics, boolean isShowLabel) {
        return this.drawChart("drawSeparatedLineChartCategoryAxis", canvasWidth, canvasHeight, model, jdkGraphics, isShowLabel);
    }

    public Canvas drawAreaChart(int canvasWidth, int canvasHeight, AbstractChartModel model, Graphics jdkGraphics, boolean isShowLabel) {
        return this.drawChart("drawSeparatedAreaChart", canvasWidth, canvasHeight, model, jdkGraphics, isShowLabel);
    }

    public Canvas drawAreaChartNumberAxis(int canvasWidth, int canvasHeight, AbstractChartModel model, Graphics jdkGraphics) {
        return this.drawChart("drawSeparatedAreaChartNumberAxis", canvasWidth, canvasHeight, model, jdkGraphics, new Object[0]);
    }

    public Canvas drawAreaChartCategoryAxis(int canvasWidth, int canvasHeight, AbstractChartModel model, Graphics jdkGraphics) {
        return this.drawChart("drawSeparatedAreaChartCategoryAxis", canvasWidth, canvasHeight, model, jdkGraphics, new Object[0]);
    }

    public Canvas drawHeatMap(int canvasWidth, int canvasHeight, String sColor, String size, Graphics jdkGraphics) {
        Context2D ctx = this.createContext2D(jdkGraphics, canvasWidth, canvasHeight);
        this.executeFunction("drawHeatMap", ctx, canvasWidth, canvasHeight, sColor, size);
        return ctx.canvas;
    }

    public Canvas drawHeatMap(int width, int height, String sColor, Graphics jdkGraphics) {
        return this.drawHeatMap(width, height, sColor, null, jdkGraphics);
    }

    public Canvas drawRectTree(int canvasWidth, int canvasHeight, AbstractChartModel model, Graphics jdkGraphics, float sizeRatio, boolean isShowLabel, boolean isHideNegative) {
        canvasWidth = Math.max(0, (int)((double)canvasWidth * Math.sqrt(sizeRatio) + 0.5) - 4);
        canvasHeight = Math.max(0, (int)((double)canvasHeight * Math.sqrt(sizeRatio) + 0.5) - 3);
        return this.drawChart("drawRectTree", canvasWidth, canvasHeight, model, jdkGraphics, isShowLabel, isHideNegative);
    }

    public Canvas drawScatterNumberXAxis(int canvasWidth, int canvasHeight, AbstractChartModel model, Graphics jdkGraphics) {
        return this.drawChart("drawScatterXAxis", canvasWidth, canvasHeight, model, jdkGraphics, new Object[0]);
    }

    public Canvas drawScatterNumberYAxis(int canvasWidth, int canvasHeight, AbstractChartModel model, Graphics jdkGraphics) {
        return this.drawChart("drawScatterYAxis", canvasWidth, canvasHeight, model, jdkGraphics, new Object[0]);
    }

    public Canvas drawScatterChart(int canvasWidth, int canvasHeight, AbstractChartModel model, Graphics jdkGraphics) {
        return this.drawChart("drawScatterChart", canvasWidth, canvasHeight, model, jdkGraphics, new Object[0]);
    }

    public Canvas drawSizeLegend(int canvasWidth, int canvasHeight, String[] arrRatio, String[] arrText, double iBaseDiameter, Graphics jdkGraphics) {
        Context2D ctx = this.createContext2D(jdkGraphics, canvasWidth, canvasHeight);
        this.executeFunction("drawSizeLegend", ctx, canvasWidth, JavaModelWrapUtil.wrap(arrRatio), JavaModelWrapUtil.wrap(arrText), iBaseDiameter);
        return ctx.canvas;
    }

    public Canvas drawSizeLegend(int canvasWidth, int canvasHeight, List<String> ratioList, List<String> textList, int iBaseDiameter, Graphics jdkGraphics) {
        return this.drawSizeLegend(canvasWidth, canvasHeight, this.listToArray(ratioList), this.listToArray(textList), (double)iBaseDiameter, jdkGraphics);
    }

    public Canvas drawContinuousColorLegend(int canvasWidth, int canvasHeight, String sMinText, String sMaxText, List<String> arrSegmentColor, String sColor1, String sColor2, String sPos, String sColor3, String sColor4, Graphics jdkGraphics) {
        Context2D ctx = this.createContext2D(jdkGraphics, canvasWidth, canvasHeight);
        this.executeFunction("drawContinuousColorLegend", ctx, canvasWidth, canvasHeight, sMinText, sMaxText, arrSegmentColor, sColor1, sColor2, sPos, sColor3, sColor4);
        return ctx.canvas;
    }

    public Canvas drawDiscreteColorLegend(int canvasWidth, int canvasHeight, List<String> colors, List<String> texts, List<String> captions, String sOthersText, Graphics jdkGraphics) {
        Context2D ctx = this.createContext2D(jdkGraphics, canvasWidth, canvasHeight);
        this.executeFunction("drawDiscreteColorLegend", ctx, canvasWidth, canvasHeight, JavaModelWrapUtil.wrap(this.listToArray(colors)), JavaModelWrapUtil.wrap(this.listToArray(texts)), JavaModelWrapUtil.wrap(this.listToArray(captions)), sOthersText);
        return ctx.canvas;
    }

    private String[] listToArray(List<String> stringList) {
        if (stringList == null) {
            return null;
        }
        String[] arrString = new String[stringList.size()];
        for (int i = 0; i < stringList.size(); ++i) {
            arrString[i] = stringList.get(i);
        }
        return arrString;
    }
}

