/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart.jsengine;

import com.kingdee.bos.qing.export.chart.jsengine.IJsRtEnv;
import com.kingdee.bos.qing.export.chart.mock.Console;
import com.kingdee.bos.qing.export.common.exception.ExportJavaScriptException;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;

class JdkJsEnv
implements IJsRtEnv {
    protected boolean scriptsThreadsafe;
    protected Map<String, Object> prePutObjects;
    protected String[] preloadedScripts;
    protected Invocable invokeEngine;

    public JdkJsEnv(Map<String, Object> prePutObjects, String ... preLoadJsFile) throws ExportJavaScriptException {
        this(true, prePutObjects, preLoadJsFile);
    }

    public JdkJsEnv(boolean scriptsThreadsafe, Map<String, Object> prePutObjects, String ... preloadedScripts) throws ExportJavaScriptException {
        this.scriptsThreadsafe = scriptsThreadsafe;
        this.prePutObjects = prePutObjects;
        this.preloadedScripts = preloadedScripts;
        if (scriptsThreadsafe) {
            this.invokeEngine = this.createEngine(prePutObjects, preloadedScripts);
        }
    }

    @Override
    public Object executeFunction(String functionName, Object ... functionParams) {
        try {
            if (!this.scriptsThreadsafe) {
                this.invokeEngine = this.createEngine(this.prePutObjects, this.preloadedScripts);
            }
            return this.invokeEngine.invokeFunction(functionName, functionParams);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected Invocable createEngine(Map<String, Object> prePutObjects, String ... preloadedScripts) throws ExportJavaScriptException {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
        SimpleBindings rootBindings = new SimpleBindings();
        rootBindings.put("console", (Object)new Console());
        if (prePutObjects != null) {
            for (Map.Entry<String, Object> entry : prePutObjects.entrySet()) {
                rootBindings.put(entry.getKey(), entry.getValue());
            }
        }
        engine.setBindings(rootBindings, 100);
        this.loadJsFile(engine, preloadedScripts);
        if (engine instanceof Invocable) {
            return (Invocable)((Object)engine);
        }
        throw new RuntimeException("This js engine is not Invocable!");
    }

    protected void loadJsFile(ScriptEngine engine, String ... preloadedScripts) throws ExportJavaScriptException {
        block6: {
            if (preloadedScripts == null) break block6;
            for (String preloadScript : preloadedScripts) {
                URL resource = this.getClass().getResource(preloadScript);
                InputStream inputStream = this.getClass().getResourceAsStream(preloadScript);
                if (resource == null) {
                    throw new ExportJavaScriptException("Cannot load resources " + preloadScript + ", get resource return null!");
                }
                InputStreamReader in = null;
                try {
                    in = new InputStreamReader(inputStream, "utf8");
                    engine.eval(in);
                }
                catch (Exception e) {
                    try {
                        throw new ExportJavaScriptException((Throwable)e, "Load resources " + preloadScript + " failed!");
                    }
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{in});
                        throw throwable;
                    }
                }
                CloseUtil.close((Closeable[])new Closeable[]{in});
            }
        }
    }
}

