/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart.renderer.longer;

import com.kingdee.bos.qing.core.model.analysis.longer.ChartType;
import com.kingdee.bos.qing.export.chart.renderer.longer.AbstractCellRenderer;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForArea;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForBar;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForHeatMap;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForLine;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForMultiLine;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForPie;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForRectTree;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForScatter;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForStackBar;
import java.util.HashMap;
import java.util.Map;

public class CellRendererFactory {
    private static Map<ChartType, AbstractCellRenderer> _mapInst = new HashMap<ChartType, AbstractCellRenderer>();

    public static AbstractCellRenderer getInstance(ChartType chartType) {
        AbstractCellRenderer inst = _mapInst.get((Object)chartType);
        if (inst == null) {
            throw new RuntimeException("Unsupported");
        }
        return inst;
    }

    static {
        _mapInst.put(ChartType.HeatMap, new CellRendererForHeatMap());
        _mapInst.put(ChartType.Pie, new CellRendererForPie());
        _mapInst.put(ChartType.Line, new CellRendererForLine());
        _mapInst.put(ChartType.Bar, new CellRendererForBar());
        _mapInst.put(ChartType.StackBar, new CellRendererForStackBar());
        _mapInst.put(ChartType.Area, new CellRendererForArea());
        _mapInst.put(ChartType.MultiLine, new CellRendererForMultiLine());
        _mapInst.put(ChartType.TreeMap, new CellRendererForRectTree());
        _mapInst.put(ChartType.Scatter, new CellRendererForScatter());
    }
}

