/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart.renderer.longer;

import com.kingdee.bos.qing.core.model.exhibition.common.Legends;
import com.kingdee.bos.qing.export.chart.JsDrawChart;
import com.kingdee.bos.qing.export.common.exception.ExportJavaScriptException;
import com.kingdee.bos.qing.export.common.model.ExAlign;
import com.kingdee.bos.qing.export.common.model.ExBorder;
import com.kingdee.bos.qing.export.common.model.ExStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;

public class CellRendererForLegend {
    private JsDrawChart jsChartRtEnv = JsDrawChart.getInstance();

    public void drawVerticalLegends(LegendRenderParameter parameter) {
        int legendGap = parameter.getLegendGap();
        int legendHeaderHeight = parameter.getLegendHeaderHeight();
        int moveY = parameter.getStartY();
        int discreteColorLegendY = 0;
        int continuousColorLegendY = 0;
        int sizeLegendY = 0;
        Legends legends = parameter.getLegends();
        if (legends.getDiscreteColor() != null) {
            discreteColorLegendY = moveY;
            moveY += legendHeaderHeight + parameter.getDiscreteColorLegendBodyHeight() + legendGap;
        }
        if (legends.getContinuousColor() != null) {
            continuousColorLegendY = moveY;
            moveY += legendHeaderHeight + parameter.getContinuousColorLegendBodyHeight() + legendGap;
        }
        if (legends.getSize() != null) {
            sizeLegendY = moveY;
        }
        int x = parameter.getStartX();
        this.drawLegends(parameter, x, discreteColorLegendY, x, continuousColorLegendY, x, sizeLegendY);
    }

    public void drawHorizontalLegends(LegendRenderParameter parameter) {
        int legendGap = parameter.getLegendGap();
        int legendWidth = parameter.getLegendWidth();
        int moveX = parameter.getStartX();
        int discreteColorLegendX = 0;
        int continuousColorLegendX = 0;
        int sizeLegendX = 0;
        Legends legends = parameter.getLegends();
        if (legends.getDiscreteColor() != null) {
            discreteColorLegendX = moveX;
            moveX += legendWidth + legendGap;
        }
        if (legends.getContinuousColor() != null) {
            continuousColorLegendX = moveX;
            moveX += legendWidth + legendGap;
        }
        if (legends.getSize() != null) {
            sizeLegendX = moveX;
        }
        int y = parameter.getStartY();
        this.drawLegends(parameter, discreteColorLegendX, y, continuousColorLegendX, y, sizeLegendX, y);
    }

    public void drawLegends(LegendRenderParameter parameter, int discreteColorLegendX, int discreteColorLegendY, int continuousColorLegendX, int continuousColorLegendY, int sizeLegendX, int sizeLegendY) {
        int height;
        Graphics mainGraphics = parameter.getMainGraphics();
        Legends legends = parameter.getLegends();
        Legends.DiscreteColorLegend discreteColorLegend = legends.getDiscreteColor();
        Legends.ContinuousColorLegend continuousColorLegend = legends.getContinuousColor();
        Legends.SizeLegend sizeLegend = legends.getSize();
        int legendWidth = parameter.getLegendWidth();
        int legendHeaderHeight = parameter.getLegendHeaderHeight();
        ExStyle headerStyle = parameter.getHeaderStyle();
        if (null != headerStyle) {
            headerStyle.setWidth(legendWidth);
            headerStyle.setHeight(legendHeaderHeight);
        }
        ExStyle bodyStyle = parameter.getBodyStyle();
        if (discreteColorLegend != null) {
            height = parameter.getDiscreteColorLegendBodyHeight();
            bodyStyle.setWidth(legendWidth);
            bodyStyle.setHeight(height);
            this.drawLegend((Graphics2D)mainGraphics, discreteColorLegendX, discreteColorLegendY, discreteColorLegend, parameter.getDiscreteColorLegendTitle(), headerStyle, bodyStyle);
        }
        if (continuousColorLegend != null) {
            height = parameter.getContinuousColorLegendBodyHeight();
            bodyStyle.setWidth(legendWidth);
            bodyStyle.setHeight(height);
            this.drawLegend((Graphics2D)mainGraphics, continuousColorLegendX, continuousColorLegendY, continuousColorLegend, parameter.getContinuousColorLegendTitle(), parameter.getHeaderStyle(), parameter.getBodyStyle());
        }
        if (sizeLegend != null) {
            height = parameter.getSizeLegendBodyHeight();
            bodyStyle.setWidth(legendWidth);
            bodyStyle.setHeight(height);
            this.drawLegend((Graphics2D)mainGraphics, sizeLegendX, sizeLegendY, sizeLegend, parameter.getSizeLegendTitle(), parameter.getHeaderStyle(), parameter.getBodyStyle(), parameter.getBaseDiameter());
        }
    }

    private void drawLegendHeader(Graphics2D mainGraphics, int startX, int startY, String legendTitle, ExStyle headerStyle) {
        int width = headerStyle.getWidth();
        int headerHeight = headerStyle.getHeight();
        this.drawBackground(mainGraphics, startX, startY, width, headerHeight, headerStyle.getBackgroundColor());
        mainGraphics.setColor(headerStyle.getForegroundColor());
        int textWidth = mainGraphics.getFontMetrics().stringWidth(legendTitle);
        LineMetrics lineMetrics = mainGraphics.getFont().getLineMetrics(legendTitle, mainGraphics.getFontRenderContext());
        int textHeight = Math.round((float)mainGraphics.getFont().getSize() - lineMetrics.getDescent());
        int x = this.calculateTextX(startX, width, textWidth, headerStyle.getHorizontalAlignment());
        int y = this.calculateTextY(startY, headerHeight, textHeight, headerStyle.getVerticalAlignment());
        mainGraphics.drawString(legendTitle, x, y);
        headerStyle.setWidth(width);
        headerStyle.setHeight(headerHeight);
        this.drawBorder(mainGraphics, startX, startY, headerStyle);
    }

    private void drawLegend(Graphics2D mainGraphics, int startX, int startY, Legends.ContinuousColorLegend legend, String legendTitle, ExStyle headerStyle, ExStyle bodyStyle) {
        if (legend != null) {
            int moveY = startY;
            this.drawLegendHeader(mainGraphics, startX, moveY, legendTitle, headerStyle);
            int width = bodyStyle.getWidth();
            int bodyHeight = bodyStyle.getHeight();
            this.drawBackground(mainGraphics, startX, moveY += headerStyle.getHeight(), width, bodyHeight, bodyStyle.getBackgroundColor());
            Graphics cellGraphics = mainGraphics.create(startX, moveY, width, bodyHeight);
            Legends.ContinuousColorLegend.Gradient gradient = legend.getGradientColor();
            String color1 = gradient == null ? null : gradient.getColor1();
            String color2 = gradient == null ? null : gradient.getColor2();
            String pos = gradient == null ? null : gradient.getPos();
            String color3 = gradient == null ? null : gradient.getColor3();
            String color4 = gradient == null ? null : gradient.getColor4();
            this.jsChartRtEnv.drawContinuousColorLegend(width, bodyHeight, legend.getMinText(), legend.getMaxText(), legend.getSegmentColor(), color1, color2, pos, color3, color4, cellGraphics);
            this.drawBorder(mainGraphics, startX, moveY, bodyStyle);
        }
    }

    private void drawLegend(Graphics2D mainGraphics, int startX, int startY, Legends.DiscreteColorLegend legend, String legendTitle, ExStyle headerStyle, ExStyle bodyStyle) {
        if (legend != null) {
            int moveY = startY;
            if (null != headerStyle) {
                this.drawLegendHeader(mainGraphics, startX, moveY, legendTitle, headerStyle);
                moveY += headerStyle.getHeight();
            }
            int width = bodyStyle.getWidth();
            int bodyHeight = bodyStyle.getHeight();
            this.drawBackground(mainGraphics, startX, moveY, width, bodyHeight, bodyStyle.getBackgroundColor());
            Graphics cellGraphics = mainGraphics.create(startX, moveY, width, bodyHeight);
            this.jsChartRtEnv.drawDiscreteColorLegend(width, bodyHeight, legend.getColors(), legend.getTexts(), legend.getCaptions(), legend.getOthersInfo(), cellGraphics);
            this.drawBorder(mainGraphics, startX, moveY, bodyStyle);
        }
    }

    private void drawLegend(Graphics2D mainGraphics, int startX, int startY, Legends.SizeLegend legend, String legendTitle, ExStyle headerStyle, ExStyle bodyStyle, int baseDiameter) {
        if (legend != null) {
            int moveY = startY;
            this.drawLegendHeader(mainGraphics, startX, moveY, legendTitle, headerStyle);
            int width = bodyStyle.getWidth();
            int bodyHeight = bodyStyle.getHeight();
            this.drawBackground(mainGraphics, startX, moveY += headerStyle.getHeight(), width, bodyHeight, bodyStyle.getBackgroundColor());
            Graphics cellGraphics = mainGraphics.create(startX, moveY, width, bodyHeight);
            this.jsChartRtEnv.drawSizeLegend(width, bodyHeight, legend.getRatios(), legend.getTexts(), baseDiameter, cellGraphics);
            this.drawBorder(mainGraphics, startX, moveY, bodyStyle);
        }
    }

    private void drawBackground(Graphics2D g2, int x, int y, int width, int height, Color backgroundColor) {
        if (backgroundColor != null) {
            g2.setBackground(backgroundColor);
            g2.setColor(backgroundColor);
            g2.fillRect(x + 1, y + 1, width, height);
        }
    }

    private void drawBorder(Graphics2D g2, int leftX, int upY, ExStyle style) {
        int width = style.getWidth();
        int height = style.getHeight();
        int rightX = leftX + width;
        int lowY = upY + height;
        ExBorder border = style.getBorderTop();
        if (border != null) {
            g2.setColor(border.getBorderColor());
            g2.setStroke(new BasicStroke(border.getBorderWidth()));
            g2.drawLine(leftX, upY, rightX, upY);
        }
        if ((border = style.getBorderRight()) != null) {
            g2.setColor(border.getBorderColor());
            g2.setStroke(new BasicStroke(border.getBorderWidth()));
            g2.drawLine(rightX, upY, rightX, lowY);
        }
        if ((border = style.getBorderBottom()) != null) {
            g2.setColor(border.getBorderColor());
            g2.setStroke(new BasicStroke(border.getBorderWidth()));
            g2.drawLine(leftX, lowY, rightX, lowY);
        }
        if ((border = style.getBorderLeft()) != null) {
            g2.setColor(border.getBorderColor());
            g2.setStroke(new BasicStroke(border.getBorderWidth()));
            g2.drawLine(leftX, upY, leftX, lowY);
        }
        g2.setColor(style.getForegroundColor());
    }

    private int calculateTextX(int x, int cellWidth, int textWidth, ExAlign horizontalAlignment) {
        if (ExAlign.LEFT == horizontalAlignment) {
            return x + 2;
        }
        if (ExAlign.RIGHT == horizontalAlignment) {
            return x + cellWidth - textWidth - 2;
        }
        if (ExAlign.CENTER == horizontalAlignment) {
            return x + (cellWidth >> 1) - (textWidth >> 1);
        }
        return x;
    }

    private int calculateTextY(int y, int cellHeight, int textHeight, ExAlign verticalAlignment) {
        if (ExAlign.MIDDLE == verticalAlignment) {
            return y + (cellHeight >> 1) + (textHeight >> 1);
        }
        if (ExAlign.TOP == verticalAlignment) {
            return y + textHeight + 5;
        }
        if (ExAlign.BOTTOM == verticalAlignment) {
            return y + cellHeight - 2;
        }
        return y + (cellHeight >> 1);
    }

    public static class LegendRenderParameter {
        private Legends legends;
        private int legendGap;
        private int legendWidth;
        private int legendHeaderHeight;
        private int continuousColorLegendBodyHeight;
        private int discreteColorLegendBodyHeight;
        private int sizeLegendBodyHeight;
        private Graphics mainGraphics;
        private int startX;
        private int startY;
        private String continuousColorLegendTitle;
        private String discreteColorLegendTitle;
        private String sizeLegendTitle;
        private ExStyle headerStyle;
        private ExStyle bodyStyle;
        private int baseDiameter;

        public Legends getLegends() {
            return this.legends;
        }

        public void setLegends(Legends legends) {
            this.legends = legends;
        }

        public int getLegendGap() {
            return this.legendGap;
        }

        public void setLegendGap(int legendGap) {
            this.legendGap = legendGap;
        }

        public int getLegendWidth() {
            return this.legendWidth;
        }

        public void setLegendWidth(int legendWidth) {
            this.legendWidth = legendWidth;
        }

        public int getLegendHeaderHeight() {
            return this.legendHeaderHeight;
        }

        public void setLegendHeaderHeight(int legendHeaderHeight) {
            this.legendHeaderHeight = legendHeaderHeight;
        }

        public int getContinuousColorLegendBodyHeight() {
            return this.continuousColorLegendBodyHeight;
        }

        public void setContinuousColorLegendBodyHeight(int continuousColorLegendBodyHeight) {
            this.continuousColorLegendBodyHeight = continuousColorLegendBodyHeight;
        }

        public int getDiscreteColorLegendBodyHeight() {
            return this.discreteColorLegendBodyHeight;
        }

        public void setDiscreteColorLegendBodyHeight(int discreteColorLegendBodyHeight) {
            this.discreteColorLegendBodyHeight = discreteColorLegendBodyHeight;
        }

        public int getSizeLegendBodyHeight() {
            return this.sizeLegendBodyHeight;
        }

        public void setSizeLegendBodyHeight(int sizeLegendBodyHeight) {
            this.sizeLegendBodyHeight = sizeLegendBodyHeight;
        }

        public Graphics getMainGraphics() {
            return this.mainGraphics;
        }

        public void setMainGraphics(Graphics mainGraphics) {
            this.mainGraphics = mainGraphics;
        }

        public int getStartX() {
            return this.startX;
        }

        public void setStartX(int startX) {
            this.startX = startX;
        }

        public int getStartY() {
            return this.startY;
        }

        public void setStartY(int startY) {
            this.startY = startY;
        }

        public String getContinuousColorLegendTitle() {
            return this.continuousColorLegendTitle;
        }

        public void setContinuousColorLegendTitle(String continuousColorLegendTitle) {
            this.continuousColorLegendTitle = continuousColorLegendTitle;
        }

        public String getDiscreteColorLegendTitle() {
            return this.discreteColorLegendTitle;
        }

        public void setDiscreteColorLegendTitle(String discreteColorLegendTitle) {
            this.discreteColorLegendTitle = discreteColorLegendTitle;
        }

        public String getSizeLegendTitle() {
            return this.sizeLegendTitle;
        }

        public void setSizeLegendTitle(String sizeLegendTitle) {
            this.sizeLegendTitle = sizeLegendTitle;
        }

        public ExStyle getHeaderStyle() {
            return this.headerStyle;
        }

        public void setHeaderStyle(ExStyle headerStyle) {
            this.headerStyle = headerStyle;
        }

        public ExStyle getBodyStyle() {
            return this.bodyStyle;
        }

        public void setBodyStyle(ExStyle bodyStyle) {
            this.bodyStyle = bodyStyle;
        }

        public int getBaseDiameter() {
            return this.baseDiameter;
        }

        public void setBaseDiameter(int baseDiameter) {
            this.baseDiameter = baseDiameter;
        }
    }
}

