/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart.renderer.longer;

import com.kingdee.bos.qing.core.exception.ExportException;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.core.model.exhibition.longer.cell.ChartCell;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.AxisCell;
import com.kingdee.bos.qing.export.chart.JsDrawChart;
import com.kingdee.bos.qing.export.chart.mock.Canvas;
import com.kingdee.bos.qing.export.chart.renderer.longer.AbstractCellRenderer;
import com.kingdee.bos.qing.export.common.model.ExStyle;
import com.kingdee.bos.qing.util.LogUtil;
import java.awt.Graphics;

class CellRendererForScatter
extends AbstractCellRenderer {
    CellRendererForScatter() {
    }

    @Override
    public Object draw(AbstractCellRenderer.CellRenderParameter parameter) {
        Canvas value = null;
        Object cellModel = parameter.getCellModel();
        ExStyle style = parameter.getCellStyle();
        int canvasWidth = style.getWidth();
        int canvasHeight = style.getHeight();
        Graphics jdkGraphics = parameter.getJdkGraphics();
        ICell commonCell = parameter.getCommonCell();
        AbstractChartModel modelAtCommonCell = ((ChartCell)commonCell).getChart();
        try {
            if (cellModel instanceof ChartCell) {
                AbstractChartModel modelAtCell = ((ChartCell)cellModel).getChart();
                this.fillCellModelData((MultiSeriesChartModel)modelAtCommonCell, (MultiSeriesChartModel)modelAtCell);
                value = JsDrawChart.getInstance().drawScatterChart(canvasWidth, canvasHeight, modelAtCell, jdkGraphics);
            } else if (cellModel instanceof AxisCell) {
                String direction = ((AxisCell)cellModel).getAxisDirection();
                MultiSeriesChartModel modelAtCell = new MultiSeriesChartModel();
                this.fillCellModelData((MultiSeriesChartModel)modelAtCommonCell, modelAtCell);
                if ("top".equals(direction)) {
                    value = JsDrawChart.getInstance().drawScatterNumberXAxis(canvasWidth, canvasHeight, modelAtCell, jdkGraphics);
                } else if ("left".equals(direction)) {
                    value = JsDrawChart.getInstance().drawScatterNumberYAxis(canvasWidth, canvasHeight, modelAtCell, jdkGraphics);
                }
            }
        }
        catch (ExportException e) {
            LogUtil.error((String)"Init JsDrawChart error.", (Throwable)((Object)e));
        }
        return value;
    }
}

