/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart.renderer.longer;

import com.kingdee.bos.qing.export.chart.renderer.longer.AbstractCellRenderer;
import com.kingdee.bos.qing.export.common.model.ExAlign;
import com.kingdee.bos.qing.export.common.model.ExStyle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class CellRendererForString
extends AbstractCellRenderer {
    protected int stringCellBorderPaddingTop = 5;
    protected int stringCellBorderPaddingRight = 2;
    protected int stringCellBorderPaddingBottom = 2;
    protected int stringCellBorderPaddingLeft = 2;
    protected Color defaultFontColor = Color.BLACK;

    @Override
    public Object draw(AbstractCellRenderer.CellRenderParameter parameter) {
        Object cellModel = parameter.getCellModel();
        Graphics jdkGraphics = parameter.getJdkGraphics();
        this.drawString(jdkGraphics, cellModel.toString(), parameter.getCellStyle());
        return cellModel;
    }

    protected void drawString(Graphics mainGraphics, String text, ExStyle cellStyle) {
        if (text == null || text.isEmpty()) {
            return;
        }
        int x = cellStyle.getxOffset();
        int y = cellStyle.getyOffset();
        mainGraphics.setColor(cellStyle.getForegroundColor() != null ? cellStyle.getForegroundColor() : this.defaultFontColor);
        LineMetrics lineMetrics = mainGraphics.getFont().getLineMetrics("\u7530", ((Graphics2D)mainGraphics).getFontRenderContext());
        int textHeight = Math.round((float)mainGraphics.getFont().getSize() - lineMetrics.getDescent());
        if (cellStyle.isNoWrap()) {
            this.drawStringWithoutAutoNewLine(mainGraphics, x, y, cellStyle, text, textHeight);
        } else {
            this.drawStringWithAutoNewLine(mainGraphics, x, y, cellStyle, text, textHeight);
        }
    }

    protected void drawStringWithoutAutoNewLine(Graphics mainGraphics, int x, int y, ExStyle cellStyle, String text, int textHeight) {
        int textWidth;
        Font font = cellStyle.getExFont().toAwtFont();
        if (font.isBold()) {
            Rectangle2D rectangle2D = font.getStringBounds(text, new FontRenderContext(new AffineTransform(), true, true));
            textWidth = (int)rectangle2D.getWidth();
        } else {
            textWidth = mainGraphics.getFontMetrics().stringWidth(text);
        }
        x = this.calculateTextX(x, cellStyle.getWidth(), textWidth, cellStyle.getHorizontalAlignment());
        y = this.calculateTextY(y, cellStyle.getHeight(), textHeight, cellStyle.getVerticalAlignment());
        mainGraphics.drawString(text, x, y);
    }

    protected void drawStringWithAutoNewLine(Graphics mainGraphics, int x, int y, ExStyle cellStyle, String text, int textHeight) {
        int i;
        int cellWidth;
        int charWidth = mainGraphics.getFont().getSize();
        int len = text.length();
        int textWidth = len * charWidth;
        if (textWidth <= (cellWidth = cellStyle.getWidth() - this.stringCellBorderPaddingLeft - this.stringCellBorderPaddingRight)) {
            this.drawStringWithoutAutoNewLine(mainGraphics, x, y, cellStyle, text, textHeight);
            return;
        }
        int eachLineCharNumber = cellWidth / charWidth;
        if (eachLineCharNumber == 0) {
            return;
        }
        int lineNumber = (int)Math.ceil((double)len / (double)eachLineCharNumber);
        ArrayList<String> strList = new ArrayList<String>(lineNumber);
        int index = 0;
        for (i = 0; i < lineNumber; ++i) {
            int toIndex = index + eachLineCharNumber;
            if (index + eachLineCharNumber > len) {
                toIndex = len;
            }
            strList.add(text.substring(index, toIndex));
            index = toIndex;
        }
        for (i = 0; i < strList.size(); ++i) {
            this.drawStringWithoutAutoNewLine(mainGraphics, x, y, cellStyle, (String)strList.get(i), textHeight);
            y += textHeight + 6;
        }
    }

    protected int calculateTextX(int x, int cellWidth, int textWidth, ExAlign horizontalAlignment) {
        if (ExAlign.LEFT == horizontalAlignment) {
            return x + this.stringCellBorderPaddingLeft;
        }
        if (ExAlign.RIGHT == horizontalAlignment) {
            return x + cellWidth - textWidth - this.stringCellBorderPaddingRight;
        }
        if (ExAlign.CENTER == horizontalAlignment) {
            return x + (cellWidth >> 1) - (textWidth >> 1);
        }
        return x;
    }

    protected int calculateTextY(int y, int cellHeight, int textHeight, ExAlign verticalAlignment) {
        if (ExAlign.MIDDLE == verticalAlignment) {
            return y + (cellHeight >> 1) + (textHeight >> 1);
        }
        if (ExAlign.TOP == verticalAlignment) {
            return y + textHeight + this.stringCellBorderPaddingTop;
        }
        if (ExAlign.BOTTOM == verticalAlignment) {
            return y + cellHeight - this.stringCellBorderPaddingBottom;
        }
        return y + (cellHeight >> 1);
    }
}

