/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart.renderer.square;

import com.kingdee.bos.qing.core.exception.ExportException;
import com.kingdee.bos.qing.export.common.exception.ExportIOException;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ChartImgGeneratorForGIS {
    public void writeImg(IQingFile exportFile) throws ExportException {
        InputStream fileInputStream = null;
        try {
            fileInputStream = ChartImgGeneratorForGIS.class.getResourceAsStream("gis_chart_thumbnail.png");
            final BufferedImage gisBufferedImage = ImageIO.read(fileInputStream);
            exportFile.write(new IWriteCall(){

                public void call(OutputStream outputStream) throws IOException {
                    ImageIO.write((RenderedImage)gisBufferedImage, "png", outputStream);
                }
            }, true);
        }
        catch (FileNotFoundException e) {
            throw new ExportIOException("WriteImg error!", e);
        }
        catch (IOException e) {
            throw new ExportIOException("WriteImg error!", e);
        }
        finally {
            this.closeStream(fileInputStream);
        }
    }

    private void closeStream(InputStream inputStream) throws ExportIOException {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new ExportIOException("Close InputStream error!", e);
            }
        }
    }
}

