/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.common.diagonal;

import com.kingdee.bos.qing.export.common.diagonal.DiagonalInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class DiagonalRender {
    private static Color DEFAULT_LINE_COLOR = new Color(215, 226, 226);
    private double[][] ADJUST_RANGE = new double[][]{{0.17453292519943295, 0.1}, {0.2617993877991494, 0.2}, {0.3490658503988659, 0.3}, {0.5235987755982988, 0.4}, {1.5707963267948966, 0.5}};
    private double[][] ADJUST_RANGE_FOR_LEAN = new double[][]{{0.3490658503988659, 0.2}, {0.5235987755982988, 0.3}, {0.6283185307179586, 0.4}, {0.7853981633974483, 0.6}, {1.5707963267948966, 0.7}};
    private double translateX = 0.0;
    private double translateY = 0.0;
    private float lineWidth = 1.0f;

    public void draw(Graphics g, Shape clip, DiagonalInfo info) {
        Point2D point2d;
        int i;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Point2D startPoint = info.getStartPoint();
        g2d.setColor(info.getBgColor());
        Rectangle2D boudns2D = clip.getBounds2D();
        g2d.fillRect(0, 0, (int)boudns2D.getWidth(), (int)boudns2D.getHeight());
        Point2D[] rowPoint = info.getRowPoint();
        Point2D[] colPoint = info.getColPoint();
        g2d.setStroke(new BasicStroke(this.lineWidth));
        for (i = 1; i < rowPoint.length; ++i) {
            point2d = rowPoint[i];
            this.drawLine(g2d, startPoint, point2d, DEFAULT_LINE_COLOR);
        }
        for (i = 1; i < colPoint.length - 1; ++i) {
            point2d = colPoint[i];
            this.drawLine(g2d, startPoint, point2d, DEFAULT_LINE_COLOR);
        }
        this.drawText(g2d, boudns2D, info);
    }

    private void drawLine(Graphics2D g2d, Point2D startPoint, Point2D endPoint, Color color) {
        Line2D.Double line = new Line2D.Double();
        line.setLine(startPoint, endPoint);
        g2d.setColor(color);
        g2d.draw(line);
    }

    private void drawText(Graphics2D g2d, Rectangle2D bounds2d, DiagonalInfo info) {
        Point2D[] rowPoint = info.getRowPoint();
        Point2D[] colPoint = info.getColPoint();
        List<String> titles = info.getTitles();
        List<Point2D[]> pickTriangles = this.pickTriangles(rowPoint, colPoint);
        g2d.translate(0, 0);
        g2d.setColor(Color.black);
        AffineTransform transform = g2d.getTransform();
        for (int i = 0; i < pickTriangles.size(); ++i) {
            Point2D[] point2ds = pickTriangles.get(i);
            Point2D weightPoint = this.getWeightPoint(point2ds);
            double numRotate = this.getRotate(weightPoint);
            if (info.isLean(i)) {
                this.paintTextLean(g2d, titles.get(i), weightPoint, point2ds[1], numRotate);
            } else {
                this.paintText(g2d, titles.get(i), weightPoint, numRotate);
            }
            g2d.setTransform(transform);
        }
    }

    private List<Point2D[]> pickTriangles(Point2D[] rowPoint, Point2D[] colPoint) {
        Point2D[] triangle;
        int i;
        ArrayList<Point2D[]> triangles = new ArrayList<Point2D[]>(rowPoint.length + colPoint.length);
        Point2D.Double oBasePoint = new Point2D.Double(0.0, 0.0);
        for (i = 0; i < rowPoint.length - 1; ++i) {
            triangle = new Point2D[]{oBasePoint, rowPoint[i], rowPoint[i + 1]};
            triangles.add(triangle);
        }
        for (i = colPoint.length - 1; i > 0; --i) {
            triangle = new Point2D[]{oBasePoint, colPoint[i], colPoint[i - 1]};
            triangles.add(triangle);
        }
        return triangles;
    }

    private Point2D getWeightPoint(Point2D[] triangle) {
        Point2D basePoint = triangle[0];
        Point2D pointA = triangle[1];
        Point2D pointB = triangle[2];
        double iX = Math.floor((basePoint.getX() + pointA.getX() + pointB.getX()) / 3.0 + 0.5);
        double iY = Math.floor((basePoint.getY() + pointA.getY() + pointB.getY()) / 3.0 + 0.5);
        Point2D.Double weightPoint = new Point2D.Double(iX, iY);
        return weightPoint;
    }

    private double getRotate(Point2D oWeightPoint) {
        double[] oBasePoint = new double[]{0.0, 0.0};
        double iDeltaX = oWeightPoint.getX() - oBasePoint[0];
        if (iDeltaX == 0.0) {
            return 1.5707963267948966;
        }
        double iDeltaY = oWeightPoint.getY() - oBasePoint[1];
        double numRotate = Math.atan(iDeltaY / iDeltaX);
        return numRotate;
    }

    private double[] getStartOffsetFromCenterPoint(Graphics2D g2d, String sText, boolean isLean, double numRotate) {
        double[][] arrAdjust = isLean ? this.ADJUST_RANGE_FOR_LEAN : this.ADJUST_RANGE;
        double numRotateAbs = Math.abs(numRotate);
        double numAdjustRate = 0.5;
        for (int i = 0; i < arrAdjust.length; ++i) {
            if (!(numRotateAbs <= arrAdjust[i][0])) continue;
            numAdjustRate = arrAdjust[i][1];
            break;
        }
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D stringBounds = fm.getStringBounds(sText, g2d);
        double numOffsetX = -stringBounds.getWidth() * numAdjustRate;
        stringBounds = fm.getStringBounds("\u58f9", g2d);
        double numOffsetY = stringBounds.getWidth() * 0.5;
        double[] result = new double[]{numOffsetX, numOffsetY};
        return result;
    }

    private void paintText(Graphics2D g2d, String sText, Point2D centerPoint, double numRotate) {
        double[] oOffset = this.getStartOffsetFromCenterPoint(g2d, sText, false, numRotate);
        double numX = centerPoint.getX() + oOffset[0];
        double numY = centerPoint.getY() + oOffset[1];
        g2d.drawString(sText, (int)numX, (int)numY);
    }

    private void paintTextLean(Graphics2D g2d, String sText, Point2D centerPoint, Point2D lastPoint, double numRotate) {
        boolean bAllAsciiChar = true;
        for (int i = 0; i < sText.length(); ++i) {
            if (sText.charAt(i) <= '\u007f') continue;
            bAllAsciiChar = false;
            break;
        }
        double iCenterX = centerPoint.getX();
        double iCenterY = centerPoint.getY();
        g2d.translate(iCenterX, iCenterY);
        g2d.rotate(numRotate);
        double[] oOffset = this.getStartOffsetFromCenterPoint(g2d, sText, true, numRotate);
        g2d.translate((int)oOffset[0], (int)oOffset[1]);
        if (bAllAsciiChar) {
            g2d.drawString(sText, (int)this.translateX, (int)this.translateY);
        } else {
            int iWidthStep = 0;
            char[] cChar = sText.toCharArray();
            for (int i = 0; i < cChar.length; ++i) {
                g2d.translate(iWidthStep, 0);
                g2d.rotate(-numRotate);
                g2d.drawChars(cChar, i, 1, 0, 0);
                g2d.rotate(numRotate);
                FontMetrics fm = g2d.getFontMetrics();
                Rectangle2D stringBounds = fm.getStringBounds(String.valueOf(cChar[i]), g2d);
                iWidthStep = (int)stringBounds.getWidth();
            }
        }
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }
}

