/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.common.model;

import com.kingdee.bos.qing.export.common.exception.ExportFontException;
import com.kingdee.bos.qing.export.common.util.UnitUtil;
import com.kingdee.bos.qing.export.pdf.ExFontMapper;
import com.kingdee.bos.qing.util.LogUtil;
import java.awt.Font;
import java.awt.GraphicsEnvironment;

public class ExFont {
    private static String defaultFontName = "Microsoft YaHei";
    private static int defaultFontSize = 9;
    private static volatile ExFontMapper exFontMapper;
    private static volatile Font defaultAwtFont;
    private String fontName = defaultFontName;
    private int fontSize = defaultFontSize;
    private int fontStyle = 0;
    private Font font;

    private static synchronized void initFontMapper() {
        exFontMapper = new ExFontMapper();
        try {
            defaultAwtFont = exFontMapper.getAwtFontByName(defaultFontName);
            if (!defaultFontName.equals(defaultAwtFont.getName())) {
                defaultFontName = ExFontMapper.getDefaultFontName();
            }
            LogUtil.info((String)("ExFont defaultFontName: " + defaultFontName));
        }
        catch (ExportFontException e) {
            LogUtil.error((String)"\u5b57\u4f53mapper \u521d\u59cb\u5316\u9519\u8bef", (Throwable)((Object)e));
        }
    }

    public static Font getDefaultAwtFont() {
        return defaultAwtFont;
    }

    public Font toAwtFont() {
        if (this.font != null) {
            return this.font;
        }
        float fontSizePx = (float)this.fontSize * UnitUtil.getCurrentDpi() / 72.0f;
        this.font = !this.checkFontName(this.fontName) ? new Font(defaultFontName, this.fontStyle, (int)fontSizePx) : new Font(this.fontName, this.fontStyle, (int)fontSizePx);
        return this.font;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    private boolean checkFontName(String fontName) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = e.getAvailableFontFamilyNames();
        for (int i = 0; i < fontNames.length; ++i) {
            if (!fontName.equals(fontNames[i])) continue;
            return true;
        }
        return false;
    }

    static {
        ExFont.initFontMapper();
    }
}

