/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.common.model;

import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.model.SquareResultWrapper;
import com.kingdee.bos.qing.core.model.analysis.square.SquareChartType;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.AbstractChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.common.Legends;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.SingleSeriesChartModel;
import com.kingdee.bos.qing.core.model.exhibition.square.GridChartModel;
import com.kingdee.bos.qing.core.model.exhibition.square.SquareView;
import com.kingdee.bos.qing.domain.SquareExecuteDomain;
import com.kingdee.bos.qing.export.chart.renderer.longer.CellRendererForLegend;
import com.kingdee.bos.qing.export.common.model.ExAlign;
import com.kingdee.bos.qing.export.common.model.ExFont;
import com.kingdee.bos.qing.export.common.model.ExStyle;
import java.awt.Color;

public class SquareViewAdapter {
    private SquareView squareView;
    private AbstractChartProperty chartProperty;
    private static ExFont DEFAULT_FONT = new ExFont();
    private ExFont font = DEFAULT_FONT;
    private int width = 300;
    private int height = 150;
    private int legendNumber = -1;
    private int legendWidth;
    private int legendGap = 9;
    private int discreteColorLegendBodyHeight;

    public SquareViewAdapter(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void exeFromModel(SquareModel model, SquareExecuteDomain executeDomain) throws AnalysisException {
        SquareResultWrapper result = executeDomain.execute(model);
        this.squareView = result.getSquareView();
        this.initLegendHeight();
        this.chartProperty = model.getChartModel().getChartProperty();
    }

    public boolean isChartMap() {
        return this.squareView.getChartType() == SquareChartType.Map;
    }

    public boolean isChartGIS() {
        return this.squareView.getChartType() == SquareChartType.GIS;
    }

    public AbstractChartProperty getProperty() {
        return this.chartProperty;
    }

    public AbstractChartModel getChartModel() {
        return this.squareView.getChart();
    }

    public SquareChartType getChartType() {
        return this.squareView.getChartType();
    }

    public boolean isNothingDisplay() {
        AbstractChartModel chartModel = this.squareView.getChart();
        boolean nothingDisplay = false;
        if (chartModel instanceof MultiSeriesChartModel) {
            MultiSeriesChartModel mlsModel = (MultiSeriesChartModel)chartModel;
            nothingDisplay = mlsModel.getCategories().isEmpty();
        } else if (chartModel instanceof SingleSeriesChartModel) {
            SingleSeriesChartModel sisModel = (SingleSeriesChartModel)chartModel;
            nothingDisplay = sisModel.getCategories().isEmpty();
        } else if (chartModel instanceof GridChartModel) {
            GridChartModel grdModel = (GridChartModel)chartModel;
            nothingDisplay = grdModel.getColumns().isEmpty();
        }
        return nothingDisplay;
    }

    private void initLegendHeight() {
        if (this.squareView.getLegends() == null) {
            return;
        }
        if (this.squareView.getLegends().getDiscreteColor() != null) {
            int iRows = this.squareView.getLegends().getDiscreteColor().getColors().size();
            if (this.squareView.getLegends().getDiscreteColor().getOthers() > 0) {
                ++iRows;
            }
            this.discreteColorLegendBodyHeight = iRows * 20;
        }
    }

    public int getLegendNumber() {
        if (this.legendNumber == -1) {
            this.legendNumber = 0;
            if (this.squareView.getLegends() != null && this.squareView.getLegends().getDiscreteColor() != null) {
                ++this.legendNumber;
            }
        }
        return this.legendNumber;
    }

    public ExFont getFont() {
        return this.font;
    }

    public CellRendererForLegend.LegendRenderParameter getLegendRenderParameter() {
        Legends legends = this.squareView.getLegends();
        CellRendererForLegend.LegendRenderParameter parameter = new CellRendererForLegend.LegendRenderParameter();
        parameter.setLegends(legends);
        parameter.setLegendGap(this.legendGap);
        parameter.setLegendWidth(this.legendWidth);
        parameter.setDiscreteColorLegendBodyHeight(this.discreteColorLegendBodyHeight);
        parameter.setBodyStyle(this.getLengendBodyStyle());
        return parameter;
    }

    private ExStyle getLengendBodyStyle() {
        ExStyle style = new ExStyle();
        style.setBackgroundColor(Color.WHITE);
        style.setHorizontalAlignment(ExAlign.LEFT);
        return style;
    }
}

