/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.image;

import com.kingdee.bos.qing.core.exception.ExportException;
import com.kingdee.bos.qing.core.exception.UserStoppedException;
import com.kingdee.bos.qing.export.common.exception.ExportIOException;
import com.kingdee.bos.qing.export.common.exception.ExportUnsupportedImageTypeException;
import com.kingdee.bos.qing.filesystem.manager.ImageWriteCall;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;

abstract class AbstractImageExport {
    protected Color backgroundColor = Color.white;
    protected String imageType;

    AbstractImageExport() {
    }

    public abstract void exportToFile(IQingFile var1) throws ExportException, UserStoppedException;

    protected int getBufferedImageType() throws ExportException {
        int iImageType = 2;
        if (!"png".equalsIgnoreCase(this.imageType)) {
            throw new ExportUnsupportedImageTypeException("Unsupported image type exception! Image type is " + this.imageType);
        }
        iImageType = 2;
        return iImageType;
    }

    protected void writeImg(BufferedImage image, IQingFile file) throws ExportException {
        try {
            file.write((IWriteCall)new ImageWriteCall(image, this.imageType), true);
        }
        catch (IOException e) {
            throw new ExportIOException("write to file error!", e);
        }
    }
}

